/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import java.util.concurrent.TimeUnit;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.ExceedingTicksFilter;
import me.lucko.spark.common.sampler.async.ProfileSegment;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.proto.SparkSamplerProtos;

public class TickedAsyncDataAggregator
extends AsyncDataAggregator {
    private final Runnable closeCallback;
    private final long tickLengthThreshold;
    private final ExceedingTicksFilter filter;

    protected TickedAsyncDataAggregator(ThreadGrouper threadGrouper, boolean ignoreSleeping, TickReporter tickReporter, int tickLengthThreshold) {
        super(threadGrouper, ignoreSleeping);
        this.tickLengthThreshold = TimeUnit.MILLISECONDS.toMicros(tickLengthThreshold);
        this.filter = new ExceedingTicksFilter(tickLengthThreshold);
        tickReporter.addCallback(this.filter);
        this.closeCallback = () -> tickReporter.removeCallback(this.filter);
    }

    @Override
    public void insertData(ProfileSegment element, int window) {
        long time = element.getTime();
        if (!this.filter.duringExceedingTick(time)) {
            return;
        }
        super.insertData(element, window);
    }

    @Override
    public SparkSamplerProtos.SamplerMetadata.DataAggregator getMetadata() {
        return (SparkSamplerProtos.SamplerMetadata.DataAggregator)SparkSamplerProtos.SamplerMetadata.DataAggregator.newBuilder().setType(SparkSamplerProtos.SamplerMetadata.DataAggregator.Type.TICKED).setThreadGrouper(this.threadGrouper.asProto()).setTickLengthThreshold(this.tickLengthThreshold).setNumberOfIncludedTicks(this.filter.exceedingTicksCount()).build();
    }

    @Override
    public void close() {
        this.closeCallback.run();
    }
}

