/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.lion.config;

import aquariusplayz.libs.config.ModConfigProvider;
import aquariusplayz.libs.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static boolean isAlwaysPersistent;
    public static int checkAreaSizeForMobsOfSameTypeWhenSpawning;
    public static int maxMobOfSameTypeAroundAreaWhenSpawning;
    public static int WEIGHT;
    public static int MIN;
    public static int MAX;
    public static String BIOMES;
    public static String BIOMES_DEFAULT;
    public static int WEIGHT_DEFAULT;
    public static float soundVolume;
    public static int playSoundDistance;
    public static int idleSoundMinInterval;
    public static int randomAttackChance;
    public static boolean enableBehaviorChatMessages;

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of((String)"animalgarden_lionconfig").provider((SimpleConfig.DefaultConfig)configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"weight", (Object)WEIGHT_DEFAULT), "int");
        configs.addKeyValuePair(new Pair((Object)"min", (Object)1), "int");
        configs.addKeyValuePair(new Pair((Object)"max", (Object)3), "int");
        configs.addKeyValuePair(new Pair((Object)"biomes", (Object)BIOMES_DEFAULT), "String");
        configs.addKeyValuePair(new Pair((Object)"is_always_persistent", (Object)isAlwaysPersistent), "boolean");
        configs.addKeyValuePair(new Pair((Object)"check_area_size_for_mobs_of_same_type_when_spawning", (Object)checkAreaSizeForMobsOfSameTypeWhenSpawning), "int");
        configs.addKeyValuePair(new Pair((Object)"max_mob_number_of_same_type_around_area_when_spawning", (Object)maxMobOfSameTypeAroundAreaWhenSpawning), "int");
        configs.addKeyValuePair(new Pair((Object)"sound_volume", (Object)Float.valueOf(soundVolume)), "float");
        configs.addKeyValuePair(new Pair((Object)"play_sound_distance", (Object)playSoundDistance), "int");
        configs.addKeyValuePair(new Pair((Object)"idle_sound_minimum_interval", (Object)idleSoundMinInterval), "int");
        configs.addKeyValuePair(new Pair((Object)"random_attack_chance", (Object)randomAttackChance), "int");
        configs.addKeyValuePair(new Pair((Object)"enable_behavior_chat_messages", (Object)true), "boolean");
    }

    private static void assignConfigs() {
        WEIGHT = CONFIG.getOrDefault("weight", WEIGHT_DEFAULT);
        MIN = CONFIG.getOrDefault("min", 1);
        MAX = CONFIG.getOrDefault("max", 3);
        BIOMES = CONFIG.getOrDefault("biomes", BIOMES_DEFAULT);
        isAlwaysPersistent = CONFIG.getOrDefault("is_always_persistent", true);
        checkAreaSizeForMobsOfSameTypeWhenSpawning = CONFIG.getOrDefault("check_area_size_for_mobs_of_same_type_when_spawning", 32);
        maxMobOfSameTypeAroundAreaWhenSpawning = CONFIG.getOrDefault("max_mob_number_of_same_type_around_area_when_spawning", 1);
        soundVolume = CONFIG.getOrDefault("sound_volume", 0.2f);
        playSoundDistance = CONFIG.getOrDefault("play_sound_distance", 30);
        idleSoundMinInterval = CONFIG.getOrDefault("idle_sound_minimum_interval", 8);
        randomAttackChance = CONFIG.getOrDefault("random_attack_chance", 1000);
        enableBehaviorChatMessages = CONFIG.getOrDefault("enable_behavior_chat_messages", true);
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        isAlwaysPersistent = true;
        checkAreaSizeForMobsOfSameTypeWhenSpawning = 16;
        maxMobOfSameTypeAroundAreaWhenSpawning = 3;
        BIOMES = "savanna,savanna_plateau,windswept_savanna";
        BIOMES_DEFAULT = "savanna,savanna_plateau,windswept_savanna";
        WEIGHT_DEFAULT = 10;
        soundVolume = 0.3f;
        playSoundDistance = 20;
        idleSoundMinInterval = 20;
        randomAttackChance = 1000;
        enableBehaviorChatMessages = true;
    }
}

