/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.network.client.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.DynamicOps;
import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.config.ClientConfig;
import fuzs.statuemenus.api.v1.helper.ScaleAttributeHelper;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.StatueHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueAlignment;
import fuzs.statuemenus.api.v1.world.inventory.data.StatuePose;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueStyleOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class CommandDataSyncHandler
implements DataSyncHandler {
    public static final String FINISHED_TRANSLATION_KEY = ArmorStatues.id("finished").method_42093("data_sync");
    public static final String FAILURE_TRANSLATION_KEY = ArmorStatues.id("failure").method_42093("data_sync");
    public static final String NO_PERMISSION_TRANSLATION_KEY = ArmorStatues.id("failure").method_48747("data_sync", "no_permission");
    public static final String NO_ARMOR_STAND_TRANSLATION_KEY = ArmorStatues.id("failure").method_48747("data_sync", "no_armor_stand");
    public static final String OUT_OF_RANGE_TRANSLATION_KEY = ArmorStatues.id("failure").method_48747("data_sync", "out_of_range");
    public static final String NOT_FINISHED_TRANSLATION_KEY = ArmorStatues.id("failure").method_48747("data_sync", "not_finished");
    private static final Queue<List<String>> CLIENT_COMMAND_QUEUE = new ArrayDeque<List<String>>();
    @Nullable
    private static class_1309 queueArmorStand;
    private static int itemDequeuedTicks;
    private final StatueHolder holder;
    protected final class_746 player;
    protected StatuePose lastSyncedPose;

    public CommandDataSyncHandler(StatueHolder holder, class_746 player) {
        this.holder = holder;
        this.lastSyncedPose = StatuePose.fromEntity((StatueEntity)this.holder.getStatueEntity());
        this.player = player;
    }

    public StatueHolder getArmorStandHolder() {
        return this.holder;
    }

    public void sendName(String name) {
        if (!this.isEditingAllowed()) {
            return;
        }
        DataSyncHandler.setCustomArmorStandName((class_1309)this.getEntity(), (String)name);
        class_2487 compoundTag = new class_2487();
        compoundTag.method_68081("CustomName", class_8824.field_46597, (DynamicOps)this.player.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2561.method_43470((String)name));
        this.enqueueEntityData(compoundTag);
        this.finalizeCurrentOperation();
    }

    public void sendPose(StatuePose pose, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeBodyPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeArmPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeLegPoses(arg_0, arg_1), this.lastSyncedPose);
        pose.applyToEntity(this.getArmorStandHolder().getStatueEntity());
        this.lastSyncedPose = pose.copyAndFillFrom(this.lastSyncedPose);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private void sendPosePart(BiConsumer<class_2487, StatuePose> dataWriter, StatuePose lastSyncedPose) {
        class_2487 compoundTag = new class_2487();
        dataWriter.accept(compoundTag, lastSyncedPose);
        if (!compoundTag.method_33133()) {
            class_2487 tagToSend = new class_2487();
            tagToSend.method_10566("Pose", (class_2520)compoundTag);
            this.enqueueEntityData(tagToSend);
        }
    }

    @Nullable
    public StatuePose getLastSyncedPose() {
        return this.lastSyncedPose;
    }

    public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2499 listTag = new class_2499();
        listTag.add((Object)class_2489.method_23241((double)posX));
        listTag.add((Object)class_2489.method_23241((double)posY));
        listTag.add((Object)class_2489.method_23241((double)posZ));
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("Pos", (class_2520)listTag);
        this.enqueueEntityData(compoundTag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendScale(float scale, boolean finalize) {
        this.sendScale(true, scale, finalize);
    }

    public void sendScale(boolean hasModifier, float scale, boolean finalize) {
        ArrayList<String> clientCommands = new ArrayList<String>();
        if (hasModifier) {
            clientCommands.add("attribute %s %s modifier remove %s".formatted(this.getEntity().method_5845(), ((class_5321)class_5134.field_47760.method_40230().orElseThrow()).method_29177(), ScaleAttributeHelper.SCALE_BONUS_ID));
        }
        if (scale != ScaleAttributeHelper.DEFAULT_SCALE) {
            clientCommands.add("attribute %s %s modifier add %s %s add_value".formatted(this.getEntity().method_5845(), ((class_5321)class_5134.field_47760.method_40230().orElseThrow()).method_29177(), ScaleAttributeHelper.SCALE_BONUS_ID, Float.valueOf(scale - ScaleAttributeHelper.DEFAULT_SCALE)));
        }
        this.enqueueClientCommand(clientCommands);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendRotation(float rotation, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2499 listTag = new class_2499();
        listTag.add((Object)class_2494.method_23244((float)rotation));
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("Rotation", (class_2520)listTag);
        this.enqueueEntityData(compoundTag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendStyleOption(StatueStyleOption<?> styleOption, boolean value, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2487 compoundTag = new class_2487();
        styleOption.toTag(compoundTag, value);
        this.enqueueEntityData(compoundTag);
        styleOption.setOption(this.getEntity(), value);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendAlignment(StatueAlignment alignment) {
        if (!this.isEditingAllowed()) {
            return;
        }
        super.sendAlignment(alignment);
    }

    public boolean supportsScreenType(StatueScreenType screenType) {
        return !screenType.requiresServer();
    }

    public void tick() {
        if (itemDequeuedTicks > 0) {
            --itemDequeuedTicks;
        }
        if (itemDequeuedTicks == 0 && queueArmorStand != null && !CLIENT_COMMAND_QUEUE.isEmpty()) {
            if (this.testArmorStand(queueArmorStand).right().isPresent()) {
                for (String clientCommand : CLIENT_COMMAND_QUEUE.poll()) {
                    this.player.field_3944.method_45730(clientCommand);
                }
            } else {
                CLIENT_COMMAND_QUEUE.clear();
            }
            itemDequeuedTicks = this.getDequeueDelayTicks();
        } else if (itemDequeuedTicks == 1 && CLIENT_COMMAND_QUEUE.isEmpty()) {
            this.sendDisplayMessage((class_2561)class_2561.method_43471((String)FINISHED_TRANSLATION_KEY), false);
        }
    }

    protected int getDequeueDelayTicks() {
        return 5;
    }

    public boolean shouldContinueTicking() {
        return !CLIENT_COMMAND_QUEUE.isEmpty() || itemDequeuedTicks != 0;
    }

    protected boolean isEditingAllowed() {
        return this.isEditingAllowed(!((ClientConfig)ArmorStatues.CONFIG.get(ClientConfig.class)).overrideClientPermissionsCheck);
    }

    protected final boolean isEditingAllowed(boolean testPermissionLevel) {
        if (testPermissionLevel && !this.player.method_64475(2)) {
            this.sendFailureMessage((class_2561)class_2561.method_43471((String)NO_PERMISSION_TRANSLATION_KEY));
            return false;
        }
        return this.player.method_31549().field_7476 && this.testArmorStand(this.getEntity()).ifLeft(this::sendFailureMessage).right().isPresent();
    }

    protected Either<class_2561, Unit> testArmorStand(class_1309 livingEntity) {
        return !livingEntity.method_5805() ? Either.left((Object)class_2561.method_43471((String)NO_ARMOR_STAND_TRANSLATION_KEY)) : Either.right((Object)Unit.INSTANCE);
    }

    protected boolean enqueueClientCommand(String clientCommand) {
        return this.enqueueClientCommand(Collections.singletonList(clientCommand));
    }

    protected boolean enqueueClientCommand(List<String> clientCommand) {
        if (CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = null;
        } else if (queueArmorStand != null) {
            this.sendFailureMessage((class_2561)class_2561.method_43471((String)NOT_FINISHED_TRANSLATION_KEY));
            return false;
        }
        CLIENT_COMMAND_QUEUE.offer(clientCommand);
        return true;
    }

    public void finalizeCurrentOperation() {
        if (!CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = this.getEntity();
        }
    }

    protected void sendFailureMessage(class_2561 component) {
        this.sendDisplayMessage((class_2561)class_2561.method_43469((String)FAILURE_TRANSLATION_KEY, (Object[])new Object[]{component}), true);
    }

    protected void sendDisplayMessage(class_2561 component, boolean failure) {
        this.player.method_7353((class_2561)class_2561.method_43473().method_10852(component).method_27692(failure ? class_124.field_1061 : class_124.field_1060), false);
    }

    private void enqueueEntityData(class_2487 compoundTag) {
        this.enqueueClientCommand("data merge entity %s %s".formatted(this.getEntity().method_5845(), compoundTag));
    }
}

