/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.cycling;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.controllers.cycling.ICyclingController;
import dev.isxander.yacl3.gui.utils.KeyUtils;
import net.minecraft.class_11876;
import net.minecraft.class_332;

public class CyclingControllerElement
extends ControllerWidget<ICyclingController<?>> {
    public CyclingControllerElement(ICyclingController<?> control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    @Override
    protected void drawValueText(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.drawValueText(graphics, mouseX, mouseY, delta);
        if (this.hovered) {
            graphics.method_74037(this.isAvailable() ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    public void cycleValue(int increment) {
        int targetIdx = ((ICyclingController)this.control).getPendingValue() + increment;
        if (targetIdx >= ((ICyclingController)this.control).getCycleLength()) {
            targetIdx -= ((ICyclingController)this.control).getCycleLength();
        } else if (targetIdx < 0) {
            targetIdx += ((ICyclingController)this.control).getCycleLength();
        }
        ((ICyclingController)this.control).setPendingValue(targetIdx);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY) || button != 0 && button != 1 || !this.isAvailable()) {
            return false;
        }
        this.playDownSound();
        this.cycleValue(button == 1 || KeyUtils.hasShiftDown() || KeyUtils.hasControlDown() ? -1 : 1);
        return true;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.focused) {
            return false;
        }
        switch (keyCode) {
            case 263: {
                this.cycleValue(-1);
                break;
            }
            case 262: {
                this.cycleValue(1);
                break;
            }
            case 32: 
            case 257: 
            case 335: {
                this.cycleValue(KeyUtils.hasControlDown(modifiers) || KeyUtils.hasShiftDown(modifiers) ? -1 : 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected int getHoveredControlWidth() {
        return this.getUnhoveredControlWidth();
    }
}

