/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Decoder;
import io.github.maxencedc.sparsestructures.IdBasedSalt;
import io.github.maxencedc.sparsestructures.SparseStructuresCommon;
import io.github.maxencedc.sparsestructures.StructureSetsSet;
import net.minecraft.class_2385;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7655;
import net.minecraft.class_9248;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_7655.class})
public class MakeStructuresSparse {
    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")}, method={"loadElementFromResource"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static <E> void loadElementFromResource(class_2385<E> registry, Decoder<E> codec, class_6903<JsonElement> ops, class_5321<E> resourceKey, class_3298 resource, class_9248 registrationInfo, CallbackInfo ci, @Local JsonElement jsonElement) {
        int separation;
        String string = registry.method_46765().method_29177().method_12832();
        if (!string.equals("worldgen/structure_set")) {
            return;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonObject placement = jsonObject.getAsJsonObject("placement");
        if (placement.get("type").getAsString().equals("minecraft:concentric_rings")) {
            return;
        }
        StructureSetsSet.addStructureSet(resourceKey.method_29177().toString());
        double factor = SparseStructuresCommon.config.getSpreadFactor(resourceKey, jsonObject);
        if (factor == 0.0) {
            placement.addProperty("frequency", (Number)0.0);
            return;
        }
        int spacing = placement.get("spacing") == null ? 1 : (int)(placement.get("spacing").getAsDouble() * factor);
        int n = separation = placement.get("separation") == null ? 1 : (int)(placement.get("separation").getAsDouble() * factor);
        if (separation >= spacing) {
            spacing = Math.max(1, spacing);
            separation = spacing - 1;
        }
        placement.addProperty("spacing", (Number)spacing);
        placement.addProperty("separation", (Number)separation);
        if (SparseStructuresCommon.config.idBasedSalt()) {
            int salt = IdBasedSalt.getSalt(resourceKey.method_29177().toString());
            placement.addProperty("salt", (Number)salt);
        }
    }
}

