/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFileStorage;
import net.minecraft.class_10177;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_3847;
import net.minecraft.class_3902;

public class CacheWorker
implements AutoCloseable {
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final class_10177 consecutiveExecutor;
    private final CacheFileStorage storage;
    private final Map<class_1923, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected CacheWorker(Path path, boolean async) {
        this.storage = new CacheFileStorage(path, async);
        this.consecutiveExecutor = new class_10177(Priority.values().length, (Executor)class_156.method_27958(), "JM-Cache");
    }

    public CompletableFuture<Void> store(class_1923 chunkPos, @Nullable class_2487 chunkData) {
        return this.store(chunkPos, () -> chunkData);
    }

    @Nullable
    public CompletableFuture<Void> store(class_1923 p_360728_, Supplier<class_2487> p_361805_) {
        return this.submitTask(() -> {
            class_2487 compoundtag = (class_2487)p_361805_.get();
            PendingStore ioworker$pendingstore = this.pendingWrites.computeIfAbsent(p_360728_, p_223488_ -> new PendingStore(compoundtag));
            ioworker$pendingstore.data = compoundtag;
            return ioworker$pendingstore.result;
        }).thenCompose(Function.identity());
    }

    @Nullable
    public class_2487 load(class_1923 chunkPos) throws IOException {
        CompletableFuture<Optional<class_2487>> future = this.loadAsync(chunkPos);
        try {
            return future.join().orElse(null);
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<Optional<class_2487>> loadAsync(class_1923 chunkPos) {
        return this.submitThrowingTask(() -> {
            PendingStore ioworker$pendingstore = this.pendingWrites.get(chunkPos);
            if (ioworker$pendingstore != null) {
                return Optional.ofNullable(ioworker$pendingstore.copyData());
            }
            class_2487 compoundtag = this.storage.read(chunkPos);
            return Optional.ofNullable(compoundtag);
        });
    }

    public CompletableFuture<Void> synchronize(boolean flushStorage) {
        CompletionStage completablefuture = this.submitTask(() -> CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(p_223475_ -> p_223475_.result).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        return flushStorage ? ((CompletableFuture)completablefuture).thenCompose(p_371174_ -> this.submitThrowingTask(() -> {
            this.storage.flush();
            return null;
        })) : ((CompletableFuture)completablefuture).thenCompose(p_223477_ -> this.submitTask(() -> null));
    }

    private <T> CompletableFuture<T> submitThrowingTask(ThrowingSupplier<T> p_371938_) {
        return this.consecutiveExecutor.method_63599(Priority.FOREGROUND.ordinal(), p_371168_ -> {
            if (!this.shutdownRequested.get()) {
                try {
                    p_371168_.complete(p_371938_.get());
                }
                catch (Exception exception) {
                    p_371168_.completeExceptionally(exception);
                }
            }
            this.tellStorePending();
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<T> task) {
        return this.consecutiveExecutor.method_63599(Priority.FOREGROUND.ordinal(), p_371173_ -> {
            if (!this.shutdownRequested.get()) {
                p_371173_.complete(task.get());
            }
            this.tellStorePending();
        });
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<class_1923, PendingStore>> iterator = this.pendingWrites.entrySet().iterator();
            Map.Entry<class_1923, PendingStore> entry = iterator.next();
            iterator.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.consecutiveExecutor.method_63588((Runnable)new class_3847.class_3907(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(class_1923 pos, PendingStore store) {
        try {
            this.storage.write(pos, store.data);
            store.result.complete(null);
        }
        catch (Exception e) {
            store.result.completeExceptionally(e);
        }
    }

    public boolean hasChunk(class_1923 pos) {
        return this.storage.hasChunk(pos);
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.waitForShutdown();
            this.consecutiveExecutor.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void waitForShutdown() {
        this.consecutiveExecutor.method_63599(Priority.SHUTDOWN.ordinal(), p_371169_ -> p_371169_.complete(class_3902.field_17274)).join();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }

    static class PendingStore {
        @Nullable
        class_2487 data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable class_2487 data) {
            this.data = data;
        }

        @Nullable
        class_2487 copyData() {
            class_2487 compoundtag = this.data;
            return compoundtag == null ? null : compoundtag.method_10553();
        }
    }
}

