/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helpers;

import com.google.common.base.Joiner;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import journeymap.api.services.CommonPlatformService;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helpers.FabricObfHelper;
import journeymap.common.util.ObfuscationHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;

public class FabricHooks
implements CommonPlatformService {
    private final ObfuscationHelper obfuscationHelper = new FabricObfHelper();

    @Override
    public CommonPlatformService.Loader getLoader() {
        return CommonPlatformService.Loader.FABRIC;
    }

    @Override
    public boolean isDedicatedServer() {
        return this.getServer() != null && this.getServer().method_3816();
    }

    @Override
    public MinecraftServer getServer() {
        return Journeymap.getInstance().getServer();
    }

    @Override
    public ArrayList<String> getMods() {
        ArrayList<String> list = new ArrayList<String>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            if (!this.isModLoaded(meta.getId())) continue;
            list.add(String.format("%s:%s", meta.getName(), meta.getVersion()));
        }
        return list;
    }

    @Override
    public String getModName(String modId) {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            if (!meta.getId().equals(modId)) continue;
            return meta.getName();
        }
        return "";
    }

    @Override
    public String getModNames() {
        return Joiner.on((String)", ").join(this.getMods().stream().sorted().iterator());
    }

    @Override
    public String getLoaderVersion() {
        return "0.17.2";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId) || FabricLoader.getInstance().isModLoaded(modId.toLowerCase());
    }

    @Override
    public URL getModFileLocation(String domain) throws Exception {
        URL fileLocation = null;
        ModContainer mod = FabricLoader.getInstance().getModContainer(domain).orElse(null);
        if (mod == null) {
            for (ModContainer modEntry : FabricLoader.getInstance().getAllMods()) {
                ModMetadata meta = modEntry.getMetadata();
                if (!meta.getId().toLowerCase().equals(domain)) continue;
                mod = FabricLoader.getInstance().getModContainer(domain).orElse(null);
                break;
            }
        }
        if (mod != null) {
            fileLocation = mod.getRoot().toUri().toURL();
        }
        if (fileLocation.getProtocol() != null && fileLocation.getProtocol().contains("quilt.")) {
            String loc = "jar:file:///" + String.valueOf(mod.getOrigin().getPaths().get(0)) + "!/";
            fileLocation = new URL(loc);
        }
        return fileLocation;
    }

    @Override
    public boolean isClient() {
        return EnvType.CLIENT.equals((Object)FabricLoader.getInstance().getEnvironmentType());
    }

    @Override
    public boolean isOp(class_1657 player) {
        if (EnvType.CLIENT.equals((Object)FabricLoader.getInstance().getEnvironmentType())) {
            boolean creative = player.method_31549().field_7477;
            boolean cheatMode = this.getServer().method_3760().method_14569(player.method_72498());
            return creative || cheatMode;
        }
        return this.getServer().method_3760().method_14603().method_14640((Object)player.method_72498()) != null || CommonConstants.debugOverride((class_1297)player);
    }

    @Override
    public List<String> getClientPluginScanResult() {
        return FabricLoader.getInstance().getEntrypoints("journeymap", IClientPlugin.class).stream().map(clazz -> clazz.getClass().getName()).collect(Collectors.toList());
    }

    @Override
    public ObfuscationHelper getObfHelper() {
        return this.obfuscationHelper;
    }

    @Override
    public String getModVersion(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        return mod.map(modContainer -> modContainer.getMetadata().getVersion().toString()).orElse(null);
    }
}

