/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.dropdown.ActionsDropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.WaypointChat;
import journeymap.client.ui.waypointmanager.waypoint.DeleteConfirmWaypointPopup;
import journeymap.client.ui.waypointmanager.waypoint.WaypointEditor;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

public class WaypointSlot
extends ManagerSlot
implements SelectableParent {
    private final ClientWaypointImpl waypoint;
    private boolean dragging = false;
    public double dragX;
    public double dragY;
    private Integer distance;
    private final NumberFormat formatter = new DecimalFormat("0.##E0");
    public int y;
    public int x;
    private ManagerSlot.ToolTipMeta tooltips;
    private ActionsDropDownButton actionsButton;
    private class_8667 layout;
    private CheckBox selectedCheckBox;
    public StringWidget name;
    public ColoredImageWidget icon;
    private boolean selected = false;

    public WaypointSlot(ClientWaypointImpl waypoint) {
        this.waypoint = waypoint;
    }

    @Override
    public void repositionElements() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    @Override
    public void init() {
        Boolean useActionsButton = JourneymapClient.getInstance().getWaypointProperties().useActionsButton.get();
        double widthMultiplier = useActionsButton == false && (double)class_310.method_1551().method_22683().method_4486() < 500.0 ? 0.8 : 1.0;
        int scale = (int)Math.round((double)class_310.method_1551().method_22683().method_4486() / 100.0 * widthMultiplier);
        int spacing = Math.min(scale, 7);
        class_327 font = class_310.method_1551().field_1772;
        int nameTextWidth = 30 * scale;
        int size = 16;
        this.buildTooltips();
        this.layout = class_8667.method_52742().method_52735(spacing);
        class_8667 contentLayout = class_8667.method_52742().method_52735(spacing);
        this.selectedCheckBox = (CheckBox)this.layout.method_52738((class_8021)new CheckBox("", false, b -> this.setSelected(((CheckBox)b).getToggled())), class_7847::method_46474);
        this.selectedCheckBox.setDrawText(false);
        this.layout.method_52736((class_8021)contentLayout);
        this.icon = (ColoredImageWidget)contentLayout.method_52738((class_8021)ColoredImageWidget.texture(size, size, this.waypoint.getTextureResource(), size, size, this.waypoint.getIconColor(), false), class_7847::method_46474);
        StringWidget dist = (StringWidget)contentLayout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)this.getDistanceString()), 50, font).alignLeft(), class_7847::method_46474);
        this.name = (StringWidget)contentLayout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)this.waypoint.getName()), nameTextWidth, font).alignLeft(), class_7847::method_46474);
        if (useActionsButton.booleanValue()) {
            this.buildActionsButton(contentLayout);
        } else {
            this.buildButtonsLayout(contentLayout, spacing);
        }
        if (!this.waypoint.isEnabled() || !this.waypoint.isInPlayerDimension()) {
            class_2583 style = class_2583.field_24360.method_36139(0x808080).method_36140(Boolean.valueOf(JourneymapClient.getInstance().getWaypointProperties().disableStrikeThrough.get() == false));
            dist.method_25355((class_2561)dist.method_25369().method_27661().method_27696(style));
            this.name.method_25355((class_2561)this.name.method_25369().method_27661().method_27696(style));
            this.name.method_25358(nameTextWidth);
            dist.method_25358(50);
        }
        this.repositionElements();
    }

    private void buildButtonsLayout(class_8667 layout, int scale) {
        class_8667 buttonsLayout = class_8667.method_52742().method_52735(scale - 1);
        if (CmdTeleportWaypoint.isPermitted(class_310.method_1551())) {
            ((BasicImageButton)buttonsLayout.method_52736((class_8021)new BasicImageButton(14, 14, TextureCache.TELEPORT_SPRITE, this::teleport, (class_2561)class_2561.method_43471((String)"jm.waypoint.teleport.tooltip")))).setTexWidth(10).setTexHeight(10).setXOffset(2).setYOffset(2).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.teleport.tooltip")));
        }
        ((BasicImageButton)buttonsLayout.method_52736((class_8021)new BasicImageButton(14, 14, TextureCache.PIN_SPRITE, this::goToMap, (class_2561)class_2561.method_43471((String)"jm.waypoint.find.tooltip")))).setTexWidth(12).setTexHeight(12).setXOffset(1).setYOffset(1).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.find.tooltip")));
        if (!JourneymapClient.getInstance().getWaypointProperties().disableShare.get().booleanValue()) {
            ((BasicImageButton)buttonsLayout.method_52736((class_8021)new BasicImageButton(14, 14, TextureCache.SHARE_SPRITE, this::share, (class_2561)class_2561.method_43471((String)"jm.waypoint.share.tooltip")))).setTexWidth(10).setTexHeight(10).setXOffset(2).setYOffset(2).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.share.tooltip")));
        }
        ((BasicImageButton)buttonsLayout.method_52736((class_8021)new BasicImageButton(14, 14, TextureCache.POWER_SPRITE, (Integer)(this.waypoint.isEnabled() ? 65280 : 0xFF0000), this::onEnable, this.getEnabledComponent(this.waypoint.isEnabled())))).setTexWidth(12).setTexHeight(12).setXOffset(1).setYOffset(1).method_47400(class_7919.method_47407((class_2561)this.getEnabledComponent(this.waypoint.isEnabled())));
        ((ImagePopupButton)buttonsLayout.method_52736(new ImagePopupButton<Waypoint>(14, 14, TextureCache.OPTIONS_SPRITE, (class_2561)class_2561.method_43471((String)"jm.waypoint.edit_title"), () -> new WaypointEditor(this.waypoint), w -> {}))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_title")));
        if (JourneymapClient.getInstance().getWaypointProperties().showDeleteConfirmation.get().booleanValue()) {
            ((ImagePopupButton)buttonsLayout.method_52736(new ImagePopupButton<Boolean>(14, 14, TextureCache.X_OUTLINE_SPRITE, class_124.field_1061.method_532(), (class_2561)class_2561.method_43471((String)"jm.waypoint.delete.label"), () -> new DeleteConfirmWaypointPopup(this.waypoint), this::onDelete))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.delete.label")));
        } else {
            ((BasicImageButton)buttonsLayout.method_52736((class_8021)new BasicImageButton(14, 14, TextureCache.X_OUTLINE_SPRITE, class_124.field_1061.method_532(), b -> this.onDelete(true), (class_2561)class_2561.method_43471((String)"jm.waypoint.delete.label")))).setTexWidth(12).setTexHeight(12).setXOffset(1).setYOffset(1).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.delete.label")));
        }
        class_7847 settings = class_7847.method_46481().method_46474();
        layout.method_52737((class_8021)buttonsLayout, settings);
    }

    private void buildActionsButton(class_8667 layout) {
        String actionsLabel = Constants.getString("jm.webmap.actions_title");
        this.actionsButton = new ActionsDropDownButton(actionsLabel, b -> {});
        this.actionsButton.method_53533(14);
        this.actionsButton.setItems(this.buildActionItems());
        layout.method_52738((class_8021)this.actionsButton, class_7847::method_46474);
    }

    private ArrayList<DropDownItem> buildActionItems() {
        ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
        items.add(new DropDownItem((SelectableParent)this, (Object)"edit", Constants.getString("jm.waypoint.edit_label"), this::onEdit, Constants.getString("jm.waypoint.edit_label.tooltip")));
        items.add(new DropDownItem((SelectableParent)this, (Object)"pin", Constants.getString("jm.waypoint.find"), this::goToMap, Constants.getString("jm.waypoint.find.tooltip")));
        if (CmdTeleportWaypoint.isPermitted(class_310.method_1551())) {
            items.add(new DropDownItem((SelectableParent)this, (Object)"teleport", Constants.getString("jm.waypoint.teleport"), this::teleport, Constants.getString("jm.waypoint.teleport.tooltip")));
        }
        if (!JourneymapClient.getInstance().getWaypointProperties().disableShare.get().booleanValue()) {
            items.add(new DropDownItem((SelectableParent)this, (Object)"share", Constants.getString("jm.waypoint.share"), this::share, Constants.getString("jm.waypoint.share.tooltip")));
        }
        String enabledText = this.getEnabledComponent(this.waypoint.isEnabled()).getString();
        items.add(new DropDownItem((SelectableParent)this, (Object)"enable", enabledText, this::onEnable, enabledText));
        items.add(new DropDownItem((SelectableParent)this, (Object)"delete", Constants.getString("jm.waypoint.delete.label"), this::onDelete, Constants.getString("jm.waypoint.delete.label")));
        return items;
    }

    private class_2561 getEnabledComponent(boolean enabled) {
        return enabled ? class_2561.method_43471((String)"jm.waypoint.disable_waypoint") : class_2561.method_43471((String)"jm.waypoint.enable_waypoint");
    }

    private void onEnable(class_4185 button) {
        button.method_25355(this.getEnabledComponent(this.waypoint.isEnabled()));
        button.method_47400(class_7919.method_47407((class_2561)this.getEnabledComponent(this.waypoint.isEnabled())));
        boolean enabled = !this.waypoint.isEnabled();
        this.waypoint.setEnabled(enabled);
        EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.UPDATE, null));
    }

    private void share(class_4185 button) {
        try {
            class_310.method_1551().method_1507((class_437)new WaypointChat(this.waypoint));
        }
        catch (Exception e1) {
            Journeymap.getLogger().error("Error opening waypoint chat for waypoint {} :", (Object)this.waypoint.toString(), (Object)e1);
        }
    }

    private void goToMap(class_4185 button) {
        UIManager.INSTANCE.openFullscreenMap(this.waypoint);
    }

    private void teleport(class_4185 button) {
        if (CmdTeleportWaypoint.isPermitted(class_310.method_1551())) {
            UIManager.INSTANCE.closeAll();
            new CmdTeleportWaypoint(this.waypoint).run();
            Fullscreen.state().follow.set(true);
        }
    }

    private void onEdit(class_4185 button) {
        WaypointEditor editor = new WaypointEditor(this.waypoint);
        editor.display();
    }

    private void onDelete(class_4185 button) {
        if (JourneymapClient.getInstance().getWaypointProperties().showDeleteConfirmation.get().booleanValue()) {
            DeleteConfirmWaypointPopup deleteConfirm = new DeleteConfirmWaypointPopup(this.waypoint);
            deleteConfirm.setOnClosed(this::onDelete);
            deleteConfirm.display();
        } else {
            this.onDelete(true);
        }
    }

    private void onDelete(boolean delete) {
        if (delete) {
            EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.DELETED, null));
        }
    }

    public int getDistance() {
        return this.distance == null ? this.getDistanceTo((class_1657)class_310.method_1551().field_1724) : this.distance.intValue();
    }

    public int getDistanceTo(class_1657 player) {
        if (this.distance == null) {
            this.distance = (int)player.method_73189().method_1022(this.waypoint.getPosition());
        }
        return this.distance;
    }

    private String getDistanceString() {
        String distance = String.valueOf(this.getDistance());
        int width = class_310.method_1551().field_1772.method_1727(distance);
        if (width > 40) {
            distance = this.formatter.format(this.getDistance()).toLowerCase(Locale.ROOT);
        }
        return String.format("%sm", distance);
    }

    private void buildTooltips() {
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>();
        tooltip.add(class_5481.method_30747((String)this.waypoint.getName(), (class_2583)class_2583.field_24360.method_27705(new class_124[]{class_124.field_1075, class_124.field_1073})));
        tooltip.add(class_5481.method_30747((String)"", (class_2583)class_2583.field_24360));
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.slot.mod_id", this.waypoint.getModId()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1078)));
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.slot.pos", this.waypoint.getBlockPos().method_23854()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1078)));
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.slot.group", this.waypoint.getGroup().getName()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1060)));
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.slot.enabled", this.waypoint.isEnabled()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1060)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    @Override
    public class_8133 getLayout() {
        return this.layout;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean method_25400(class_11905 event) {
        return false;
    }

    public boolean method_25404(class_11908 event) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.method_48206(widget -> {
            class_4185 button;
            if (widget instanceof class_4185 && (button = (class_4185)widget).method_49606()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltips : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        float alpha;
        this.x = this.method_73380();
        this.y = this.method_73382();
        int itemHeight = this.method_73384();
        int listWidth = this.method_73387();
        Integer color = isMouseOver ? backgroundHover : background;
        float f = alpha = isMouseOver ? 1.0f : 0.4f;
        if (!this.method_25370()) {
            DrawUtil.drawRectangle(graphics, this.x, this.y, listWidth - 4, itemHeight, color, alpha);
        }
        this.renderSlot(graphics, this.x, this.y, listWidth - 4, itemHeight, mouseX, mouseY, color, alpha, partialTicks);
    }

    public void renderGhost(class_332 graphics, int xOffset, int yOffset, float partialTicks) {
        this.layout.method_46421(xOffset);
        this.layout.method_46419(yOffset);
        this.layout.method_48206(widget -> this.renderGhost((class_339)widget, graphics, xOffset, yOffset, partialTicks));
    }

    private void renderGhost(class_339 widget, class_332 graphics, int xOffset, int yOffset, float partialTicks) {
        int oldX = widget.method_46426();
        if (widget == this.icon) {
            widget.method_46421(xOffset + 2);
            widget.method_25394(graphics, xOffset, yOffset, partialTicks);
        }
        if (widget == this.name) {
            widget.method_46421(xOffset + 20);
            widget.method_25394(graphics, xOffset, yOffset, partialTicks);
        }
        widget.method_46421(oldX);
    }

    private void renderSlot(class_332 graphics, int x, int y, int listWidth, int itemHeight, int mouseX, int mouseY, int color, float alpha, float partialTicks) {
        this.layout.method_46421(x + 3);
        this.layout.method_46419(y);
        this.layout.method_48206(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTicks));
        this.outline(graphics, x - 1, y - 1, listWidth + 1, itemHeight + 1, this.waypoint.getRenderColor(), alpha * 2.0f);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        long clickTime = class_156.method_658();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == event.method_74245();
        if (this.doubleclick) {
            this.doubleclick = false;
            this.lastClickTime = 0L;
            new WaypointEditor(this.waypoint).display();
            return true;
        }
        this.dragX = event.comp_4798();
        this.dragY = event.comp_4799();
        this.lastClickTime = clickTime;
        this.lastClickButton = event.method_74245();
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25406(class_11909 event) {
        this.dragging = false;
        return super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        if (!this.dragging) {
            this.dragging = this.method_25405(event.comp_4798(), event.comp_4799());
        }
        return super.method_25403(event, dragX, dragY);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selectedCheckBox != null) {
            this.selectedCheckBox.setToggled(selected);
        }
        this.selected = selected;
    }

    @Override
    public boolean method_25397() {
        return this.dragging;
    }

    @NotNull
    public ClientWaypointImpl getWaypoint() {
        return this.waypoint;
    }

    @Override
    public void setSelected(DropDownItem button) {
        button.press();
    }
}

