/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.base.Strings;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SliderButton;
import journeymap.client.ui.component.buttons.TextFieldButton;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ButtonListSlot
extends Slot
implements Comparable<ButtonListSlot> {
    static int hgap = 8;
    class_310 mc = class_310.method_1551();
    class_327 fontRenderer;
    ButtonList buttons;
    Map<Button, SlotMetadata> buttonOptionMetadata;
    CategorySlot parent;
    SlotMetadata lastPressed;
    SlotMetadata currentToolTip;
    Integer colorToolbarBgStart;
    Integer colorToolbarBgEnd;

    public ButtonListSlot(CategorySlot parent) {
        this.fontRenderer = class_310.method_1551().field_1772;
        this.buttons = new ButtonList();
        this.buttonOptionMetadata = new HashMap<Button, SlotMetadata>();
        this.lastPressed = null;
        this.currentToolTip = null;
        this.colorToolbarBgStart = new Color(0, 0, 100).getRGB();
        this.colorToolbarBgEnd = new Color(0, 0, 100).getRGB();
        this.parent = parent;
    }

    public ButtonListSlot add(SlotMetadata slotMetadata) {
        this.buttons.add(slotMetadata.getButton());
        this.buttonOptionMetadata.put(slotMetadata.getButton(), slotMetadata);
        return this;
    }

    public ButtonListSlot addAll(Collection<SlotMetadata> slotMetadataCollection) {
        for (SlotMetadata slotMetadata : slotMetadataCollection) {
            this.add(slotMetadata);
        }
        return this;
    }

    public ButtonListSlot merge(ButtonListSlot other) {
        for (SlotMetadata otherSlot : other.buttonOptionMetadata.values()) {
            this.add(otherSlot);
        }
        return this;
    }

    public void clear() {
        this.buttons.clear();
        this.buttonOptionMetadata.clear();
    }

    public Collection<SlotMetadata> getMetadata() {
        return this.buttonOptionMetadata.values();
    }

    public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
        int x = this.method_73380();
        int y = this.method_73382();
        int rowWidth = this.method_73387();
        int itemHeight = this.method_73384();
        int margin = 0;
        if (this.parent.getCurrentColumnWidth() > 0) {
            int cols = this.parent.currentColumns;
            margin = (rowWidth - (hgap * cols - 1 + cols * this.parent.getCurrentColumnWidth())) / 2;
            x += margin;
            rowWidth -= margin * 2;
        }
        SlotMetadata tooltipMetadata = null;
        if (this.buttons.size() > 0) {
            this.buttons.setHeights(itemHeight);
            if (this.buttonOptionMetadata.get(this.buttons.get(0)).isToolbar()) {
                this.buttons.fitWidths(this.fontRenderer);
                this.buttons.layoutHorizontal(x + rowWidth - hgap, y, false, hgap);
                if (this.buttons.getLeftX() < x) {
                    x = this.buttons.getLeftX() - hgap;
                    rowWidth = this.buttons.getRightX() + hgap;
                }
                DrawUtil.drawGradientRect(graphics, x, y, rowWidth, itemHeight, this.colorToolbarBgStart, 0.15f, this.colorToolbarBgEnd, 0.6f);
            } else {
                this.buttons.setWidths(this.parent.currentColumnWidth);
                this.buttons.layoutHorizontal(x, y, true, hgap);
            }
            for (Button button : this.buttons) {
                button.method_25394(graphics, mouseX, mouseY, 0.0f);
                if (tooltipMetadata != null || !button.mouseOver(mouseX, mouseY)) continue;
                tooltipMetadata = this.buttonOptionMetadata.get((Object)button);
            }
        } else {
            Journeymap.getLogger().warn("no buttons in " + this.parent.category.getLabel());
        }
        this.currentToolTip = tooltipMetadata;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0) {
            for (Button button : this.buttons) {
                if (!button.method_25402(event, doubleClick)) continue;
                this.lastPressed = this.buttonOptionMetadata.get((Object)button);
                return true;
            }
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        for (Button button : this.buttons) {
            button.method_25406(event);
        }
        return true;
    }

    public boolean method_25400(class_11905 event) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton)) continue;
            return button.method_25400(event);
        }
        return false;
    }

    public boolean method_25403(class_11909 event, double mouseDX, double mouseDY) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof SliderButton) && !(button instanceof TextFieldButton)) continue;
            return button.method_25403(event, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton) && !(button instanceof SliderButton)) continue;
            return button.method_25404(event);
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            if (slot.isMasterPropertyForCategory()) continue;
            slot.button.setEnabled(enabled);
        }
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return Collections.EMPTY_LIST;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public SlotMetadata getCurrentTooltip() {
        return this.currentToolTip;
    }

    @Override
    public int getColumnWidth() {
        this.buttons.equalizeWidths(this.fontRenderer);
        return ((Button)((Object)this.buttons.get(0))).method_25368();
    }

    public boolean contains(SlotMetadata slotMetadata) {
        return this.buttonOptionMetadata.values().contains(slotMetadata);
    }

    protected String getFirstButtonString() {
        if (this.buttons.size() > 0) {
            return ((Button)((Object)this.buttons.get(0))).method_25369().getString();
        }
        return null;
    }

    @Override
    public int compareTo(ButtonListSlot o) {
        String buttonString = this.getFirstButtonString();
        String otherButtonString = o.getFirstButtonString();
        if (!Strings.isNullOrEmpty((String)buttonString)) {
            return buttonString.compareTo(otherButtonString);
        }
        if (!Strings.isNullOrEmpty((String)otherButtonString)) {
            return 1;
        }
        return 0;
    }
}

