/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.awt.Color;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

public abstract class RadioButton
extends class_4185 {
    private static final class_2960 RADIO = class_2960.method_60655((String)"journeymap", (String)"ui/img/radio_buttons.png");
    protected final int imageWidth;
    protected final int imageHeight;
    protected boolean state;

    public RadioButton(int width, int height, class_2561 message, boolean state, class_4185.class_4241 onPress) {
        super(0, 0, width + 5 + class_310.method_1551().field_1772.method_27525((class_5348)message), height, message, onPress, field_40754);
        this.imageWidth = width;
        this.imageHeight = height;
        this.state = state;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int size = 9;
        int length = 36;
        int offset = this.state ? 0 : size;
        int selectedOffset = this.method_49606() ? length / 2 : 0;
        int min = offset + selectedOffset;
        TextureCache.getTexture(RADIO).method_4527(false, false);
        graphics.method_25290(class_10799.field_56883, RADIO, this.method_46426(), this.method_46427(), (float)min, 0.0f, this.imageWidth, this.imageHeight, length, size);
    }

    public void toggle() {
        this.state = !this.state;
    }

    public boolean state() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public static class ImageRadioButton
    extends RadioButton {
        private final ColoredImageWidget imageWidget;

        public ImageRadioButton(int width, int height, int textureWidth, int textureHeight, class_2960 texture, boolean state, class_4185.class_4241 onPress) {
            super(width, height, (class_2561)class_2561.method_43473(), state, onPress);
            this.imageWidget = ColoredImageWidget.texture(textureWidth, textureHeight, texture, textureWidth, textureHeight, 0xFFFFFF, true);
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
            this.field_22762 = graphics.method_58135(mouseX, mouseY) && this.inBounds(mouseX, mouseY);
            int color = this.state ? 0xFFFFFF : 0xAAAAAA;
            color = this.field_22762 ? 65535 : color;
            this.imageWidget.setColor(color);
        }

        public ColoredImageWidget getImageWidget() {
            return this.imageWidget;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.field_22763 && this.field_22764 && this.inBounds(mouseX, mouseY);
        }

        private boolean inBounds(double mouseX, double mouseY) {
            int y = Math.min(this.imageWidget.method_46427(), this.method_46427());
            int height = Math.max(this.method_25364(), this.imageWidget.method_25364());
            return mouseX >= (double)this.method_46426() && mouseY >= (double)y && mouseX < (double)(this.imageWidget.method_46426() + this.imageWidget.method_25368()) && mouseY < (double)(y + height);
        }
    }

    public static class TextRadioButton
    extends RadioButton {
        private final Integer activeColor = new Color(0xFFFFFF).getRGB();
        private final Integer inactiveColor = new Color(0xA0A0A0).getRGB();

        public TextRadioButton(int width, int height, class_2561 message, boolean state, class_4185.class_4241 onPress) {
            super(width, height, message, state, onPress);
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
            int color = this.state ? 0xFFFFFF : 0xAAAAAA;
            color = this.field_22762 ? 65535 : color;
            int i = this.field_22763 ? this.activeColor : this.inactiveColor;
            graphics.method_27535(class_310.method_1551().field_1772, this.method_25369(), this.method_46426() + this.imageWidth + 5, this.method_46427(), i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
    }
}

