/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.common.mixin.client.AbstractScrollAreaAccessor;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_4587;

public class ScrollPane
extends class_4280<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Button selected = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private class_310 mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;
    protected boolean renderSelection;

    public ScrollPane(JmUILegacy parent, class_310 mc, int width, int height, List<? extends Button> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, itemHeight + itemGap);
        for (Button button : items) {
            super.method_25321((class_350.class_351)new ScrollPaneEntry(this, this, button));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int method_46426() {
        return (int)this.origin.getX();
    }

    public int method_46427() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.field_22759;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.method_73369(width, height, x, y);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int method_25340() {
        return super.method_25340();
    }

    public Button getClickedButton(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0) {
            for (ScrollPaneEntry entry : super.method_25396()) {
                Button item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item.method_49606() && item.method_25402(event, doubleClick)) {
                    item.method_25306((class_11907)event.comp_4800());
                    return item;
                }
                item.clickScrollable(this.mc, (int)event.comp_4798(), (int)event.comp_4799());
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.method_25396()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item) || !item.method_49606() || !item.mouseOver(mouseX, mouseY)) continue;
            return item;
        }
        return null;
    }

    public void method_48579(class_332 graphics, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        class_4587 pose = new class_4587();
        pose.method_22903();
        RenderWrapper.enableDepthTest();
        this.renderBackground(graphics);
        super.method_48579(graphics, mX, mY, partialTicks);
        pose.method_22909();
    }

    protected void method_57713(class_332 pGuiGraphics) {
    }

    protected void method_57715(class_332 guiGraphics) {
    }

    protected void renderBackground(class_332 graphics) {
        int width = this.method_25368();
        float alpha = 0.4f;
        int y = this.method_46427() - 1;
        DrawUtil.drawRectangle(graphics, this.method_46426(), y, width, this.paneHeight + 1, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        if (super.method_44392()) {
            ++width;
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(graphics, this.method_46426(), y, width, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.method_46426(), y + this.paneHeight + 1, width + 1, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.method_46426(), y, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.method_46426() + width, y, 1.0, this.paneHeight + 1, this.frameColor, alpha);
        }
    }

    protected void renderItem(class_332 graphics, int mouseX, int mouseY, float partialTick, ScrollPaneEntry entry) {
        int margin = 4;
        int itemX = this.method_46426() + 2;
        Button item = entry.item;
        item.setScrollablePosition(itemX, entry.method_46427());
        item.setScrollableWidth(this.paneWidth - 4);
        item.drawScrollable(graphics, this.mc, this._mouseX, this._mouseY);
        item.renderSpecialDecoration(graphics, this._mouseX, this._mouseY, this.method_46426(), this.method_46427(), this.method_25368(), this.field_22759);
    }

    protected void renderSelection(class_332 guiGraphics, ScrollPaneEntry entry, int i) {
        if (this.renderSelection) {
            super.method_44398(guiGraphics, (class_350.class_351)entry, i);
        }
    }

    public boolean method_25403(class_11909 event, double mouseDX, double mouseDY) {
        if (this.method_25396().isEmpty()) {
            return false;
        }
        if (event.method_74245() == 0 && ((AbstractScrollAreaAccessor)((Object)this)).isScrolling()) {
            if (event.comp_4799() < (double)super.method_46427()) {
                this.method_44382(0.0);
            } else {
                double d0 = Math.max(1, this.method_44390());
                int i = super.method_55443() - super.method_46427();
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.method_44395())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.method_44382(this.method_44387() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Button item) {
        return item.method_46427() >= this.method_46427() && item.method_46427() + item.getButtonHeight() <= this.method_46427() + this.paneHeight;
    }

    protected int method_65507() {
        return this.paneWidth + this.method_46426();
    }

    public boolean method_65505(class_11909 event) {
        double rightX = this.method_46426() + this.method_25368() - 5;
        boolean scrolling = event.method_74245() == 0 && event.comp_4798() >= rightX && event.comp_4799() < rightX + 10.0;
        ((AbstractScrollAreaAccessor)((Object)this)).setScrolling(scrolling);
        return scrolling;
    }

    public int method_25368() {
        boolean scrollVisible = 0 < this.method_44390();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(class_327 fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.method_25396()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public boolean method_25405(double posX, double posY) {
        int topY = this.method_46427();
        int bottomY = this.method_46427() + this.paneHeight;
        int leftX = this.method_46426();
        int rightX = this.method_46426() + this.method_25368();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void method_16014(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.method_25396()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item)) continue;
            item.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    class ScrollPaneEntry
    extends class_4280.class_4281<ScrollPaneEntry> {
        private ScrollPane parent;
        private Button item;

        public ScrollPaneEntry(ScrollPane this$0, ScrollPane parent, Button item) {
            this.parent = parent;
            this.item = item;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)"");
        }

        public void method_25343(class_332 guiGraphics, int i, int i1, boolean b, float v) {
        }
    }
}

