/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.DisplayType;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.IOverlayListener;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.PolygonHelper;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class RegionRenderer {
    private static RegionRenderer instance;
    public static boolean TOGGLED;

    private RegionRenderer() {
    }

    public static void render(boolean toggled) {
        if (instance == null && System.getProperty("journeymap.map_testing") != null) {
            instance = new RegionRenderer();
        }
        TOGGLED = toggled;
        if (toggled) {
            ClientAPI.INSTANCE.flagOverlaysForRerender();
            for (RegionCoord rc : instance.getRegions()) {
                PolygonOverlay overlay = instance.createOverlay(rc);
                ClientAPI.INSTANCE.show((Displayable)overlay);
            }
        } else {
            ClientAPI.INSTANCE.removeAll("journeymap", DisplayType.Polygon);
        }
    }

    private Stack<RegionCoord> getRegions() {
        try {
            class_310 minecraft = class_310.method_1551();
            RegionLoader regionLoader = new RegionLoader(minecraft, Fullscreen.state().getMapType(), true);
            return regionLoader.getRegions();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load regions", e);
        }
    }

    protected PolygonOverlay createOverlay(RegionCoord rCoord) {
        String groupName = "Region";
        String label = "x:" + rCoord.regionX + ", z:" + rCoord.regionZ;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFF0000).setStrokeOpacity(0.7f).setFillOpacity(0.2f).setFillColor(65535);
        TextProperties textProps = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setFontShadow(true);
        int x = rCoord.getMinChunkX() << 4;
        int y = 70;
        int z = rCoord.getMinChunkZ() << 4;
        int maxX = (rCoord.getMaxChunkX() << 4) + 15;
        int maxZ = (rCoord.getMaxChunkZ() << 4) + 15;
        class_2338 sw = new class_2338(x + 1, y, maxZ + 1);
        class_2338 se = new class_2338(maxX + 1, y, maxZ + 1);
        class_2338 ne = new class_2338(maxX + 1, y, z + 1);
        class_2338 nw = new class_2338(x + 1, y, z + 1);
        MapPolygon regionPolygon = new MapPolygon(new class_2338[]{sw, se, ne, nw});
        PolygonOverlay overlay = new PolygonOverlay("journeymap", rCoord.dimension, shapeProps, regionPolygon);
        overlay.setOverlayGroupName(groupName).setOverlayListener(new IOverlayListener(this){

            public void onActivate(UIState mapState) {
            }

            public void onDeactivate(UIState mapState) {
            }

            public void onMouseMove(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition) {
            }

            public void onMouseOut(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition) {
            }

            public boolean onMouseClick(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition, int button, boolean doubleClick) {
                return false;
            }

            public void onOverlayMenuPopup(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition, ModPopupMenu modPopupMenu) {
            }
        }).setTitle("Title").setLabel(label).setTextProperties(textProps).setActiveUIs(new Context.UI[]{Context.UI.Fullscreen, Context.UI.Webmap, Context.UI.Minimap}).setActiveMapTypes(Context.MapType.all());
        return overlay;
    }

    protected PolygonOverlay createTexturedOverlay(RegionCoord rCoord) {
        String displayId = "Region Display" + String.valueOf(rCoord);
        String groupName = "Region";
        String label = "x:" + rCoord.regionX + ", z:" + rCoord.regionZ;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(5.0f).setStrokeColor(0xFF0000).setStrokeOpacity(0.7f).setFillOpacity(0.2f).setImageLocation(TextureCache.Logo).setTexturePositionX(-20.0).setTexturePositionY(8.0).setTextureScaleX(0.8).setTextureScaleY(0.4).setFillColor(-1);
        TextProperties textProps = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setFontShadow(true);
        int x = rCoord.getMinChunkX() << 4;
        int y = 70;
        int z = rCoord.getMinChunkZ() << 4;
        int maxX = (rCoord.getMaxChunkX() << 4) + 15;
        int maxZ = (rCoord.getMaxChunkZ() << 4) + 15;
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        blockPosList.add(new class_2338(384, 256, 128));
        blockPosList.add(new class_2338(144, 256, 304));
        blockPosList.add(new class_2338(144, 256, 224));
        blockPosList.add(new class_2338(160, 256, 224));
        blockPosList.add(new class_2338(160, 256, 128));
        blockPosList.add(new class_2338(272, 256, 128));
        blockPosList.add(new class_2338(272, 256, 144));
        blockPosList.add(new class_2338(288, 256, 144));
        blockPosList.add(new class_2338(288, 256, 128));
        blockPosList.add(new class_2338(368, 256, 128));
        MapPolygon hole = PolygonHelper.createChunkPolygonForWorldCoords((int)284, (int)70, (int)197);
        PolygonOverlay overlay = new PolygonOverlay("journeymap", rCoord.dimension, shapeProps, new MapPolygon(blockPosList), Collections.singletonList(hole));
        overlay.setOverlayGroupName(groupName).setOverlayListener(new IOverlayListener(this){

            public void onActivate(UIState mapState) {
            }

            public void onDeactivate(UIState mapState) {
            }

            public void onMouseMove(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition) {
                System.out.println(blockPosition);
            }

            public void onMouseOut(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition) {
                System.out.println(mousePosition);
            }

            public boolean onMouseClick(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition, int button, boolean doubleClick) {
                System.out.println("click");
                return false;
            }

            public void onOverlayMenuPopup(UIState mapState, Point2D.Double mousePosition, class_2338 blockPosition, ModPopupMenu modPopupMenu) {
            }
        }).setTitle("Test Title").setLabel(label).setTextProperties(textProps).setActiveUIs(new Context.UI[]{Context.UI.Fullscreen, Context.UI.Minimap, Context.UI.Webmap}).setActiveMapTypes(Context.MapType.all());
        return overlay;
    }

    static {
        TOGGLED = false;
    }
}

