/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.PlayerPoint;
import journeymap.common.Journeymap;
import journeymap.common.mixin.client.GameRendererInvoker;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class WaypointDecorationRenderer
extends WaypointRenderer {
    @Override
    public void render(class_332 graphics, class_4587 poseStack) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
        Collection<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        List<ClientWaypointImpl> waypointsOrdered = this.waypointsToDraw(waypoints);
        waypointsOrdered.addAll(WaypointStore.getInstance().getPlayerPoints());
        class_310.method_1551().method_22940().method_23000().method_22993();
        if (waypointsOrdered.isEmpty()) {
            return;
        }
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.PostObject || pass == DrawStep.Pass.Tooltip) continue;
            graphics.method_51448().pushMatrix();
            graphics.method_51448().scale(1.0f / (float)JmUI.calculateScaleFactor());
            for (ClientWaypointImpl waypoint : waypointsOrdered) {
                try {
                    this.renderWaypoint(graphics, waypoint, poseStack, pass, (class_4597)buffers);
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint decoration failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
            buffers.method_22993();
            graphics.method_51448().popMatrix();
        }
    }

    private List<ClientWaypointImpl> waypointsToDraw(Collection<ClientWaypointImpl> waypoints) {
        String playerDim = this.minecraft.field_1724.method_73183().method_27983().method_29177().toString();
        ArrayList<ClientWaypointImpl> toDraw = new ArrayList<ClientWaypointImpl>();
        double closestAngle = 0.0;
        ClientWaypointImpl closestHolder = null;
        for (ClientWaypointImpl waypoint : waypoints) {
            double angle;
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue() || !((angle = this.angleToBeacon(waypoint.getPosition())) < 180.0)) continue;
            if (closestHolder == null || angle < closestAngle) {
                if (closestHolder != null) {
                    toDraw.add(closestHolder);
                }
                closestHolder = waypoint;
                closestAngle = angle;
                continue;
            }
            toDraw.add(waypoint);
        }
        if (closestHolder != null) {
            toDraw.add(closestHolder);
        }
        return toDraw;
    }

    private double angleToBeacon(class_243 waypointVec) {
        double playerDegrees;
        double angle;
        double playerYaw;
        double yaw = Math.atan2(this.renderManager.field_4686.method_19326().method_10215() - waypointVec.field_1350, this.renderManager.field_4686.method_19326().method_10216() - waypointVec.field_1352);
        double degrees = Math.toDegrees(yaw) + 90.0;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        if ((playerYaw = (double)(this.minecraft.method_1560().method_5791() % 360.0f)) < 0.0) {
            playerYaw += 360.0;
        }
        if ((angle = Math.abs(degrees - (playerDegrees = Math.toDegrees(playerYaw = Math.toRadians(playerYaw))))) > 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    @Override
    protected void render(class_332 graphics, class_4587 poseStack, DrawStep.Pass pass, class_4597 buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, class_243 playerVec, class_243 waypointVec, double viewDistance, double actualDistance, double scale) {
        class_757 gameRenderer = this.minecraft.field_1773;
        Vector4f position = new Vector4f((float)shiftX, (float)shiftY, (float)shiftZ, 1.0f);
        double angle = this.angleToBeacon(waypoint.getPosition());
        Quaternionf rotation = new Quaternionf();
        this.renderManager.field_4686.method_23767().conjugate(rotation);
        position.rotate((Quaternionfc)rotation);
        position.rotateY((float)Math.PI);
        if (position.z <= 0.0f) {
            return;
        }
        Matrix4f projection = gameRenderer.method_22973(((GameRendererInvoker)gameRenderer).invokeGetFov(this.renderManager.field_4686, partialTicks, true));
        position.mulProject((Matrix4fc)projection);
        class_1041 mainWindow = this.minecraft.method_22683();
        int halfWidth = mainWindow.method_4489() / 2;
        int halfHeight = mainWindow.method_4506() / 2;
        double x = position.x * (float)halfWidth + (float)halfWidth;
        double y = position.y * (float)halfHeight + (float)halfHeight;
        scale = this.waypointProperties.textureSmall.get() != false ? 2.0 : 4.0;
        int size = (int)((double)(waypoint instanceof PlayerPoint ? 8 : 16) * scale);
        if (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) {
            if (actualDistance > 0.5 && (angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue())) {
                this.renderNameTag(graphics, waypoint, x, y, fadeAlpha, actualDistance, size);
            }
            if (actualDistance > 0.5 && (waypoint.showDeviation() && angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue() && waypoint.showDeviation())) {
                this.renderDeviation(graphics, waypoint, x, y, fadeAlpha, playerVec, waypointVec, size);
            }
        }
        if (pass == DrawStep.Pass.Object && actualDistance > 0.1 && (!this.waypointProperties.autoHideIcon.get().booleanValue() || angle < (double)this.waypointProperties.autoHideIconAngle.get().intValue())) {
            this.renderIcon(graphics, waypoint, x, y, fadeAlpha, size);
        }
    }

    protected void renderIcon(class_332 graphics, ClientWaypointImpl waypoint, double iconX, double iconY, float alpha, int size) {
        class_2960 texture = waypoint.getTextureResource();
        if (TextureCache.getWaypointIcon(texture) == null) {
            texture = TextureCache.Waypoint;
        }
        DrawUtil.drawOnMapImageScaleCorrected(graphics, texture, waypoint.getIconColor(), alpha, iconX, iconY, size, size, 1.0f, 0.0, false);
    }

    protected void renderWaypointLabel(class_332 graphics, String label, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha) {
        double fontScale = this.waypointProperties.fontScale.get().floatValue();
        DrawUtil.drawLabel(graphics, (class_2561)class_2561.method_43470((String)label), labelX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.75f * alpha, waypoint.getSafeColor(), alpha, fontScale, false, 0.0);
    }

    protected void renderNameTag(class_332 graphics, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha, double actualDistance, int size) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getDisplayName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(class_124.field_1067);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                labelY = labelY - (double)(size >> 1) - 8.0;
                this.renderWaypointLabel(graphics, label, waypoint, labelX, labelY, alpha);
            }
        }
    }

    protected void renderDeviation(class_332 graphics, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha, class_243 playerVec, class_243 waypointVec, int size) {
        StringBuilder sb = new StringBuilder();
        class_243 vecTo = playerVec.method_1035(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(class_124.field_1067);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.field_1352, (int)vecTo.field_1351, (int)vecTo.field_1350));
        labelY = labelY + (double)(size >> 1) + 36.0;
        this.renderWaypointLabel(graphics, sb.toString(), waypoint, labelX, labelY, alpha);
    }
}

