/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.ItemEntityExtender;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297
implements ItemEntityExtender {
    @Shadow
    public int field_7201;
    @Unique
    private boolean swim;
    @Unique
    private boolean burn;
    @Unique
    private class_3611 fluid;

    private ItemEntityMixin(class_1299<?> p_19870_, class_1937 p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurtInject(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!ItemPhysicServer.hurt((class_1542)this, source, amount)) {
            callback.setReturnValue((Object)false);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return ItemPhysicServer.interact((class_1542)this, player, hand);
    }

    protected void method_5623(double height, boolean fall, class_2680 state, class_2338 pos) {
        class_1542 item = (class_1542)this;
        if (fall && item.field_6017 > 0.0 && ItemPhysic.CONFIG.general.fallSounds) {
            item.method_5783(class_3417.field_15048, Math.min(1.0f, (float)item.field_6017 / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
        super.method_5623(height, fall, state, pos);
    }

    public boolean method_5692(class_6862<class_3611> fluid, double p_204033_) {
        return CommonPhysic.updateFluidHeightAndDoFluidPushing((class_1542)this, fluid, p_204033_);
    }

    public void method_5730() {
        if (!this.method_5753()) {
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverlevel = (class_3218)class_19372;
                if (this.method_64397(serverlevel, this.method_48923().method_48817(), 4.0f)) {
                    serverlevel.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14821, this.method_5634(), 0.4f, 2.0f + this.field_5974.method_43057() * 0.4f);
                }
            } else {
                for (int i = 0; i < 100; ++i) {
                    this.method_73183().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), (double)this.field_5974.method_43057() * 0.1 - 0.05, 0.2 * this.field_5974.method_43058(), (double)this.field_5974.method_43057() * 0.1 - 0.05);
                }
            }
        }
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void playerTouchInject(class_1657 player, CallbackInfo info) {
        if (ItemPhysicServer.playerTouch((class_1542)this, player)) {
            info.cancel();
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void fireImmuneInject(CallbackInfoReturnable<Boolean> info) {
        if (CommonPhysic.fireImmune((class_1542)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z")}, require=1)
    public void updatePre(CallbackInfo info) {
        CommonPhysic.updatePre((class_1542)this, this.field_5974);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z"), require=1)
    public boolean isInWaterRedirect(class_1542 entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInLava()Z"), require=1)
    public boolean isInLavaRedirect(class_1542 entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;applyGravity()V"), require=1)
    public void isNoGravityRedirect(class_1542 entity) {
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=0)}, require=1)
    public void update(CallbackInfo info) {
        CommonPhysic.update((class_1542)this);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=2)
    public void setDeltaMovementRedirect(class_1542 entity, class_243 vec) {
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setEntityRepresentation(Lnet/minecraft/world/entity/Entity;)V")}, require=1)
    private void onSyncedDataUpdated(class_2940<?> accessor, CallbackInfo callback) {
        this.swim = ItemPhysic.CONFIG.general.swimmingItems.canPass(this.method_73183(), ((class_1542)this).method_6983());
        this.burn = ItemPhysic.CONFIG.general.burningItems.canPass(this.method_73183(), ((class_1542)this).method_6983());
    }

    @Override
    public boolean canBurn() {
        return this.burn;
    }

    @Override
    public boolean canSwim() {
        return this.swim;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    @Override
    public void setFluid(class_3611 fluid) {
        this.fluid = fluid;
    }
}

