/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_10039;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import org.joml.Quaternionfc;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.client.ItemEntityRenderStateExtender;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;
import team.creative.itemphysic.mixin.ItemStackRenderStateAccessor;
import team.creative.itemphysic.mixin.LayerRenderStateAccessor;

public class ItemPhysicClient {
    public static final class_304 PICKUP = new class_304("key.pickup.item", class_3675.field_16237.method_1444(), class_304.class_11900.field_62558);
    public static int throwCharge;
    private static final double RANDOM_Y_OFFSET_SCALE = 0.007957747154594767;

    public static void init() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerKeybind(() -> PICKUP);
        loader.registerClientTick(ItemPhysicClient::gameTick);
        loader.registerClientRenderGui(ItemPhysicClient::renderTick);
        CreativeCoreClient.registerClientConfig((String)"itemphysic");
    }

    public static int getChargeStage() {
        return Math.min(1 + throwCharge / ItemPhysic.CONFIG.throwConfig.stageChargeTime, ItemPhysic.CONFIG.throwConfig.maxStages);
    }

    public static void gameTick() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && ItemPhysic.CONFIG.throwConfig.enabled) {
            if (mc.field_1690.field_1869.method_1434() && !mc.field_1724.method_6047().method_7960()) {
                ++throwCharge;
            } else {
                if (throwCharge > 0 && !mc.field_1724.method_6047().method_7960()) {
                    boolean dropAll = mc.method_74188();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(mc.method_74188(), ItemPhysicClient.getChargeStage()));
                    if (mc.field_1724.method_31548().method_5434(mc.field_1724.method_31548().method_67532(), dropAll && !mc.field_1724.method_31548().method_7391().method_7960() ? mc.field_1724.method_31548().method_7391().method_7947() : 1) != class_1799.field_8037) {
                        mc.field_1724.method_6104(class_1268.field_5808);
                    }
                }
                throwCharge = 0;
            }
        }
    }

    public static void renderTick(Object object) {
        if (class_310.method_1551().field_1755 == null) {
            ItemPhysicClient.renderTooltip((class_332)object);
        }
    }

    public static void renderTooltip(class_332 graphics) {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && !mc.method_1493()) {
            class_239 result;
            if (ItemPhysic.CONFIG.pickup.canPickup((class_1657)mc.field_1724) && (result = ItemPhysicClient.getItemInFocus((class_1657)mc.field_1724)) != null && result.method_17783() == class_239.class_240.field_1331) {
                class_1542 entity;
                if (PICKUP.method_1434()) {
                    ItemPhysicClient.onPlayerInteractClient((class_1937)mc.field_1687, (class_1657)mc.field_1724, false);
                }
                if ((entity = (class_1542)((class_3966)result).method_17782()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip && (!ItemPhysic.CONFIG.rendering.showPickupTooltipOnlyOnGround || entity.method_24828())) {
                    int space = 2;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        if (ItemPhysic.CONFIG.rendering.showPickupTooltipExtended) {
                            list.addAll(entity.method_6983().method_7950(class_1792.class_9635.method_59528((class_1937)mc.field_1687), (class_1657)mc.field_1724, (class_1836)class_1836.field_41070));
                        } else {
                            list.add((class_2561)entity.method_6983().method_7950(class_1792.class_9635.method_59528((class_1937)mc.field_1687), (class_1657)mc.field_1724, (class_1836)class_1836.field_41070).get(0));
                        }
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(class_2561.method_43470((String)"ERRORED"));
                    }
                    if (ItemPhysic.CONFIG.rendering.showPickupTooltipKeybind) {
                        list.add(class_2561.method_43469((String)"item.tooltip.pickup.keybind", (Object[])new Object[]{PICKUP.method_1415() ? mc.field_1690.field_1904.method_16007() : PICKUP.method_16007()}));
                    }
                    int width = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((class_2561)list.get(i)).getString();
                        width = Math.max(width, mc.field_1772.method_1727(text) + 10);
                    }
                    int n = list.size();
                    Objects.requireNonNull(mc.field_1772);
                    int height = n * (9 + space) / 2;
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((class_2561)list.get(i)).getString();
                        class_327 class_3272 = mc.field_1772;
                        class_2561 class_25612 = (class_2561)list.get(i);
                        int n2 = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(text) / 2 + ItemPhysic.CONFIG.rendering.tooltipOffsetX;
                        int n3 = mc.method_22683().method_4502() / 2 - height;
                        Objects.requireNonNull(mc.field_1772);
                        graphics.method_27535(class_3272, class_25612, n2, n3 + (9 + space) * i + ItemPhysic.CONFIG.rendering.tooltipOffsetY, 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.throwConfig.enabled && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwCharge > 0 && !mc.field_1724.method_6047().method_7960()) {
                mc.field_1724.method_7353((class_2561)class_2561.method_43469((String)"item.throw", (Object[])new Object[]{ItemPhysicClient.getChargeStage()}), true);
            }
        }
    }

    public static boolean submit(class_10039 state, class_4587 pose, class_11659 collector, class_12075 camera, class_5819 rand) {
        if (state.field_53328 < 1.0f || ((ItemEntityRenderStateExtender)state).skipRendering() || ItemPhysic.CONFIG.rendering.vanillaRendering) {
            return false;
        }
        pose.method_22903();
        rand.method_43052((long)state.field_55312);
        int j = ItemPhysicClient.getModelCount(state.field_55311);
        boolean gui3d = ((ItemEntityRenderStateExtender)state).isBlock();
        class_804 transform = ((LayerRenderStateAccessor)((ItemStackRenderStateAccessor)state.field_55310).callFirstLayer()).getTransform();
        pose.method_22907((Quaternionfc)class_7833.field_40714.rotation(1.5707964f));
        pose.method_22907((Quaternionfc)class_7833.field_40718.rotation(((ItemEntityRenderStateExtender)state).getYRot()));
        class_310 mc = class_310.method_1551();
        if (state.field_53328 != 0.0f && (gui3d || mc.field_1690 != null)) {
            if (gui3d) {
                pose.method_22904(0.0, -0.2, -0.08);
            } else if (((ItemEntityRenderStateExtender)state).hasAdditionalOffset()) {
                pose.method_22904(0.0, 0.0, -0.14 - (double)state.field_53435 * 0.007957747154594767);
            } else {
                pose.method_22904(0.0, 0.0, -0.04 - (double)state.field_53435 * 0.007957747154594767);
            }
            double height = transform.comp_3749().y();
            if (gui3d) {
                pose.method_22904(0.0, height, 0.0);
            }
            pose.method_22907((Quaternionfc)class_7833.field_40716.rotation(((ItemEntityRenderStateExtender)state).getXRot()));
            if (gui3d) {
                pose.method_22904(0.0, -height, 0.0);
            }
        }
        if (!gui3d) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.method_46416(f7, f8, f9);
        }
        float f = transform.comp_3749().x();
        float f1 = transform.comp_3749().y();
        float f2 = transform.comp_3749().z();
        for (int k = 0; k < j; ++k) {
            pose.method_22903();
            if (k > 0 && gui3d) {
                float f11 = (rand.method_43057() * 2.0f - 1.0f) * f;
                float f13 = (rand.method_43057() * 2.0f - 1.0f) * f1;
                float f10 = (rand.method_43057() * 2.0f - 1.0f) * f2;
                pose.method_46416(f11, f13, f10);
            }
            state.field_55310.method_65604(pose, collector, state.field_61820, class_4608.field_21444, state.field_61821);
            pose.method_22909();
            if (gui3d) continue;
            pose.method_46416(0.0f * f, 0.0f * f1, 0.09375f * f2);
        }
        pose.method_22909();
        return true;
    }

    public static int getModelCount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(class_1937 level, class_1657 player, boolean rightClick) {
        class_310 mc = class_310.method_1551();
        class_239 result = ItemPhysicClient.getItemInFocus((class_1657)mc.field_1724);
        if (result != null && result.method_17783() == class_239.class_240.field_1331) {
            class_1542 entity = (class_1542)((class_3966)result).method_17782();
            if (level.method_8608() && entity != null) {
                player.method_6104(class_1268.field_5808);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.method_5667(), rightClick));
                return true;
            }
        }
        return false;
    }

    public static boolean onPlayerInteract(class_1657 player) {
        if (ItemPhysic.CONFIG.pickup.canPickup(player)) {
            if (!PICKUP.method_1415()) {
                return false;
            }
            return ItemPhysicClient.onPlayerInteractClient(player.method_73183(), player, true);
        }
        return false;
    }

    public static class_239 getItemInFocus(class_1657 player) {
        double d1;
        class_310 mc = class_310.method_1551();
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.method_61966().method_60637(false);
        class_243 position = player.method_5836(partialTicks);
        class_243 view = player.method_5828(partialTicks);
        double d0 = player.method_55754();
        class_239 hitResult = ItemPhysicClient.pick((class_1297)player, d0, d1 = player.method_55755(), partialTicks, position, view, position.method_1031(view.field_1352 * distance, view.field_1351 * distance, view.field_1350 * distance));
        if (hitResult != null && hitResult.method_17783() != class_239.class_240.field_1333) {
            distance = Math.min(hitResult.method_17784().method_1022(position), distance);
        }
        return CommonPhysic.getItemInFocus(player, position, position.method_1031(view.field_1352 * distance, view.field_1351 * distance, view.field_1350 * distance));
    }

    private static class_239 pick(class_1297 entity, double blockInteraction, double entityItneraction, float partialTicks, class_243 position, class_243 view, class_243 endPosition) {
        class_238 aabb;
        class_3966 entityhitresult;
        double d0 = Math.max(blockInteraction, entityItneraction);
        double d1 = class_3532.method_33723((double)d0);
        class_3965 hitresult = entity.method_73183().method_17742(new class_3959(position, endPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        double d2 = hitresult.method_17784().method_1025(position);
        if (hitresult.method_17783() != class_239.class_240.field_1333) {
            d1 = d2;
            d0 = Math.sqrt(d2);
        }
        return (entityhitresult = class_1675.method_18075((class_1297)entity, (class_243)position, (class_243)endPosition, (class_238)(aabb = entity.method_5829().method_18804(view.method_1021(d0)).method_1009(1.0, 1.0, 1.0)), x -> !x.method_7325() && x.method_5863(), (double)d1)) != null && entityhitresult.method_17784().method_1025(position) < d2 ? ItemPhysicClient.filterHitResult((class_239)entityhitresult, position, entityItneraction) : ItemPhysicClient.filterHitResult((class_239)hitresult, position, blockInteraction);
    }

    private static class_239 filterHitResult(class_239 hit, class_243 vec, double range) {
        class_243 hitVec = hit.method_17784();
        if (!hitVec.method_24802((class_2374)vec, range)) {
            return class_3965.method_17778((class_243)hitVec, (class_2350)class_2350.method_10142((double)(hitVec.field_1352 - vec.field_1352), (double)(hitVec.field_1351 - vec.field_1351), (double)(hitVec.field_1350 - vec.field_1350)), (class_2338)class_2338.method_49638((class_2374)hitVec));
        }
        return hit;
    }
}

