/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.simulation;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.render.WakeColor;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.utils.WakesUtils;
import org.jetbrains.annotations.Nullable;

public abstract class SimulationNode {
    public float[][][] u;
    public float[][] initialValues;
    public final int res;

    public SimulationNode() {
        this.res = WakeHandler.resolution.res;
        this.u = new float[3][this.res + 2][this.res + 2];
        this.initialValues = new float[this.res + 2][this.res + 2];
    }

    public void setInitialValue(long pos, int val) {
        float resFactor = (float)this.res / 16.0f;
        int[] xz = WakesUtils.longAsPos(pos);
        if (xz[0] < 0) {
            xz[0] = xz[0] + this.res;
        }
        if (xz[1] < 0) {
            xz[1] = xz[1] + this.res;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.initialValues[xz[1] + i + 1][xz[0] + j + 1] = (float)val * resFactor;
            }
        }
    }

    public int getPixelColor(int x, int z, int fluidCol, int lightCol, float opacity) {
        float waveEqAvg = (this.u[0][z + 1][x + 1] + this.u[1][z + 1][x + 1] + this.u[2][z + 1][x + 1]) / 3.0f;
        if (WakesConfig.debugColors) {
            int clampedRange = (int)(255.0 * (2.0 / (1.0 + Math.exp(-0.1 * (double)waveEqAvg)) - 1.0));
            return new WakeColor((int)Math.max((int)(-clampedRange), (int)0), (int)Math.max((int)clampedRange, (int)0), (int)0, (int)255).abgr;
        }
        return WakeColor.sampleColor(waveEqAvg, fluidCol, lightCol, opacity);
    }

    public abstract void tick(@Nullable Float var1, @Nullable SimulationNode var2, @Nullable SimulationNode var3, @Nullable SimulationNode var4, @Nullable SimulationNode var5);

    public static class SplashPlaneSimulation
    extends SimulationNode {
        @Override
        public void tick(@Nullable Float velocity, @Nullable SimulationNode NORTH, @Nullable SimulationNode SOUTH, @Nullable SimulationNode EAST, @Nullable SimulationNode WEST) {
            double t = (double)System.currentTimeMillis() / 1000.0;
            if (velocity == null) {
                return;
            }
            int p = (int)(14.0f * Math.min(1.0f, 2.0f * velocity.floatValue() / WakesConfig.maxSplashPlaneVelocity));
            for (int z = 1; z < this.res + 1; ++z) {
                for (int x = 1; x < this.res + 1; ++x) {
                    this.u[0][z][x] = 0.0f;
                    double v = Math.atan(((float)z - 16.0f) / (float)x);
                    double d = Math.sqrt(Math.pow(z - 16, 2.0) + Math.pow(x, 2.0)) + 0.5 * Math.sin(10.0 * v - Math.PI * 2 * t);
                    if (!(d < (double)p)) continue;
                    this.u[0][z][x] = (float)(200.0 * Math.pow(d - (double)p, 2.0) / (d * d));
                }
            }
        }
    }

    public static class WakeSimulation
    extends SimulationNode {
        @Override
        public void tick(@Nullable Float velocity, @Nullable SimulationNode NORTH, @Nullable SimulationNode SOUTH, @Nullable SimulationNode EAST, @Nullable SimulationNode WEST) {
            int x;
            int z;
            float time = 20.0f;
            float alpha = (float)Math.pow(WakesConfig.wavePropagationFactor * 16.0f / time, 2.0);
            float beta = (float)(Math.log(10.0f * WakesConfig.waveDecayFactor + 10.0f) / Math.log(20.0));
            for (int i = 2; i >= 1; --i) {
                if (NORTH != null) {
                    this.u[i][0] = NORTH.u[i][this.res];
                }
                if (SOUTH != null) {
                    this.u[i][this.res + 1] = SOUTH.u[i][1];
                }
                for (int z2 = 0; z2 < this.res + 2 && (EAST != null || WEST != null); ++z2) {
                    if (EAST != null) {
                        this.u[i][z2][this.res + 1] = EAST.u[i][z2][1];
                    }
                    if (WEST == null) continue;
                    this.u[i][z2][0] = WEST.u[i][z2][this.res];
                }
            }
            for (z = 1; z < this.res + 1; ++z) {
                for (x = 1; x < this.res + 1; ++x) {
                    float[] fArray = this.u[0][z];
                    int n = x;
                    fArray[n] = fArray[n] + this.initialValues[z][x];
                    this.initialValues[z][x] = 0.0f;
                    this.u[2][z][x] = this.u[1][z][x];
                    this.u[1][z][x] = this.u[0][z][x];
                }
            }
            for (z = 1; z < this.res + 1; ++z) {
                x = 1;
                while (x < this.res + 1) {
                    this.u[0][z][x] = (float)((double)alpha * (0.5 * (double)this.u[1][z - 1][x] + 0.25 * (double)this.u[1][z - 1][x + 1] + 0.5 * (double)this.u[1][z][x + 1] + 0.25 * (double)this.u[1][z + 1][x + 1] + 0.5 * (double)this.u[1][z + 1][x] + 0.25 * (double)this.u[1][z + 1][x - 1] + 0.5 * (double)this.u[1][z][x - 1] + 0.25 * (double)this.u[1][z - 1][x - 1] - (double)(3.0f * this.u[1][z][x])) + (double)(2.0f * this.u[1][z][x]) - (double)this.u[2][z][x]);
                    float[] fArray = this.u[0][z];
                    int n = x++;
                    fArray[n] = fArray[n] * beta;
                }
            }
        }
    }
}

