/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.simulation.WakeHandler;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import net.minecraft.class_10868;

public class WakeTexture {
    private final GpuTextureView textureView;
    public int res;
    public GpuTexture texture;
    public final boolean isUsingBricks;
    private final int resolutionScaling;

    public WakeTexture(int res, boolean useBricks) {
        this.res = res;
        this.isUsingBricks = useBricks;
        this.resolutionScaling = useBricks ? 4 : 1;
        this.texture = RenderSystem.getDevice().createTexture(() -> "Wake Texture", 5, TextureFormat.RGBA8, this.resolutionScaling * res, this.resolutionScaling * res, 1, 1);
        this.texture.setTextureFilter(FilterMode.NEAREST, false);
        this.textureView = RenderSystem.getDevice().createTextureView(this.texture);
    }

    public void loadTexture(long imgPtr, int glFormat) {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
        int dim = this.resolutionScaling * WakeHandler.resolution.res;
        GlStateManager._bindTexture((int)((class_10868)this.texture).method_68427());
        GlStateManager._texSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)dim, (int)dim, (int)glFormat, (int)5121, (long)imgPtr);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.textureView);
    }

    public GpuTexture getTexture() {
        return this.texture;
    }

    public GpuTextureView getTextureView() {
        return this.textureView;
    }
}

