/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.debug.WakesDebugInfo;
import com.goby56.wakes.render.WakeTexture;
import com.goby56.wakes.simulation.Brick;
import com.goby56.wakes.simulation.WakeHandler;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class WakeRenderer
implements WorldRenderEvents.EndMain {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, true), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, true), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, true));
    }

    public void endMain(WorldRenderContext context) {
        WakeHandler wakeHandler;
        if (WakesConfig.disableMod) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        context.gameRenderer().method_22974().method_3316();
        if (wakeTextures == null) {
            this.initTextures();
        }
        if ((wakeHandler = (WakeHandler)WakeHandler.getInstance().orElse(null)) == null || WakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(Brick.class);
        class_243 cameraPos = context.gameRenderer().method_19418().method_19326();
        class_4587 matrices = context.matrices();
        matrices.method_22903();
        matrices.method_61958(cameraPos.method_22882());
        Matrix4f matrix = matrices.method_23760().method_23761();
        Resolution resolution = WakeHandler.resolution;
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            this.render(matrix, brick, wakeTextures.get((Object)resolution));
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
        matrices.method_22909();
    }

    private void render(Matrix4f matrix, Brick brick, WakeTexture texture) {
        if (!brick.hasPopulatedPixels) {
            return;
        }
        texture.loadTexture(brick.imgPtr, 6408);
        class_287 bb = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1590);
        Vector3f pos = brick.pos.method_46409().add(0.0f, 0.8888889f, 0.0f);
        bb.method_22918(matrix, pos.x, pos.y, pos.z).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
        bb.method_22918(matrix, pos.x, pos.y, pos.z + (float)brick.dim).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
        bb.method_22918(matrix, pos.x + (float)brick.dim, pos.y, pos.z + (float)brick.dim).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
        bb.method_22918(matrix, pos.x + (float)brick.dim, pos.y, pos.z).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
        class_9801 built = bb.method_60800();
        GpuBuffer buffer = class_290.field_1590.uploadImmediateVertexBuffer(built.method_60818());
        GpuBuffer indices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(built.method_60822().comp_751());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Wake", class_310.method_1551().method_1522().method_71639(), OptionalInt.empty(), class_310.method_1551().method_1522().method_71640(), OptionalDouble.empty());){
            pass.setPipeline(class_10799.field_56897);
            pass.bindSampler("Sampler0", RenderSystem.getShaderTexture((int)0));
            pass.bindSampler("Sampler2", RenderSystem.getShaderTexture((int)2));
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setVertexBuffer(0, buffer);
            pass.setIndexBuffer(indices, RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_31924());
            pass.drawIndexed(0, 0, built.method_60822().comp_751(), 1);
        }
        built.close();
    }
}

