/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.WakesConfig;
import java.awt.Color;
import java.util.List;

public class WakeColor {
    public final int argb;
    public final int abgr;
    public final int r;
    public final int g;
    public final int b;
    public final int a;
    public final float h;
    public final float s;
    public final float v;

    public WakeColor(int argb) {
        this(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public WakeColor(int red, int green, int blue, int alpha) {
        this.argb = alpha << 24 | red << 16 | green << 8 | blue;
        this.abgr = alpha << 24 | blue << 16 | green << 8 | red;
        this.a = alpha;
        this.r = red;
        this.g = green;
        this.b = blue;
        float[] hsv = Color.RGBtoHSB(red, green, blue, null);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
    }

    public WakeColor(float hue, float saturation, float value, float opacity) {
        this((int)((1.0f - opacity) * 255.0f) << 24 ^ Color.HSBtoRGB(hue, saturation, value));
    }

    public WakeColor(String argbHex) {
        this(Integer.parseUnsignedInt(argbHex.replace("#", ""), 16));
    }

    public String toHex() {
        return "#" + Integer.toHexString(this.a << 24 | this.r << 16 | this.g << 8 | this.b);
    }

    private static double invertedLogisticCurve(float x) {
        float k = WakesConfig.shaderLightPassthrough;
        return WakesClient.areShadersEnabled ? (double)k * (4.0 * Math.pow(x - 0.5f, 3.0) + 0.5) : (double)x;
    }

    public static int sampleColor(float waveEqAvg, int fluidCol, int lightColor, float opacity) {
        WakeColor tint = new WakeColor(fluidCol);
        double clampedRange = 1.0 / (1.0 + Math.exp(-0.1 * (double)waveEqAvg));
        List<Float> ranges = WakesConfig.wakeColorIntervals;
        int returnIndex = ranges.size();
        for (int i = 0; i < ranges.size(); ++i) {
            if (!(clampedRange < (double)ranges.get(i).floatValue())) continue;
            returnIndex = i;
            break;
        }
        WakeColor color = WakesConfig.getWakeColor(returnIndex);
        return color.blend((WakeColor)tint, (int)lightColor, (float)opacity).abgr;
    }

    public WakeColor modifyOpacity(float opacityMultiplier) {
        return new WakeColor(this.r, this.g, this.b, (int)((float)this.a * opacityMultiplier));
    }

    public WakeColor blend(WakeColor tint, int lightColor, float opacity) {
        double srcA = Math.pow((float)this.a / 255.0f, WakesConfig.blendStrength * 10.0f);
        int r = (int)((double)this.r * srcA + (double)tint.r * (1.0 - srcA));
        int g = (int)((double)this.g * srcA + (double)tint.g * (1.0 - srcA));
        int b = (int)((double)this.b * srcA + (double)tint.b * (1.0 - srcA));
        r = (int)((double)r * WakeColor.invertedLogisticCurve((float)(lightColor >> 16 & 0xFF) / 255.0f));
        g = (int)((double)g * WakeColor.invertedLogisticCurve((float)(lightColor >> 8 & 0xFF) / 255.0f));
        b = (int)((double)b * WakeColor.invertedLogisticCurve((float)(lightColor & 0xFF) / 255.0f));
        return new WakeColor(r, g, b, (int)((float)this.a * opacity));
    }
}

