/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.duck.LightmapAccess;
import com.goby56.wakes.render.LightmapInfo;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightmapWrapper {
    private static int[][] color = new int[16][16];
    private static int[][] tick = new int[16][16];

    private static float mix(float x, float y, float a) {
        return x * (1.0f - a) + y * a;
    }

    private static float get_brightness(float level, float AmbientLightFactor) {
        float curved_level = level / (4.0f - 3.0f * level);
        return LightmapWrapper.mix(curved_level, 1.0f, AmbientLightFactor);
    }

    public static Vector3f notGamma(Vector3f v) {
        float nx0 = 1.0f - v.x;
        float nx1 = 1.0f - v.y;
        float nx2 = 1.0f - v.z;
        return new Vector3f(1.0f - nx0 * nx0 * nx0 * nx0, 1.0f - nx1 * nx1 * nx1 * nx1, 1.0f - nx2 * nx2 * nx2 * nx2);
    }

    private static Vector3f mix3(Vector3f color, Vector3f c2, float v) {
        return new Vector3f(LightmapWrapper.mix(color.x, c2.x, v), LightmapWrapper.mix(color.y, c2.y, v), LightmapWrapper.mix(color.z, c2.z, v));
    }

    private static int calculatePixel(LightmapInfo info, int block, int sky) {
        float max_component;
        float block_brightness = LightmapWrapper.get_brightness((float)block / 15.0f, info.AmbientLightFactor()) * info.BlockFactor();
        float sky_brightness = LightmapWrapper.get_brightness((float)sky / 15.0f, info.AmbientLightFactor()) * info.SkyFactor();
        Vector3f color = new Vector3f(block_brightness, block_brightness * ((block_brightness * 0.6f + 0.4f) * 0.6f + 0.4f), block_brightness * (block_brightness * block_brightness * 0.6f + 0.4f));
        if (info.UseBrightLightmap()) {
            color = LightmapWrapper.mix3(color, new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
            color = LightmapWrapper.clamp3(color, 0.0, 1.0);
        } else {
            color.add((Vector3fc)info.skyLightColor().mul(sky_brightness, new Vector3f()));
            color = LightmapWrapper.mix3(color, new Vector3f(0.75f), 0.04f);
            Vector3f darkened_color = color.mul((Vector3fc)new Vector3f(0.7f, 0.6f, 0.6f), new Vector3f());
            color = LightmapWrapper.mix3(color, darkened_color, info.DarkenWorldFactor());
        }
        if ((double)info.NightVisionFactor() > 0.0 && (double)(max_component = Math.max(color.x, Math.max(color.y, color.z))) < 1.0) {
            Vector3f bright_color = color.div(max_component, new Vector3f());
            color = LightmapWrapper.mix3(color, bright_color, info.NightVisionFactor());
        }
        if (!info.UseBrightLightmap()) {
            color = LightmapWrapper.clamp3(color.sub((Vector3fc)new Vector3f(info.DarknessScale()), new Vector3f()), 0.0, 1.0);
        }
        Vector3f notGamma = LightmapWrapper.notGamma(color);
        color = LightmapWrapper.mix3(color, notGamma, info.BrightnessFactor());
        color = LightmapWrapper.mix3(color, new Vector3f(0.75f), 0.04f);
        color = LightmapWrapper.clamp3(color, 0.0, 1.0);
        return class_9848.method_61318((float)1.0f, (float)color.x, (float)color.y, (float)color.z);
    }

    private static Vector3f clamp3(Vector3f color, double v, double v1) {
        return color.set(class_3532.method_15350((double)color.x, (double)v, (double)v1), class_3532.method_15350((double)color.y, (double)v, (double)v1), class_3532.method_15350((double)color.z, (double)v, (double)v1));
    }

    public static int readPixel(int block, int sky) {
        LightmapInfo info = ((LightmapAccess)class_310.method_1551().field_1773.method_22974()).wakes$getLightmapInfo();
        if (info == null) {
            return color[block][sky];
        }
        if (tick[block][sky] != info.currentTick()) {
            LightmapWrapper.tick[block][sky] = info.currentTick();
            LightmapWrapper.color[block][sky] = LightmapWrapper.calculatePixel(info, block, sky);
        }
        return color[block][sky];
    }

    public static void render(Matrix4f matrix) {
    }
}

