/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.particle.custom;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.particle.ModParticles;
import com.goby56.wakes.particle.WithOwnerParticleType;
import com.goby56.wakes.simulation.SimulationNode;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.utils.WakesUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10255;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class SplashPlaneParticle
extends class_703 {
    public class_1297 owner;
    float yaw;
    float prevYaw;
    class_243 direction = class_243.field_1353;
    private final SimulationNode simulationNode = new SimulationNode.SplashPlaneSimulation();
    public long imgPtr = -1L;
    public int texRes;
    public boolean hasPopulatedPixels = false;
    public float lerpedYaw = 0.0f;

    protected SplashPlaneParticle(class_638 world, double x, double y, double z) {
        super(world, x, y, z);
        this.initTexture(WakeHandler.resolution.res);
        WakeHandler.getInstance().ifPresent(wakeHandler -> wakeHandler.registerSplashPlane(this));
    }

    public void method_3085() {
        class_1297 class_12972 = this.owner;
        if (class_12972 instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)class_12972;
            wakeOwner.wakes$setSplashPlane(null);
        }
        this.owner = null;
        this.deallocTexture();
        super.method_3085();
    }

    public void method_3070() {
        if (WakesConfig.disableMod || !WakesUtils.getEffectRuleFromSource((class_1297)this.owner).renderPlanes) {
            this.method_3085();
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.prevYaw = this.yaw;
        class_1297 class_12972 = this.owner;
        if (class_12972 instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)class_12972;
            if (this.owner.method_31481() || !wakeOwner.wakes$onFluidSurface() || wakeOwner.wakes$getHorizontalVelocity() < 0.01) {
                this.method_3085();
            } else {
                this.aliveTick(wakeOwner);
            }
        } else {
            this.method_3085();
        }
    }

    private void aliveTick(ProducesWake wakeProducer) {
        class_243 vel = this.owner.method_18798();
        this.yaw = this.owner instanceof class_10255 ? -this.owner.method_36454() : 90.0f - (float)(57.29577951308232 * Math.atan2(vel.field_1350, vel.field_1352));
        this.direction = class_243.method_1030((float)0.0f, (float)(-this.yaw));
        class_243 planeOffset = this.direction.method_1021((double)(this.owner.method_17681() + WakesConfig.splashPlaneOffset));
        class_243 planePos = this.owner.method_73189().method_1019(planeOffset);
        this.method_3063(planePos.field_1352, wakeProducer.wakes$wakeHeight().floatValue(), planePos.field_1350);
        if (vel.method_1033() / (double)WakesConfig.maxSplashPlaneVelocity > (double)0.3f && WakesConfig.spawnParticles) {
            Random random = new Random();
            class_243 particleOffset = new class_243(-this.direction.field_1350, 0.0, this.direction.field_1352).method_1021(random.nextDouble() * (double)this.owner.method_17681() / 4.0);
            class_243 particlePos = this.owner.method_73189().method_1019(this.direction.method_1021((double)this.owner.method_17681() - 0.3));
            class_243 particleVelocity = class_243.method_1030((float)((float)(45.0 * random.nextDouble())), (float)((float)((double)(-this.yaw) + 30.0 * (random.nextDouble() - 0.5)))).method_1021(1.5 * vel.method_1033());
            this.field_3851.method_8406((class_2394)ModParticles.SPLASH_CLOUD.withOwner(this.owner), particlePos.field_1352 + particleOffset.field_1352, this.field_3854, particlePos.field_1350 + particleOffset.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
            this.field_3851.method_8406((class_2394)ModParticles.SPLASH_CLOUD.withOwner(this.owner), particlePos.field_1352 - particleOffset.field_1352, this.field_3854, particlePos.field_1350 - particleOffset.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
        }
        this.simulationNode.tick(Float.valueOf((float)wakeProducer.wakes$getHorizontalVelocity()), null, null, null, null);
        this.populatePixels();
    }

    public void initTexture(int res) {
        long size = 4L * (long)res * (long)res;
        this.imgPtr = this.imgPtr == -1L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.imgPtr, (long)size);
        this.texRes = res;
        this.hasPopulatedPixels = false;
    }

    public void deallocTexture() {
        MemoryUtil.nmemFree((long)this.imgPtr);
    }

    public void populatePixels() {
        int fluidColor = class_1163.method_4961((class_1920)this.field_3851, (class_2338)this.owner.method_24515());
        int lightCol = WakesUtils.getLightColor((class_1937)this.field_3851, this.owner.method_24515());
        float opacity = WakesConfig.wakeOpacity * 0.9f;
        int res = WakeHandler.resolution.res;
        for (int r = 0; r < res; ++r) {
            for (int c = 0; c < res; ++c) {
                long pixelOffset = 4L * ((long)r * (long)res + (long)c);
                MemoryUtil.memPutInt((long)(this.imgPtr + pixelOffset), (int)this.simulationNode.getPixelColor(c, r, fluidColor, lightCol, opacity));
            }
        }
        this.hasPopulatedPixels = true;
    }

    public void updateYaw(float tickDelta) {
        float diff = this.yaw - this.prevYaw;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        this.lerpedYaw = (this.prevYaw + diff * tickDelta) % 360.0f;
    }

    public void translateMatrix(class_4184 camera, class_4587 matrices) {
        class_243 cameraPos = camera.method_19326();
        float tickDelta = camera.method_55437();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        matrices.method_46416(x, y, z);
    }

    public class_243 getPos() {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    public class_3999 method_74274() {
        return class_3999.field_17832;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        public Factory(class_4002 spriteSet) {
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velX, double velY, double velZ, class_5819 random) {
            SplashPlaneParticle splashPlane = new SplashPlaneParticle(world, x, y, z);
            if (parameters instanceof WithOwnerParticleType) {
                WithOwnerParticleType type = (WithOwnerParticleType)parameters;
                splashPlane.owner = type.owner;
                splashPlane.yaw = splashPlane.prevYaw = type.owner.method_36454();
                ((ProducesWake)splashPlane.owner).wakes$setSplashPlane(splashPlane);
            }
            return splashPlane;
        }
    }
}

