/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config.gui;

import com.goby56.wakes.config.gui.ColorPickerScreen;
import com.goby56.wakes.config.gui.HsvQuadGuiElementRenderState;
import com.goby56.wakes.render.WakeColor;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_6382;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;

public class ColorPicker
extends class_339 {
    private static final class_2960 FRAME_TEXTURE = class_2960.method_60656((String)"textures/gui/sprites/widget/slot_frame.png");
    private static final class_2960 PICKER_BG_TEXTURE = class_2960.method_60655((String)"wakes", (String)"textures/picker_background.png");
    private static final class_2960 PICKER_KNOB_TEXTURE = class_2960.method_60655((String)"wakes", (String)"textures/picker_knob.png");
    private static final int pickerKnobDim = 7;
    private final Map<String, Bounded> widgets = new HashMap<String, Bounded>();
    private final AABB colorPickerBounds;
    private Consumer<WakeColor> changedColorListener;
    private final Vector2f pickerPos = new Vector2f();
    private final Vector2f pickerCenter = new Vector2f();
    private final float pickerRadius;

    public ColorPicker(ColorPickerScreen screenContext, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.colorPickerBounds = new AABB(0.16666667f, 0.0f, 0.8333333f, 0.6666667f, x, y, width, height);
        this.pickerCenter.x = (float)this.colorPickerBounds.x + (float)this.colorPickerBounds.width / 2.0f;
        this.pickerCenter.y = (float)this.colorPickerBounds.y + (float)this.colorPickerBounds.height / 2.0f;
        this.pickerRadius = (float)this.colorPickerBounds.width / 2.0f;
        this.widgets.put("hueSlider", new ColorPickerSlider(new AABB(0.0f, 0.6666667f, 1.0f, 0.8333333f, x, y, width, height), "Hue", this, SliderUpdateType.HUE));
        this.widgets.put("alphaSlider", new ColorPickerSlider(new AABB(0.5f, 0.8333333f, 1.0f, 1.0f, x, y, width, height), "Opacity", this, SliderUpdateType.OPACITY));
        this.widgets.put("hexInputField", new HexInputField(new AABB(0.0f, 0.8333333f, 0.5f, 1.0f, x, y, width, height), this, class_310.method_1551().field_1772));
        screenContext.addWidget(this);
        for (Bounded widget : this.widgets.values()) {
            screenContext.addWidget(widget.getWidget());
        }
        this.setActive(false);
    }

    public void setActive(boolean active) {
        this.field_22763 = this.field_22764 = active;
        for (Bounded widget : this.widgets.values()) {
            widget.setActive(active);
        }
    }

    public void setColor(WakeColor currentColor, WidgetUpdateFlag updateFlag) {
        if (updateFlag.equals((Object)WidgetUpdateFlag.ONLY_HEX)) {
            this.widgets.get("hexInputField").setColor(currentColor);
            return;
        }
        float[] hsv = Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null);
        float x = (float)this.colorPickerBounds.x + hsv[1] * (float)this.colorPickerBounds.width;
        float y = (float)this.colorPickerBounds.y + (1.0f - hsv[2]) * (float)this.colorPickerBounds.height;
        this.pickerPos.set(x, y);
        for (String widgetKey : this.widgets.keySet()) {
            if (updateFlag.equals((Object)WidgetUpdateFlag.IGNORE_HEX) && widgetKey.equals("hexInputField")) {
                this.changedColorListener.accept(currentColor);
                continue;
            }
            this.widgets.get(widgetKey).setColor(currentColor);
        }
    }

    public void registerListener(Consumer<WakeColor> changedListener) {
        this.changedColorListener = changedListener;
    }

    public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
        double x = mouseButtonEvent.comp_4798();
        double y = mouseButtonEvent.comp_4799();
        class_339 focusedWidget = null;
        for (Bounded widget : this.widgets.values()) {
            widget.getWidget().method_25365(false);
            if (!widget.getBounds().contains((int)x, (int)y)) continue;
            focusedWidget = widget.getWidget();
        }
        if (focusedWidget != null) {
            focusedWidget.method_25365(true);
            focusedWidget.method_25348(mouseButtonEvent, bl);
            return;
        }
        this.updatePickerPos(x, y);
        super.method_25348(mouseButtonEvent, bl);
    }

    public void method_25349(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        double mouseX = Math.min((double)(this.method_46426() + this.field_22758), Math.max((double)this.method_46426(), mouseButtonEvent.comp_4798()));
        double mouseY = Math.min((double)(this.method_46427() + this.field_22759), Math.max((double)this.method_46427(), mouseButtonEvent.comp_4799()));
        for (Bounded widget : this.widgets.values()) {
            if (!widget.getWidget().method_25370()) continue;
            widget.getWidget().method_25349(mouseButtonEvent, deltaX, deltaY);
            return;
        }
        this.updatePickerPos(mouseX, mouseY);
        super.method_25349(mouseButtonEvent, deltaX, deltaY);
    }

    public Vector2f getPolarPos(double mouseX, double mouseY) {
        double x = mouseX - (double)this.pickerCenter.x;
        double y = mouseY - (double)this.pickerCenter.y;
        float r = (float)Math.min(Math.sqrt(x * x + y * y), (double)(this.pickerRadius * 0.9f));
        float v = (float)Math.atan2(y, x);
        return new Vector2f(r, v);
    }

    public void updatePickerPos(double mouseX, double mouseY) {
        mouseX = Math.min((double)(this.colorPickerBounds.x + this.colorPickerBounds.width), Math.max((double)this.colorPickerBounds.x, mouseX));
        mouseY = Math.min((double)(this.colorPickerBounds.y + this.colorPickerBounds.height), Math.max((double)this.colorPickerBounds.y, mouseY));
        this.pickerPos.set(mouseX, mouseY);
        this.updateColor();
    }

    public void updateColor() {
        float hue = ((ColorPickerSlider)this.widgets.get("hueSlider").getWidget()).getValue();
        float saturation = (this.pickerPos.x - (float)this.colorPickerBounds.x) / (float)this.colorPickerBounds.width;
        float value = 1.0f - (this.pickerPos.y - (float)this.colorPickerBounds.y) / (float)this.colorPickerBounds.height;
        float opacity = ((ColorPickerSlider)this.widgets.get("alphaSlider").getWidget()).getValue();
        WakeColor newColor = new WakeColor(hue, saturation, value, opacity);
        this.setColor(newColor, WidgetUpdateFlag.ONLY_HEX);
        this.changedColorListener.accept(newColor);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22763) {
            return;
        }
        context.method_25290(class_10799.field_56883, PICKER_BG_TEXTURE, this.colorPickerBounds.x, this.colorPickerBounds.y, 0.0f, 0.0f, this.colorPickerBounds.width, this.colorPickerBounds.height, this.colorPickerBounds.width, this.colorPickerBounds.height);
        context.method_25290(class_10799.field_56883, FRAME_TEXTURE, this.colorPickerBounds.x, this.colorPickerBounds.y, 0.0f, 0.0f, this.colorPickerBounds.width, this.colorPickerBounds.height, this.colorPickerBounds.width, this.colorPickerBounds.height);
        this.drawPickerBox(context);
        int d = 7;
        context.method_25290(class_10799.field_56883, PICKER_KNOB_TEXTURE, (int)this.pickerPos.x - 3, (int)this.pickerPos.y - 3, 0.0f, 0.0f, d, d, d, d);
    }

    private void drawPickerBox(class_332 context) {
        int y = this.colorPickerBounds.y + 3;
        int x = this.colorPickerBounds.x + 3;
        int w = this.colorPickerBounds.width - 6;
        int h = this.colorPickerBounds.height - 6;
        int hue = (int)(((ColorPickerSlider)this.widgets.get("hueSlider").getWidget()).getValue() * 255.0f);
        context.field_59826.method_70919((class_11244)new HsvQuadGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), x, y, w, h, 0x7F0000FF | hue << 16, 0x7F000000 | hue << 16, 0x7F00FF00 | hue << 16, 0x7F00FFFF | hue << 16, context.field_44659.method_70863()));
    }

    protected void method_47399(class_6382 builder) {
    }

    public static class AABB {
        public int x;
        public int y;
        public int width;
        public int height;

        public AABB(float fracX1, float fracY1, float fracX2, float fracY2, int globX, int globY, int totWidth, int totHeight) {
            this.x = Math.round(fracX1 * (float)totWidth) + globX + 1;
            this.y = Math.round(fracY1 * (float)totHeight) + globY + 1;
            this.width = Math.round((fracX2 - fracX1) * (float)totWidth) - 2;
            this.height = Math.round((fracY2 - fracY1) * (float)totHeight) - 2;
        }

        public boolean contains(int x, int y) {
            return this.x <= x && x < this.x + this.width && this.y <= y && y < this.y + this.height;
        }
    }

    private static class ColorPickerSlider
    extends class_357
    implements Bounded {
        protected AABB bounds;
        private final SliderUpdateType type;
        private final ColorPicker colorPicker;

        public ColorPickerSlider(AABB bounds, String text, ColorPicker colorPicker, SliderUpdateType type) {
            super(bounds.x, bounds.y, bounds.width, bounds.height, class_2561.method_30163((String)text), 1.0);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.type = type;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.field_22753 = this.type.equals((Object)SliderUpdateType.HUE) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[0] : (this.type.equals((Object)SliderUpdateType.SATURATION) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[1] : (this.type.equals((Object)SliderUpdateType.VALUE) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[2] : (double)((float)currentColor.a / 255.0f)));
        }

        public float getValue() {
            return (float)this.field_22753;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_52706(class_10799.field_56883, this.method_52716(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            if (this.type.equals((Object)SliderUpdateType.HUE)) {
                context.field_59826.method_70919((class_11244)new HsvQuadGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), this.method_46426() + 1, this.method_46427() + 1, this.method_25368() - 2, this.method_25364() - 2, 0x4000FFFF, 0x4000FFFF, 0x40FFFFFF, 0x40FFFFFF, context.field_44659.method_70863()));
            }
            context.method_52706(class_10799.field_56883, this.method_52717(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
            int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_49604(context, class_310.method_1551().field_1772, 2, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }

        protected void method_25346() {
        }

        protected void method_25344() {
            this.colorPicker.updateColor();
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    public static enum SliderUpdateType {
        HUE,
        SATURATION,
        VALUE,
        OPACITY;

    }

    private static class HexInputField
    extends class_342
    implements Bounded {
        protected AABB bounds;
        private final ColorPicker colorPicker;
        private final Pattern hexColorRegex;
        private boolean autoUpdate = false;

        public HexInputField(AABB bounds, ColorPicker colorPicker, class_327 textRenderer) {
            super(textRenderer, bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)class_2561.method_43473());
            this.method_1880(9);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.method_1890(HexInputField::validHex);
            this.hexColorRegex = Pattern.compile("#[a-f0-9]{7,9}", 2);
        }

        protected void method_1874(String newText) {
            if (this.autoUpdate) {
                return;
            }
            if (this.hexColorRegex.matcher(newText).find()) {
                this.colorPicker.setColor(new WakeColor(newText), WidgetUpdateFlag.IGNORE_HEX);
            }
            super.method_1874(newText);
        }

        private static boolean validHex(String text) {
            if (text.length() > 9) {
                return false;
            }
            for (char c : text.toLowerCase().toCharArray()) {
                if (Character.digit(c, 16) != -1 || c == '#') continue;
                return false;
            }
            return true;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        public boolean method_25400(class_11905 characterEvent) {
            this.autoUpdate = false;
            return super.method_25400(characterEvent);
        }

        public boolean method_25404(class_11908 keyEvent) {
            this.autoUpdate = false;
            return super.method_25404(keyEvent);
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.autoUpdate = true;
            this.method_1852(currentColor.toHex());
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    public static interface Bounded {
        public AABB getBounds();

        public class_339 getWidget();

        public void setActive(boolean var1);

        public void setColor(WakeColor var1);
    }

    public static enum WidgetUpdateFlag {
        ALL,
        ONLY_HEX,
        IGNORE_HEX;

    }
}

