/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config.gui;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.gui.ColorPicker;
import com.goby56.wakes.config.gui.ColorPickerScreen;
import com.goby56.wakes.config.gui.SliderHandle;
import com.goby56.wakes.render.WakeColor;
import com.goby56.wakes.simulation.WakeHandler;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;

public class ColorIntervalSlider
extends class_357 {
    private ArrayList<SliderHandle> handles;
    private final ColorPicker colorPicker;
    private Integer activeSection = null;

    public ColorIntervalSlider(ColorPickerScreen screenContext, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)""), 0.0);
        this.initHandles();
        this.colorPicker = new ColorPicker(screenContext, 10, screenContext.field_22790 / 2, 128, 128);
        this.colorPicker.registerListener(this::onColorPicked);
    }

    public void initHandles() {
        this.handles = new ArrayList();
        for (float val : WakesConfig.wakeColorIntervals) {
            this.handles.add(new SliderHandle(val));
        }
    }

    public void updateColorPicker() {
        if (!this.colorPicker.field_22763 || this.activeSection == null) {
            return;
        }
        this.colorPicker.setColor(WakesConfig.getWakeColor(this.activeSection), ColorPicker.WidgetUpdateFlag.ALL);
    }

    private void unfocusHandles() {
        for (SliderHandle handle : this.handles) {
            handle.focused = false;
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, this.method_52716(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        this.field_22762 = context.method_58135(mouseX, mouseY) && mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        int n = this.handles.size();
        int y = this.method_46427();
        int prevX = this.method_46426();
        for (int i = 0; i < n; ++i) {
            float value = this.handles.get((int)i).value;
            int currX = this.method_46426() + (int)((double)value * (double)this.field_22758);
            context.method_25294(prevX + 1, y + 1, currX, y + this.field_22759 - 1, WakesConfig.getWakeColor((int)i).modifyOpacity((float)0.5f).argb);
            prevX = currX;
        }
        context.method_25294(prevX + 1, y + 1, this.method_46426() + this.field_22758 - 1, y + this.field_22759 - 1, WakesConfig.getWakeColor((int)n).modifyOpacity((float)0.5f).argb);
        float hoveredVal = this.valueFromMousePos(mouseX);
        boolean correctY = mouseY >= this.method_46427() && mouseY < this.method_46427() + this.field_22759;
        for (SliderHandle handle : this.handles) {
            boolean isHovered = handle.inProximity(hoveredVal, this.field_22758, 8) && correctY;
            context.method_52706(class_10799.field_56883, handle.getHandleTexture(isHovered), this.method_46426() + (int)((double)handle.value * (double)(this.field_22758 - 4)), this.method_46427(), 8, this.method_25364());
        }
    }

    public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
        boolean shiftDown = mouseButtonEvent.method_74239();
        float value = this.valueFromMousePos(mouseButtonEvent.comp_4798());
        SliderHandle handle = this.closestHandle(value);
        this.unfocusHandles();
        if (handle != null && handle.inProximity(value, this.field_22758, 8)) {
            if (shiftDown) {
                this.removeHandle(this.handles.indexOf(handle));
            } else {
                handle.focused = true;
            }
        } else {
            int clickedSection = this.getActiveSection(value);
            if (shiftDown) {
                this.addHandle(clickedSection, value);
            } else {
                if (this.activeSection != null && clickedSection != this.activeSection) {
                    this.colorPicker.setActive(true);
                } else {
                    this.colorPicker.setActive(!this.colorPicker.field_22763);
                }
                this.activeSection = clickedSection;
                this.colorPicker.setColor(WakesConfig.getWakeColor(this.activeSection), ColorPicker.WidgetUpdateFlag.ALL);
            }
        }
    }

    private void addHandle(int index, float value) {
        this.handles.add(index, new SliderHandle(value));
        WakesConfig.wakeColors.add(index, WakesConfig.getWakeColor(index).toHex());
        WakesConfig.wakeColorIntervals.add(index, Float.valueOf(value));
        WakeHandler.getInstance().ifPresent(WakeHandler::recolorWakes);
    }

    private void removeHandle(int index) {
        if (index == -1) {
            return;
        }
        this.handles.remove(index);
        WakesConfig.wakeColors.remove(index);
        WakesConfig.wakeColorIntervals.remove(index);
        WakeHandler.getInstance().ifPresent(WakeHandler::recolorWakes);
    }

    public void method_25357(class_11909 mouseButtonEvent) {
        this.unfocusHandles();
        super.method_25357(mouseButtonEvent);
    }

    public void method_25349(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        Collections.sort(this.handles);
        float value = this.valueFromMousePos(mouseButtonEvent.comp_4798());
        for (SliderHandle handle : this.handles) {
            if (!handle.focused || !handle.setValue(value)) continue;
            this.method_25344();
        }
    }

    private void onColorPicked(WakeColor color) {
        if (this.activeSection != null) {
            WakesConfig.wakeColors.set(this.activeSection, color.toHex());
            WakesConfig.write((String)"wakes");
            WakeHandler.getInstance().ifPresent(WakeHandler::recolorWakes);
        }
    }

    private float valueFromMousePos(double mouseX) {
        return (float)((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private SliderHandle closestHandle(float value) {
        float min = 1.0f;
        SliderHandle closest = null;
        for (SliderHandle handle : this.handles) {
            float d = Math.abs(handle.value - value);
            if (!(d < min)) continue;
            closest = handle;
            min = d;
        }
        return closest;
    }

    private int getActiveSection(float value) {
        for (int i = 0; i < this.handles.size(); ++i) {
            if (!(this.handles.get((int)i).value > value)) continue;
            return i;
        }
        return this.handles.size();
    }

    protected void method_25346() {
    }

    protected void method_25344() {
        for (int i = 0; i < this.handles.size(); ++i) {
            WakesConfig.wakeColorIntervals.set(i, Float.valueOf(this.handles.get((int)i).value));
        }
        WakesConfig.write((String)"wakes");
        WakeHandler.getInstance().ifPresent(WakeHandler::recolorWakes);
    }
}

