/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.list;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;

public class SortingList {
    @CreativeConfig
    public List<CreativeIngredient> entries = new ArrayList<CreativeIngredient>();
    @CreativeConfig
    public boolean isWhitelist;

    public SortingList(SortingList list) {
        this.isWhitelist = list.isWhitelist;
        this.entries = new ArrayList<CreativeIngredient>(list.entries);
    }

    public SortingList() {
        this(true);
    }

    public SortingList(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean isBlacklist() {
        return !this.isWhitelist();
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setListType(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public void setWhitelist() {
        this.isWhitelist = true;
    }

    public void setBlacklist() {
        this.isWhitelist = false;
    }

    public void addSortingObjects(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.addSortingObject(objects[i]);
        }
    }

    public void addSortingObject(Object object) {
        if (object instanceof CreativeIngredient) {
            CreativeIngredient ingredient = (CreativeIngredient)object;
            this.entries.add(ingredient);
            return;
        }
        CreativeIngredient info = CreativeIngredient.parse(object);
        if (info != null) {
            this.entries.add(info);
        }
    }

    public void addSortingByBlock(class_2248 block) {
        this.entries.add(new CreativeIngredientBlock(block));
    }

    public void addSortingByItem(class_1792 item) {
        this.entries.add(new CreativeIngredientItem(item));
    }

    public void addSortingByItemStack(class_1799 stack) {
        this.entries.add(new CreativeIngredientItemStack(stack));
    }

    public void addSortingByBlockTag(class_6862<class_2248> tag) {
        this.entries.add(new CreativeIngredientBlockTag(tag));
    }

    public void addSortingByItemTag(class_6862<class_1792> tag) {
        this.entries.add(new CreativeIngredientItemTag(tag));
    }

    protected boolean canBeFoundInList(Object object) {
        CreativeIngredient info = CreativeIngredient.parse(object);
        if (info == null) {
            return false;
        }
        for (CreativeIngredient ingredient : this.entries) {
            if (!ingredient.is(info)) continue;
            return true;
        }
        return false;
    }

    protected boolean canBeFoundInList(class_1937 level, class_1799 stack) {
        for (CreativeIngredient ingredient : this.entries) {
            if (!ingredient.is(level, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean canPass(Object object) {
        return this.canBeFoundInList(object) == this.isWhitelist;
    }

    public boolean canPass(class_1937 level, class_1799 stack) {
        return this.canBeFoundInList(level, stack) == this.isWhitelist;
    }
}

