/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class InventoryUtils {
    public static class_2487 save(class_7225.class_7874 provider, class_1277 basic) {
        class_2487 nbt = new class_2487();
        for (int i = 0; i < basic.method_5439(); ++i) {
            if (basic.method_5438(i).method_7960()) continue;
            nbt.method_67494("s" + i, class_1799.field_49266, (Object)basic.method_5438(i));
        }
        nbt.method_10569("size", basic.method_5439());
        return nbt;
    }

    public static class_1277 load(class_7225.class_7874 provider, class_2487 nbt) {
        return InventoryUtils.load(provider, nbt, nbt.method_68083("size", 0));
    }

    public static class_1277 load(class_7225.class_7874 provider, class_2487 nbt, int length) {
        class_1277 basic = new class_1277(length);
        for (int i = 0; i < length; ++i) {
            if (nbt.method_10545("s" + i)) {
                basic.method_5447(i, (class_1799)nbt.method_67491("s" + i, class_1799.field_49266).get());
                continue;
            }
            basic.method_5447(i, class_1799.field_8037);
        }
        return basic;
    }

    public static boolean isItemStackEqual(class_1799 stackA, class_1799 stackB) {
        if (stackA.method_7960() && stackB.method_7960()) {
            return true;
        }
        if (stackA.method_7960() || stackB.method_7960()) {
            return false;
        }
        if (stackA.method_7909() != stackB.method_7909()) {
            return false;
        }
        return class_1799.method_31577((class_1799)stackA, (class_1799)stackB);
    }

    public static boolean consumeItemStack(class_1263 inventory, class_1799 stack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.method_5438(i), stack)) continue;
            int amount = Math.min(stack.method_7947(), inventory.method_5438(i).method_7947());
            if (amount > 0) {
                inventory.method_5438(i).method_7934(amount);
                stack.method_7934(amount);
            }
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public static boolean addItemStackToInventory(class_1263 inventory, class_1799 stack) {
        int i;
        for (i = 0; i < inventory.method_5439(); ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory.method_5438(i), stack) || (amount = Math.min(stack.method_7914() - inventory.method_5438(i).method_7947(), stack.method_7947())) <= 0) continue;
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(inventory.method_5438(i).method_7947() + amount);
            inventory.method_5447(i, newStack);
            stack.method_7934(amount);
            if (!stack.method_7960()) continue;
            return true;
        }
        for (i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            inventory.method_5447(i, stack);
            return true;
        }
        return false;
    }

    public static int getAmount(class_1263 inventory, class_1799 stack) {
        int amount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.method_5438(i), stack)) continue;
            amount += inventory.method_5438(i).method_7947();
        }
        return amount;
    }

    public static void cleanInventory(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack == null || !stack.method_7960()) continue;
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public static int consume(class_1937 level, CreativeIngredient info, class_1263 inventory) {
        return InventoryUtils.consume(level, info, inventory, null);
    }

    public static int consume(class_1937 level, CreativeIngredient info, class_1263 inventory, ArrayList<class_1799> consumed) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int stackSize = 1;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !info.is(level, stack)) continue;
            int used = Math.min(stackSize, stack.method_7947());
            stack.method_7934(used);
            class_1799 stackCopy = stack.method_7972();
            stackCopy.method_7939(used);
            stacks.add(stackCopy);
            if ((stackSize -= used) <= 0) break;
        }
        if (consumed != null) {
            consumed.addAll(stacks);
        }
        return stackSize;
    }

    public static void sortInventory(class_1263 inventory, boolean alphabetical) {
        int i;
        ArrayList<class_1799> sorting = new ArrayList<class_1799>();
        for (int i2 = 0; i2 < inventory.method_5439(); ++i2) {
            class_1799 stack = inventory.method_5438(i2);
            if (stack.method_7960()) continue;
            sorting.add(stack);
        }
        if (alphabetical) {
            Collections.sort(sorting, new Comparator<class_1799>(){

                @Override
                public int compare(class_1799 arg0, class_1799 arg1) {
                    return class_7923.field_41178.method_10221((Object)arg0.method_7909()).toString().compareToIgnoreCase(class_7923.field_41178.method_10221((Object)arg1.method_7909()).toString());
                }
            });
        } else {
            Collections.sort(sorting, new Comparator<class_1799>(){

                @Override
                public int compare(class_1799 arg0, class_1799 arg1) {
                    int id1;
                    int id0 = class_1792.method_7880((class_1792)arg0.method_7909());
                    if (id0 < (id1 = class_1792.method_7880((class_1792)arg1.method_7909()))) {
                        return -1;
                    }
                    if (id0 > id1) {
                        return 1;
                    }
                    if (arg0.method_7919() < arg1.method_7919()) {
                        return -1;
                    }
                    if (arg0.method_7919() > arg1.method_7919()) {
                        return 1;
                    }
                    return class_7923.field_41178.method_10221((Object)arg0.method_7909()).toString().compareToIgnoreCase(class_7923.field_41178.method_10221((Object)arg1.method_7909()).toString());
                }
            });
        }
        int maxStackSize = inventory.method_5444();
        for (i = 0; i < sorting.size() - 1; ++i) {
            int maxStack;
            int use;
            class_1799 stack1;
            class_1799 stack0 = (class_1799)sorting.get(i);
            if (!InventoryUtils.isItemStackEqual(stack0, stack1 = (class_1799)sorting.get(i + 1)) || (use = Math.min((maxStack = Math.min(maxStackSize, stack0.method_7914())) - stack0.method_7947(), stack1.method_7947())) <= 0) continue;
            stack0.method_7933(use);
            stack1.method_7934(use);
            if (stack1.method_7960()) {
                sorting.remove(i + 1);
            }
            --i;
        }
        for (i = 0; i < inventory.method_5439(); ++i) {
            inventory.method_5447(i, i < sorting.size() ? (class_1799)sorting.get(i) : class_1799.field_8037);
        }
    }

    public static String toString(class_1263 inventory) {
        Object result = "[";
        boolean first = true;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (first) {
                first = false;
            } else {
                result = (String)result + ",";
            }
            result = (String)result + stack.toString();
        }
        return (String)result + "]";
    }
}

