/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter.premade;

import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.Filter;

public class ItemFilters {
    public static Filter<class_1792> item(class_1792 item) {
        return new ItemFilter(item);
    }

    public static Filter<class_1792> items(class_1792 ... items) {
        return new ItemsFilter(items);
    }

    public static Filter<class_1792> instance(Class<? extends class_1792> clazz) {
        return new ItemClassFilter(clazz);
    }

    public static Filter<class_1792> and(Filter<class_1792> ... filters) {
        return Filter.and(filters);
    }

    public static Filter<class_1792> or(Filter<class_1792> ... filters) {
        return Filter.or(filters);
    }

    public static Filter<class_1792> not(Filter<class_1792> filter) {
        return Filter.not(filter);
    }

    static {
        Filter.SERIALIZER.register("item", ItemFilter.class);
        Filter.SERIALIZER.register("items", ItemsFilter.class);
        Filter.SERIALIZER.register("iclass", ItemClassFilter.class);
    }

    private static class ItemFilter
    implements Filter<class_1792>,
    CompoundSerializer {
        public final class_1792 item;

        public ItemFilter(class_1792 item) {
            this.item = item;
        }

        public ItemFilter(class_2487 nbt) {
            this.item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)nbt.method_68564("i", "")));
        }

        @Override
        public boolean is(class_1792 t) {
            return t == this.item;
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("i", class_7923.field_41178.method_10221((Object)this.item).toString());
            return nbt;
        }
    }

    private static class ItemsFilter
    implements Filter<class_1792>,
    CompoundSerializer {
        public final class_1792[] items;

        public ItemsFilter(class_1792 ... items) {
            this.items = items;
        }

        public ItemsFilter(class_2487 nbt) {
            class_2499 list = nbt.method_68569("i");
            this.items = new class_1792[list.size()];
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)list.method_68577(i, "")));
            }
        }

        @Override
        public boolean is(class_1792 t) {
            return ArrayUtils.contains((Object[])this.items, (Object)t);
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            class_2499 list = new class_2499();
            for (int i = 0; i < this.items.length; ++i) {
                list.add((Object)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)this.items[i]).toString()));
            }
            nbt.method_10566("i", (class_2520)list);
            return nbt;
        }
    }

    private static class ItemClassFilter
    implements Filter<class_1792>,
    CompoundSerializer {
        public final Class<? extends class_1792> clazz;

        public ItemClassFilter(Class<? extends class_1792> clazz) {
            this.clazz = clazz;
        }

        public ItemClassFilter(class_2487 nbt) {
            Class<?> temp = null;
            try {
                temp = Class.forName(nbt.method_68564("c", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clazz = temp;
        }

        @Override
        public boolean is(class_1792 t) {
            return this.clazz != null && this.clazz.isInstance(t);
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("c", this.clazz.getName());
            return nbt;
        }
    }
}

