/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.timeline;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.timeline.GuiAnimationHandler;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineHeader;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiControlEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiTimeline
extends GuiParent {
    public final GuiAnimationHandler handler;
    private final GuiRow header;
    private final List<GuiTimelineChannel> channels = new ArrayList<GuiTimelineChannel>();
    private final GuiParent sidebar;
    private final GuiParent channelbar;
    private final GuiScrollY channelParent;
    protected int duration = 100;
    protected int headerHeight = 15;
    protected int channelHeight = 9;
    protected int sidebarWidth = 50;
    private GuiTimelineKey selected;

    public GuiTimeline(IGuiParent parent, GuiAnimationHandler handler) {
        super(parent);
        this.handler = handler;
        this.setAlign(Align.STRETCH);
        this.setVAlign(VAlign.STRETCH);
        this.setFlow(GuiFlow.STACK_Y);
        this.setSpacing(-1);
        this.header = new GuiRow((IGuiParent)((GuiColumn.GuiColumnHeader)new GuiColumn.GuiColumnHeader(this).setDim(new GuiSizeRule.GuiFixedDimension(this.sidebarWidth))), new GuiTimelineHeader(this));
        this.header.setDim(new GuiSizeRule.GuiSizeRules().prefHeight(this.headerHeight).minHeight(this.headerHeight));
        this.header.setSpacing(-1);
        this.add((GuiControl)this.header);
        this.channelParent = new GuiScrollY(this).setScrollWhenCTRL().setHovered().setFormatting(ControlFormatting.TRANSPARENT);
        this.channelParent.setSpacing(-1);
        this.channelParent.setAlign(Align.STRETCH);
        this.channelParent.setFlow(GuiFlow.STACK_X);
        this.add((GuiControl)this.channelParent);
        this.sidebar = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        this.sidebar.setSpacing(-1);
        this.channelParent.add((GuiControl)this.sidebar);
        this.channelbar = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        this.channelbar.setSpacing(-1);
        this.channelParent.add(this.channelbar.setExpandableX());
    }

    public Iterable<GuiTimelineChannel> channels() {
        return this.channels;
    }

    public GuiScrollY getChannelParent() {
        return this.channelParent;
    }

    @Override
    public GuiTimelineDist dist() {
        return (GuiTimelineDist)super.dist();
    }

    public int getDuration() {
        return this.duration;
    }

    public GuiTimeline setDuration(int duration) {
        this.duration = duration;
        this.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this));
        return this;
    }

    public void selectKey(GuiTimelineKey key) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = key;
        this.selected.setSelected(true);
        this.raiseEvent(new KeySelectedEvent(key));
    }

    public void deselect() {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
            this.raiseEvent(new NoKeySelectedEvent(this));
        }
    }

    public void adjustKeyPositionX(GuiTimelineKey key) {
        if (this.dist() != null) {
            this.dist().adjustKeyPositionX(key);
        }
    }

    public void adjustKeysPositionX() {
        if (this.dist() != null) {
            this.dist().adjustKeysPositionX();
        }
    }

    public void setSidebarWidth(int sidebarWidth) {
        this.sidebarWidth = sidebarWidth;
        this.sidebar.setDim(sidebarWidth, -1);
    }

    public GuiTimelineChannel addGuiTimelineChannel(class_5250 title, GuiTimelineChannel channel) {
        GuiColumn.GuiColumnHeader left = new GuiColumn.GuiColumnHeader(this);
        left.add((GuiControl)new GuiLabel(this, "title").setDropShadow(false).setDefaultColor(-16777216).setTitle((class_2561)title.method_27692(class_124.field_1067)));
        this.sidebar.add(left.setVAlign(VAlign.CENTER).setDim(this.sidebarWidth, this.channelHeight));
        channel.sidebarTitle = left;
        this.channels.add(channel);
        this.channelbar.add(channel.setDim(-1, this.channelHeight));
        return channel;
    }

    public void removeChannel(GuiTimelineChannel channel) {
        this.sidebar.remove(channel.sidebarTitle);
        this.channelbar.remove(channel);
        this.channels.remove(channel);
        this.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this));
    }

    @Override
    public boolean isExpandableX() {
        if (this.dist() != null) {
            return this.dist().isExpandableX();
        }
        return false;
    }

    public static interface GuiTimelineDist
    extends GuiParent.GuiParentDistHandler {
        public void afterDurationSet();

        public void adjustKeyPositionX(GuiTimelineKey var1);

        public void adjustKeysPositionX();
    }

    public static class KeySelectedEvent
    extends GuiControlEvent<GuiTimelineKey> {
        public KeySelectedEvent(GuiTimelineKey source) {
            super(source);
        }

        @Override
        public boolean cancelable() {
            return false;
        }
    }

    public static class NoKeySelectedEvent
    extends GuiControlEvent<GuiTimeline> {
        public NoKeySelectedEvent(GuiTimeline timeline) {
            super(timeline);
        }

        @Override
        public boolean cancelable() {
            return false;
        }
    }
}

