/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.util.mc.StackUtils;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelector
extends GuiLabel {
    public GuiStackSelector(IGuiParent parent, String name, StackCollector collector, boolean searchbar) {
        super(parent, name);
        if (this.dist() != null) {
            this.dist().setSearchbar(searchbar);
            this.dist().setCollector(collector);
            this.dist().updateCollectedStacks(false);
            this.dist().selectFirst(false);
        }
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(IGuiParent parent, String name, StackCollector collector) {
        this(parent, name, collector, true);
    }

    @Override
    public GuiStackSelectorDist dist() {
        return (GuiStackSelectorDist)super.dist();
    }

    public GuiStackSelector setWidth(int width) {
        this.setDim(width, 14);
        return this;
    }

    public boolean hasSearchbar() {
        if (this.dist() != null) {
            return this.dist().hasSearchbar();
        }
        return false;
    }

    public GuiStackSelector setSearchbar(boolean searchbar) {
        if (this.dist() != null) {
            this.dist().setSearchbar(searchbar);
        }
        return this;
    }

    public boolean selectFirst() {
        if (this.dist() != null) {
            return this.dist().selectFirst(true);
        }
        return false;
    }

    public void updateCollectedStacks() {
        if (this.dist() != null) {
            this.dist().updateCollectedStacks(true);
        }
    }

    public boolean setSelectedForce(class_1799 stack) {
        if (this.dist() != null) {
            return this.dist().setSelectedForce(stack, true);
        }
        return false;
    }

    public boolean setSelected(class_1799 stack) {
        if (this.dist() != null) {
            return this.dist().setSelected(stack, true);
        }
        return false;
    }

    public HashMapList<String, class_1799> getStacks() {
        if (this.dist() != null) {
            return this.dist().getStacks();
        }
        return null;
    }

    public class_1799 getSelected() {
        if (this.dist() != null) {
            return this.dist().getSelected();
        }
        return class_1799.field_8037;
    }

    public static boolean contains(String search, class_1799 stack) {
        if (search.isEmpty()) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (class_2561 line : stack.method_7950(class_1792.class_9635.field_51353, null, (class_1836)class_1836.class_1837.field_41070)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(class_1799 stack) {
        String itemName = "";
        try {
            itemName = stack.method_7954().getString();
        }
        catch (Exception e) {
            itemName = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        }
        return itemName;
    }

    public static interface GuiStackSelectorDist
    extends GuiLabel.GuiLabelDist {
        public void setCollector(StackCollector var1);

        public boolean hasSearchbar();

        public void setSearchbar(boolean var1);

        public boolean selectFirst(boolean var1);

        public void updateCollectedStacks(boolean var1);

        public boolean setSelectedForce(class_1799 var1, boolean var2);

        public boolean setSelected(class_1799 var1, boolean var2);

        public HashMapList<String, class_1799> getStacks();

        public class_1799 getSelected();
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, class_1799> collect(class_1657 var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(class_1799 stack) {
            if (super.allow(stack)) {
                return !(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2189);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(class_1799 stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(class_1799 var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, class_1799> collect(class_1657 player) {
            HashMapList<String, class_1799> stacks = super.collect(player);
            ArrayList<class_1799> newStacks = new ArrayList<class_1799>();
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = new class_1799((class_1935)item);
                if (!this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("collector.all", (class_1799)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, class_1799> collect(class_1657 player) {
            HashMapList<String, class_1799> stacks = new HashMapList<String, class_1799>();
            if (player != null) {
                ArrayList<class_1799> tempStacks = new ArrayList<class_1799>();
                for (class_1799 stack : player.field_7498.method_7602()) {
                    if (!stack.method_7960() && this.selector.allow(stack)) {
                        tempStacks.add(stack.method_7972());
                        continue;
                    }
                    StackUtils.collect(stack, this.selector::allow, tempStacks);
                }
                stacks.add("collector.inventory", (class_1799)tempStacks);
            }
            return stacks;
        }
    }
}

