/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.mc.JsonUtils;

public class ConfigEventHandler {
    private final DecimalFormat df = this.generateFormat();
    private final File CONFIG_DIRECTORY;
    private final Logger LOGGER;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Environment(value=EnvType.CLIENT)
    private void client() {
        ClientLifecycleEvents.CLIENT_STARTED.register(x -> this.load((class_7225.class_7874)(x.field_1687 != null ? x.field_1687.method_30349() : null), Side.CLIENT));
    }

    public ConfigEventHandler(File CONFIG_DIRECTORY, Logger LOGGER) {
        this.CONFIG_DIRECTORY = CONFIG_DIRECTORY;
        this.LOGGER = LOGGER;
        ServerPlayConnectionEvents.JOIN.register(this::playerLoggedIn);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.load((class_7225.class_7874)server.method_30611(), Side.SERVER));
        if (CreativeCore.loader().getOverallSide().isClient()) {
            this.client();
        }
    }

    public static List<String> loadClientFieldList(ICreativeConfigHolder holder) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.loadClientFieldList(holder, configKey, enabled);
        }
        return enabled;
    }

    private static List<String> loadClientFieldList(ICreativeConfigHolder parent, ConfigKey field, List<String> list) {
        if (field.forceSynchronization) {
            list.add((String)(parent.path().length > 0 ? String.join((CharSequence)".", parent.path()) + "." : "") + field.name);
            return list;
        }
        if (field.isFolder()) {
            for (ConfigKey configKey : field.holder().fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.loadClientFieldList(field.holder(), configKey, list);
            }
        }
        return list;
    }

    public static void saveClientFieldList(ICreativeConfigHolder holder, List<String> enabled) {
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.saveClientFieldList(String.join((CharSequence)".", holder.path()), configKey, enabled);
        }
    }

    private static void saveClientFieldList(String path, ConfigKey field, List<String> enabled) {
        if (!((String)path).isEmpty()) {
            path = (String)path + ".";
        }
        if (enabled.contains(path = (String)path + field.name)) {
            ConfigEventHandler.enable(field);
        } else {
            field.forceSynchronization = false;
            if (field.isFolder()) {
                for (ConfigKey configKey : field.holder().fields()) {
                    if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                    ConfigEventHandler.saveClientFieldList((String)path, configKey, enabled);
                }
            }
        }
    }

    private static void enable(ConfigKey field) {
        field.forceSynchronization = true;
        if (field.isFolder()) {
            for (ConfigKey configKey : field.holder().fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.enable(configKey);
            }
        }
    }

    private DecimalFormat generateFormat() {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        return df;
    }

    public void playerLoggedIn(class_3244 handler, PacketSender sender, MinecraftServer server) {
        if (!server.method_3724() || !this.isOwner(handler.method_32311())) {
            CreativeCore.NETWORK.sendToClient((CreativePacket)new ConfigurationClientPacket(CreativeConfigRegistry.ROOT), handler.method_32311());
            CreativeCore.NETWORK.sendToClient((CreativePacket)new ConfigurationPacket((class_7225.class_7874)server.method_30611(), CreativeConfigRegistry.ROOT, false), handler.method_32311());
        }
    }

    public boolean isOwner(class_3222 player) {
        return player.method_51469().method_8503().method_19466(player.method_72498());
    }

    public void sync(ICreativeConfigHolder holder, MinecraftServer server) {
        CreativeCore.NETWORK.sendToClientAll(server, new ConfigurationPacket((class_7225.class_7874)server.method_30611(), holder, true));
    }

    public void sync(ICreativeConfigHolder holder, class_3222 player) {
        CreativeCore.NETWORK.sendToClient((CreativePacket)new ConfigurationPacket((class_7225.class_7874)player.method_56673(), holder, true), player);
    }

    public void syncAll(MinecraftServer server) {
        this.sync((ICreativeConfigHolder)CreativeConfigRegistry.ROOT, server);
    }

    public void syncAll(class_3222 player) {
        this.sync((ICreativeConfigHolder)CreativeConfigRegistry.ROOT, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClientFields() {
        File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
        List<String> enabled = ConfigEventHandler.loadClientFieldList(CreativeConfigRegistry.ROOT);
        if (enabled.isEmpty()) {
            config.delete();
            return;
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < enabled.size(); ++i) {
            array.add(enabled.get(i));
        }
        try (FileWriter writer = new FileWriter(config, StandardCharsets.UTF_8);){
            this.GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to save client field config file {0}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(class_7225.class_7874 provider, String modid, Side side) {
        block7: {
            try {
                ConfigKey field = CreativeConfigRegistry.ROOT.getField(modid);
                File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
                if (field.isFolder()) {
                    JsonObject json = field.holder().save(provider, true, false, side);
                    JsonUtils.cleanUp(json);
                    if (json.size() <= 0) break block7;
                    FileWriter writer = new FileWriter(config, StandardCharsets.UTF_8);
                    JsonWriter jsonWriter = new JsonWriter(writer){

                        public JsonWriter value(double value) throws IOException {
                            if (Double.isNaN(value) || Double.isInfinite(value)) {
                                throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
                            }
                            return this.jsonValue(ConfigEventHandler.this.df.format(value));
                        }

                        public JsonWriter value(Number value) throws IOException {
                            if (value instanceof Double || value.getClass() == Double.TYPE) {
                                return this.value((Double)value);
                            }
                            return super.value(value);
                        }
                    };
                    jsonWriter.setIndent("  ");
                    try {
                        this.GSON.toJson((JsonElement)json, jsonWriter);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                if (config.exists()) {
                    config.delete();
                }
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to save config file of '{0}', {1}", (Object)modid, (Object)e);
            }
        }
    }

    public void save(class_7225.class_7874 provider, Side side) {
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.save(provider, modid, side);
        }
    }

    public void loadClientFields() {
        ArrayList<String> list;
        block6: {
            File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config, StandardCharsets.UTF_8);
                    JsonArray array = (JsonArray)this.GSON.fromJson((Reader)reader, JsonArray.class);
                    if (array != null) {
                        list = new ArrayList<String>(array.size());
                        for (int i = 0; i < array.size(); ++i) {
                            JsonElement element = array.get(i);
                            if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) continue;
                            list.add(element.getAsString());
                        }
                        break block6;
                    }
                    list = Collections.EMPTY_LIST;
                }
                catch (IOException e) {
                    list = Collections.EMPTY_LIST;
                    this.LOGGER.error("Failed to load client fields config file, {0}", (Throwable)e);
                }
            } else {
                list = Collections.EMPTY_LIST;
            }
        }
        ConfigEventHandler.saveClientFieldList(CreativeConfigRegistry.ROOT, (List<String>)list);
    }

    public void load(class_7225.class_7874 provider, String modid, Side side) {
        ConfigKey field = CreativeConfigRegistry.ROOT.getField(modid);
        if (field.isFolder()) {
            File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config, StandardCharsets.UTF_8);
                    JsonObject json = null;
                    try {
                        json = (JsonObject)this.GSON.fromJson((Reader)reader, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        e.printStackTrace();
                    }
                    if (json == null) {
                        json = new JsonObject();
                    }
                    field.holder().load(provider, true, false, json, side);
                }
                catch (IOException e) {
                    this.LOGGER.error("Failed to load config file of '{0}', {1}", (Object)modid, (Object)e);
                }
            } else {
                field.holder().restoreDefault(side, false);
            }
        }
    }

    public void load(class_7225.class_7874 provider, Side side) {
        this.loadClientFields();
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.load(provider, modid, side);
        }
        this.save(provider, side);
    }

    public boolean isSynchronizedWithServer(String key) {
        String[] path = key.split(".");
        ConfigKey config = CreativeConfigRegistry.ROOT.findKey(path);
        if (config != null) {
            return config.is(Side.SERVER);
        }
        return false;
    }

    public boolean modFileExist(String modid, EnvType side) {
        File config = new File(this.CONFIG_DIRECTORY, modid + (side == EnvType.CLIENT ? "-client" : "") + ".json");
        return config.exists();
    }
}

