/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3749;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5172;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;

public class LanternDecorator
extends class_4662 {
    public static final MapCodec<LanternDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)class_6017.method_35004((int)0, (int)10).fieldOf("lantern_count").orElse((Object)class_6016.method_34998((int)3)).forGetter(decorator -> decorator.count), (App)class_6017.method_35004((int)0, (int)10).fieldOf("chain_length").orElse((Object)class_6016.method_34998((int)1)).forGetter(decorator -> decorator.chainLength)).apply((Applicative)builder, LanternDecorator::new));
    private final class_2680 chain = (class_2680)class_2246.field_23985.method_9564().method_11657((class_2769)class_5172.field_11459, (Comparable)class_2350.class_2351.field_11052);
    private final class_2680 lantern = (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.TRUE);
    private final float probability;
    private final class_6017 count;
    private final class_6017 chainLength;

    public LanternDecorator(float probability, class_6017 count, class_6017 chainLength) {
        this.probability = probability;
        this.count = count;
        this.chainLength = chainLength;
    }

    protected class_4663<?> method_28893() {
        return ModRegistry.LANTERN.get();
    }

    public void method_23469(class_4662.class_7402 context) {
        class_5819 random = context.method_43320();
        if (random.method_43057() > this.probability) {
            return;
        }
        int count = this.count.method_35008(random);
        List<class_2338> possible = LanternDecorator.getLeavesShuffled(context, count);
        for (int i = 0; i < possible.size(); ++i) {
            class_2338 blockpos = possible.get(i);
            for (int length = this.chainLength.method_35008(random); context.method_43317(blockpos) && length > 0; --length) {
                context.method_43318(blockpos, this.chain);
                blockpos = blockpos.method_10074();
            }
            context.method_43318(blockpos, this.lantern);
        }
    }

    private static List<class_2338> getLeavesShuffled(class_4662.class_7402 context, int maxCount) {
        List<class_2338> all = context.method_43322().stream().map(class_2338::method_10074).filter(arg_0 -> ((class_4662.class_7402)context).method_43317(arg_0)).distinct().collect(Collectors.toList());
        Collections.shuffle(all);
        int maxIndex = Math.min(maxCount, all.size());
        all.subList(maxIndex, all.size()).clear();
        return all;
    }
}

