/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.util;

import com.frikinjay.almanac.platform.ConfigHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemNBTUtil {
    private static List<Pattern> blacklistPattern = new ArrayList<Pattern>();
    private static Set<class_1792> blacklistCache = new HashSet<class_1792>();
    private static Set<class_1792> checkedItemsCache = new HashSet<class_1792>();

    private static boolean isItemOnBlacklist(class_1799 stack) {
        if (stack == null || stack.method_7960() || blacklistPattern.isEmpty()) {
            return true;
        }
        class_1792 item = stack.method_7909();
        if (blacklistCache.contains(item)) {
            return true;
        }
        if (checkedItemsCache.contains(item)) {
            return false;
        }
        class_2960 RLItemId = class_7923.field_41178.method_10221((Object)item);
        if (RLItemId == null) {
            return true;
        }
        String id = RLItemId.toString();
        ItemNBTUtil.prepareBlacklist();
        for (Pattern p : blacklistPattern) {
            if (!p.matcher(id).matches()) continue;
            blacklistCache.add(item);
            return true;
        }
        checkedItemsCache.add(item);
        return false;
    }

    public static boolean isSplitItemStack(class_1799 stack) {
        ItemNBTUtil.prepareBlacklist();
        if (ItemNBTUtil.isItemOnBlacklist(stack)) {
            return false;
        }
        class_9279 component = (class_9279)stack.method_58694(class_9334.field_49628);
        return component != null && component.method_57461().method_33133();
    }

    public static void prepareBlacklist() {
        if (!blacklistPattern.isEmpty()) {
            return;
        }
        List<? extends String> list = ConfigHelper.blacklistItems();
        if (list != null) {
            for (String string : list) {
                String regex = string.replace("*", ".*");
                blacklistPattern.add(Pattern.compile(regex));
            }
            blacklistCache.clear();
            checkedItemsCache.clear();
        }
    }

    public static void fixBug(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        if (ItemNBTUtil.isItemOnBlacklist(stack)) {
            return;
        }
        if (ItemNBTUtil.isSplitItemStack(stack)) {
            stack.method_57381(class_9334.field_49628);
        }
    }
}

