/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_9848;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.resource.ResourceConstants;
import nx.pingwheel.common.resource.ResourceReloadListener;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class DrawContext {
    private static final int SHADOW_BLACK = class_9848.method_61324((int)64, (int)0, (int)0, (int)0);
    private class_332 guiGraphics;
    private Matrix3x2fStack matrices;

    public DrawContext(class_332 guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.matrices = guiGraphics.method_51448();
    }

    public void renderLabel(class_2561 text, float yOffset, class_640 player, int color) {
        int extraWidth = player != null ? 10 : 0;
        float f = CommonClient.Game.field_1772.method_27525((class_5348)text) + extraWidth;
        Objects.requireNonNull(CommonClient.Game.field_1772);
        class_241 textMetrics = new class_241(f, 9.0f);
        class_241 textOffset = textMetrics.method_35582(-0.5f).method_35586(new class_241(0.0f, textMetrics.field_1342 * yOffset));
        this.matrices.pushMatrix();
        this.matrices.translate(textOffset.field_1343, textOffset.field_1342);
        this.guiGraphics.method_25294(-2, -2, (int)textMetrics.field_1343 + 1, (int)textMetrics.field_1342, SHADOW_BLACK);
        this.guiGraphics.method_51439(CommonClient.Game.field_1772, text, extraWidth, 0, color, false);
        if (player != null) {
            this.matrices.translate(-0.5f, -0.5f);
            this.renderPlayerHead(player);
        }
        this.matrices.popMatrix();
    }

    public void renderPlayerHead(class_640 player) {
        class_2960 texture = player.method_52810().comp_1626().comp_3627();
        GlStateManager._enableBlend();
        this.guiGraphics.method_25290(class_10799.field_56883, texture, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
        this.guiGraphics.method_25290(class_10799.field_56883, texture, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
        GlStateManager._disableBlend();
    }

    public void renderPing(class_1799 itemStack, boolean drawItemIcon, int color) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderTexture(ResourceConstants.PING_TEXTURE_ID, 12, color);
        } else {
            this.renderDefaultPingIcon(color);
        }
    }

    public void renderGuiItemModel(class_1799 itemStack) {
        this.guiGraphics.method_51428(itemStack, -8, -8, -150);
    }

    public void renderDefaultPingIcon(int color) {
        this.matrices.pushMatrix();
        MathUtils.rotateZ((Matrix3x2f)this.matrices, 0.7853982f);
        this.matrices.translate(-2.5f, -2.5f);
        this.guiGraphics.method_25294(0, 0, 5, 5, color);
        this.matrices.popMatrix();
    }

    public void renderTexture(class_2960 texture, int size, int color) {
        int offset = size / -2;
        GlStateManager._enableBlend();
        this.guiGraphics.method_25291(class_10799.field_56883, texture, offset, offset, 0.0f, 0.0f, size, size, size, size, color);
        GlStateManager._disableBlend();
    }

    public void renderArrowIcon(int color) {
        this.renderTexture(ResourceConstants.ARROW_TEXTURE_ID, 10, color);
    }

    public Matrix3x2fStack getMatrices() {
        return this.matrices;
    }
}

