/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.common;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerStatusCache;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_8702;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.network.codec.ByteBufCodecs$34"})
public class MixinJsonByteBufCodec {
    @Shadow
    @Final
    private static Gson field_60514;

    @Inject(method={"encode(Lio/netty/buffer/ByteBuf;Lcom/google/gson/JsonElement;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEncode(ByteBuf buf, JsonElement element, CallbackInfo info) {
        if (!NCRConfig.getCommon().addQueryData() || !this.isServerStatusElement(element)) {
            return;
        }
        info.cancel();
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Adding chat report prevention status to ServerStatus packet.");
        }
        JsonObject object = element.getAsJsonObject();
        object.addProperty("preventsChatReports", Boolean.valueOf(true));
        String string = field_60514.toJson((JsonElement)object);
        class_8702.method_53013((ByteBuf)buf, (CharSequence)string, (int)Short.MAX_VALUE);
    }

    @Inject(method={"decode(Lio/netty/buffer/ByteBuf;)Lcom/google/gson/JsonElement;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onDecode(ByteBuf buf, CallbackInfoReturnable<JsonElement> info) {
        boolean preventsReports;
        JsonElement element = (JsonElement)info.getReturnValue();
        if (!this.isServerStatusElement(element)) {
            return;
        }
        JsonObject object = element.getAsJsonObject();
        boolean bl = preventsReports = object.has("preventsChatReports") && object.get("preventsChatReports").getAsBoolean();
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Received chat report prevention status from ServerStatus packet: " + preventsReports);
        }
        ServerStatusCache.setPreventsReports(preventsReports);
    }

    private boolean isServerStatusElement(JsonElement element) {
        if (!element.isJsonObject()) {
            return false;
        }
        JsonObject object = element.getAsJsonObject();
        if (!object.has("version") || !object.get("version").isJsonObject()) {
            return false;
        }
        JsonObject version = object.get("version").getAsJsonObject();
        return version.has("name") && version.has("protocol");
    }
}

