/*
 * Decompiled with CFR 0.152.
 */
package com.lukasabbe.bookshelfinspector.renderer;

import com.lukasabbe.bookshelfinspector.BookshelfInspectorClient;
import com.lukasabbe.bookshelfinspector.data.BookData;
import com.lukasabbe.bookshelfinspector.data.Tags;
import com.lukasabbe.bookshelfinspector.util.ItemTools;
import com.lukasabbe.bookshelfinspector.util.RomanNumerals;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_9302;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.joml.Matrix3x2fStack;

public class HudRenderer {
    public static void hudRender(class_332 context, class_310 client) {
        class_9302 writtenBookContentComponent;
        class_1844 itemPotionContents;
        class_9304 itemEnchantments;
        if (!BookshelfInspectorClient.modAvailable) {
            return;
        }
        if (client.field_1690.field_1842) {
            return;
        }
        if (!BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled) {
            return;
        }
        BookData currentBookData = BookshelfInspectorClient.currentBookData;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = screenWidth / 2;
        int y = screenHeight / 2;
        class_1799 itemStack = currentBookData.itemStack;
        if (BookshelfInspectorClient.bookShelfData.latestBlockState.method_26164(Tags.SHELVES) && ItemTools.isNormalStack(itemStack) && !BookshelfInspectorClient.config.shelfDisplayNormal) {
            return;
        }
        int color = -1;
        Integer colorValue = itemStack.method_7932().method_58413().method_532();
        if (colorValue != null) {
            color = colorValue + -16777216;
        }
        float scaleFactor = (float)BookshelfInspectorClient.config.scale / 10.0f;
        class_5250 itemName = itemStack.method_7964().method_27661();
        HudRenderer.drawScaledText(context, (class_2561)itemName, x, y + (int)(10.0f * scaleFactor), color, client.field_1772);
        if (itemStack.method_7946() && itemStack.method_7947() > 1) {
            float rightEdge = (float)x + (float)client.field_1772.method_27525((class_5348)itemName) / 2.0f * scaleFactor;
            float spacing = 9.0f * scaleFactor;
            int nextX = (int)(rightEdge + spacing);
            class_5250 count = class_2561.method_43473();
            count.method_27693(" (" + itemStack.method_7947() + ")");
            class_2564.method_10889((class_5250)count, (class_2583)class_2583.field_24360.method_10977(class_124.field_1080));
            HudRenderer.drawScaledText(context, (class_2561)count, nextX, y + (int)(10.0f * scaleFactor), color, client.field_1772);
        }
        if ((itemEnchantments = ItemTools.getItemEnchantments(itemStack)) != null) {
            int i = (int)(20.0f * scaleFactor);
            for (class_6880 enchantment : itemEnchantments.method_57534()) {
                String lvl = "";
                int level = itemEnchantments.method_57536(enchantment);
                if (level != 1) {
                    lvl = String.valueOf(level);
                }
                class_5250 enchantmentText = !BookshelfInspectorClient.config.useRoman || level == -1 ? ((class_1887)enchantment.comp_349()).comp_2686().method_27661().method_27693(" " + lvl) : (level != 1 ? ((class_1887)enchantment.comp_349()).comp_2686().method_27661().method_27693(" " + RomanNumerals.toRoman(level)) : ((class_1887)enchantment.comp_349()).comp_2686().method_27661());
                if (enchantment.method_40220(class_9636.field_51551)) {
                    class_2564.method_10889((class_5250)enchantmentText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
                } else {
                    class_2564.method_10889((class_5250)enchantmentText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1080));
                }
                HudRenderer.drawScaledText(context, (class_2561)enchantmentText, x, y + i, -1, client.field_1772);
                i += (int)(10.0f * scaleFactor);
            }
        }
        if ((itemPotionContents = ItemTools.getPotionContents(itemStack)) != null) {
            int i = (int)(20.0f * scaleFactor);
            for (class_1293 effect : itemPotionContents.method_57397()) {
                int amplifier = effect.method_5578();
                class_5250 potionText = ((class_1291)effect.method_5579().comp_349()).method_5560().method_27661();
                if (amplifier > 0) {
                    String amplifierNumeral = BookshelfInspectorClient.config.useRoman ? RomanNumerals.toRoman(amplifier) : String.valueOf(amplifier);
                    potionText.method_27693(" " + amplifierNumeral);
                }
                potionText.method_27693(" (" + class_1292.method_5577((class_1293)effect, (float)1.0f, (float)client.field_1687.method_54719().method_54748()).getString() + ")");
                if (!((class_1291)effect.method_5579().comp_349()).method_5573()) {
                    class_2564.method_10889((class_5250)potionText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
                } else {
                    class_2564.method_10889((class_5250)potionText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1080));
                }
                HudRenderer.drawScaledText(context, (class_2561)potionText, x, y + i, -1, client.field_1772);
                i += (int)(10.0f * scaleFactor);
            }
        }
        if ((writtenBookContentComponent = (class_9302)itemStack.method_57353().method_58694(class_9334.field_49606)) != null) {
            HudRenderer.drawScaledText(context, (class_2561)class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{writtenBookContentComponent.comp_2420()}), x, y + (int)(20.0f * scaleFactor), -1, client.field_1772);
        }
    }

    private static void drawScaledText(class_332 context, class_2561 text, int centerX, int y, int color, class_327 textRenderer) {
        Matrix3x2fStack stack = context.method_51448();
        stack.pushMatrix();
        stack.translate((float)centerX, (float)y);
        float scale = (float)BookshelfInspectorClient.config.scale / 10.0f;
        stack.scale(scale, scale);
        stack.translate((float)(-centerX), (float)(-y));
        context.method_27534(textRenderer, text, centerX, y, color);
        stack.popMatrix();
    }
}

