/*
 * Decompiled with CFR 0.152.
 */
package com.lukasabbe.bookshelfinspector.config;

import com.lukasabbe.bookshelfinspector.platform.Services;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class Config {
    public boolean lecternToggle = true;
    public boolean shelfToggle = true;
    public boolean shelfDisplayNormal = true;
    public int scale = 10;
    public boolean useRoman = false;

    public void loadConfig() {
        Path configPath = Services.PLATFORM.getConfigPath("bookshelfinspector-config.yml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.createConfig(configPath);
        }
        Yaml yaml = new Yaml();
        try {
            Map configMap = (Map)yaml.load((Reader)new FileReader(configPath.toFile()));
            if (configMap.containsKey("lectern-toggle")) {
                this.lecternToggle = (Boolean)configMap.get("lectern-toggle");
            }
            if (configMap.containsKey("shelf-toggle")) {
                this.shelfToggle = (Boolean)configMap.get("shelf-toggle");
            }
            if (configMap.containsKey("shelf-display-normal")) {
                this.shelfDisplayNormal = (Boolean)configMap.get("shelf-display-normal");
            }
            if (configMap.containsKey("scale")) {
                this.scale = (Integer)configMap.get("scale");
            }
            if (configMap.containsKey("roman")) {
                this.useRoman = (Boolean)configMap.get("roman");
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void createConfig(Path configPath) {
        Path defaultConfigPath = Services.PLATFORM.getFileOrCopyInModContainer("bookshelfinspector", "bookshelfinspector-config.yml");
        if (defaultConfigPath == null) {
            return;
        }
        try {
            Files.copy(defaultConfigPath, configPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveConfig() {
        Path configPath = Services.PLATFORM.getConfigPath("bookshelfinspector-config.yml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.createConfig(configPath);
        }
        Yaml yaml = new Yaml();
        try {
            Map configMap = (Map)yaml.load((Reader)new FileReader(configPath.toFile()));
            configMap.put("lectern-toggle", this.lecternToggle);
            configMap.put("shelf-toggle", this.shelfToggle);
            configMap.put("shelf-display-normal", this.shelfDisplayNormal);
            configMap.put("scale", this.scale);
            configMap.put("roman", this.useRoman);
            FileWriter writer = new FileWriter(configPath.toString());
            yaml.dump((Object)configMap, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

