/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFException;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.EBEConfigModifier;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.EMFPartialArmor;
import traben.entity_model_features.models.IEMFModelNameContainer;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.state.EMFEntityRenderState;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_model_features.utils.EMFDirectoryHandler;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.utils.EntityIntLRU;

public class EMFManager {
    private static final Map<class_2591<?>, String> EBETypes = Map.of(class_2591.field_11910, "bed", class_2591.field_11914, "chest", class_2591.field_11891, "chest", class_2591.field_11901, "chest", class_2591.field_11896, "shulker_box", class_2591.field_16413, "bell", class_2591.field_11911, "sign", class_2591.field_42781, "decorated_pot");
    public static EMFModelPartRoot lastCreatedRootModelPart = null;
    private static EMFManager self = null;
    public final boolean IS_PHYSICS_MOD_INSTALLED;
    public final boolean IS_EBE_INSTALLED;
    public final EntityIntLRU lastModelRuleOfEntity;
    public final EntityIntLRU lastModelSuffixOfEntity;
    public final Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>> rootPartsPerEntityTypeForDebug = new Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    public final ObjectSet<EMFModel_ID> modelsAnnounced = new ObjectOpenHashSet();
    public final Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>> rootPartsPerEntityTypeForVariation = new Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    public final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<EMFModel_ID, class_5601> cache_LayersByModelName = new Object2ObjectOpenHashMap();
    public final Set<String> EBE_JEMS_FOUND_LAST = new HashSet<String>();
    private final Object2IntOpenHashMap<class_5601> amountOfLayerAttempts = new Object2IntOpenHashMap<class_5601>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private final Set<String> EBE_JEMS_FOUND = new HashSet<String>();
    private final ArrayList<String> KNOWN_RESOURCEPACK_ORDER;
    public UUID entityForDebugPrint = null;
    public long entityRenderCount = 0L;
    public boolean isAnimationValidationPhase = false;
    public String currentSpecifiedModelLoading = "";
    public class_2591<?> currentBlockEntityTypeLoading = null;
    private boolean traderLlamaHappened = false;
    public EMFEntityRenderState awaitingState = null;
    @Nullable
    private String lastUndeadHorse = null;
    public final List<Exception> loadingExceptions = new ArrayList<Exception>();
    private EMFPartialArmor armorParts = null;

    public void receiveException(Exception exception) {
        if (exception == null || exception.getMessage() == null || exception.getMessage().trim().equals("null")) {
            return;
        }
        this.loadingExceptions.add(exception);
    }

    private EMFManager() {
        EMFAnimationEntityContext.globalReset();
        this.IS_PHYSICS_MOD_INSTALLED = ETF.isThisModLoaded((String)"physicsmod");
        this.IS_EBE_INSTALLED = ETF.isThisModLoaded((String)"enhancedblockentities");
        this.lastModelRuleOfEntity = new EntityIntLRU();
        this.lastModelRuleOfEntity.defaultReturnValue(0);
        this.lastModelSuffixOfEntity = new EntityIntLRU();
        this.lastModelSuffixOfEntity.defaultReturnValue(0);
        this.KNOWN_RESOURCEPACK_ORDER = new ArrayList();
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.log("Clearing data for reload.", false);
        EMFModelMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    @Nullable
    public static EMFJemData getJemDataWithDirectory(EMFDirectoryHandler jemDirectory, EMFModel_ID mobModelIDInfo) {
        String pathOfJem = jemDirectory.getFinalFileLocation();
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        boolean print = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
        try {
            Optional res = class_310.method_1551().method_1478().method_14486(EMFUtils.res(pathOfJem));
            if (res.isEmpty()) {
                if (print) {
                    EMFUtils.log(pathOfJem + ", .jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (print) {
                EMFUtils.log(pathOfJem + ", .jem read success " + pathOfJem + " exists", false);
            }
            class_3298 jemResource = (class_3298)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.method_14482()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.prepare(jemDirectory, mobModelIDInfo);
            if (mobModelIDInfo.areBothSame()) {
                EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            }
            return jem;
        }
        catch (FileNotFoundException | class_151 e) {
            if (print) {
                EMFUtils.log(pathOfJem + ", .jem failed to load: " + String.valueOf(e), false);
            }
        }
        catch (Exception e) {
            EMFUtils.log(pathOfJem + ", .jem failed to load: " + String.valueOf(e), false);
            e.printStackTrace();
            EMFException.recordException(e);
        }
        return null;
    }

    public static EMFModelPart getModelFromHierarchicalId(String hierarchId, Map<String, EMFModelPart> map) {
        if (hierarchId == null || hierarchId.isBlank()) {
            return null;
        }
        EMFModelPart part = map.get(hierarchId);
        if (part == null) {
            part = map.get("EMF_" + hierarchId);
        }
        if (part != null) {
            return part;
        }
        for (Map.Entry<String, EMFModelPart> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.endsWith(":" + hierarchId) || key.endsWith(":EMF_" + hierarchId)) {
                return entry.getValue();
            }
            String[] parts = hierarchId.split(":");
            boolean allPartsMatch = Arrays.stream(parts).allMatch(partStr -> key.contains((CharSequence)partStr) || key.contains("EMF_" + partStr));
            String last = parts[parts.length - 1];
            if (!allPartsMatch || !key.equals(last) && !key.endsWith(":" + last) && !key.endsWith(":EMF_" + last)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void handleBoats(String originalLayerName, EMFModel_ID mobNameForFileAndMap) throws EMFException {
        String jem;
        if (originalLayerName.startsWith("chest_boat/")) {
            jem = originalLayerName.startsWith("chest_boat/bamboo") ? "chest_raft" : "chest_boat";
        } else if (originalLayerName.startsWith("boat/")) {
            jem = originalLayerName.startsWith("boat/bamboo") ? "raft" : "boat";
        } else {
            return;
        }
        mobNameForFileAndMap.setMapIdAndAddFallbackModel(jem);
        String type = mobNameForFileAndMap.getfileName().split("/")[1];
        mobNameForFileAndMap.setFileName(type + "_" + jem);
    }

    public boolean wasEBEModified() {
        return !this.EBE_JEMS_FOUND_LAST.isEmpty();
    }

    public ArrayList<String> getResourcePackList() {
        if (this.KNOWN_RESOURCEPACK_ORDER.isEmpty()) {
            List list = class_310.method_1551().method_1478().method_29213().toList();
            for (class_3262 pack : list) {
                this.KNOWN_RESOURCEPACK_ORDER.add(pack.method_14409());
            }
        }
        return this.KNOWN_RESOURCEPACK_ORDER;
    }

    public void modifyEBEIfRequired() {
        block3: {
            if (this.IS_EBE_INSTALLED && !this.EBE_JEMS_FOUND.isEmpty() && ((EMFConfig)EMF.config().getConfig()).allowEBEModConfigModify) {
                try {
                    EBEConfigModifier.modifyEBEConfig(this.EBE_JEMS_FOUND);
                }
                catch (Error | Exception e) {
                    EMFUtils.logWarn("EBE config modification issue: " + String.valueOf(e));
                    if (!(e instanceof Exception)) break block3;
                    Exception f = (Exception)e;
                    EMFException.recordException(f);
                }
            }
        }
        this.EBE_JEMS_FOUND_LAST.clear();
        this.EBE_JEMS_FOUND_LAST.addAll(this.EBE_JEMS_FOUND);
        this.EBE_JEMS_FOUND.clear();
    }

    public class_630 injectIntoModelRootGetter(class_5601 layer, class_630 root) {
        int creationsOfLayer = this.amountOfLayerAttempts.put((Object)layer, this.amountOfLayerAttempts.getInt((Object)layer) + 1);
        if (creationsOfLayer > 64) {
            if (creationsOfLayer == 65) {
                EMFUtils.logError("model attempted creation more than 64 times {" + layer.toString() + "]. EMF is now ignoring this model. Please inform the mod maker that this is not how entity models are meant to be utilised. They should ALWAYS be stored and reused.");
            }
            return root;
        }
        Object originalLayerName = layer.comp_2995().method_12832();
        String originalLayerBase = ((String)originalLayerName).replaceFirst("_baby$", "");
        EMFModel_ID mobNameForFileAndMap = new EMFModel_ID((String)(this.currentSpecifiedModelLoading.isBlank() || this.currentSpecifiedModelLoading.startsWith("emf$") ? originalLayerName : this.currentSpecifiedModelLoading));
        try {
            boolean hasVariants;
            boolean modded;
            lastCreatedRootModelPart = null;
            boolean printing = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
            if (!"main".equals(layer.comp_2996())) {
                mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName() + "_" + layer.comp_2996());
                originalLayerName = (String)originalLayerName + "_" + layer.comp_2996();
            }
            boolean isBaby = false;
            boolean wasArmor = false;
            if (!"minecraft".equals(layer.comp_2995().method_12836())) {
                modded = true;
                mobNameForFileAndMap.setBoth(((String)originalLayerName).toLowerCase().replaceAll("[^a-z0-9/._-]", "_"));
                mobNameForFileAndMap.namespace = layer.comp_2995().method_12836();
            } else {
                modded = false;
                boolean skipSwitch = false;
                if (!(!mobNameForFileAndMap.getfileName().matches(".*_baby($|_\\w*)") || mobNameForFileAndMap.getfileName().startsWith("horse_baby") || mobNameForFileAndMap.getfileName().startsWith("skeleton_horse_baby") || mobNameForFileAndMap.getfileName().startsWith("zombie_horse_baby") || mobNameForFileAndMap.getfileName().startsWith("mule_baby") || mobNameForFileAndMap.getfileName().startsWith("donkey_baby"))) {
                    String adultName = mobNameForFileAndMap.getfileName().replaceFirst("_baby", "");
                    mobNameForFileAndMap.addFallbackModel(adultName);
                    isBaby = true;
                }
                if (mobNameForFileAndMap.getfileName().matches(".*_collar($|_\\w*)")) {
                    String baseName = mobNameForFileAndMap.getfileName().replaceFirst("_collar", "");
                    mobNameForFileAndMap.addFallbackModel(baseName);
                    if (isBaby) {
                        mobNameForFileAndMap.addFallbackModel(baseName.replaceFirst("_baby", ""));
                    }
                }
                if (((String)originalLayerName).endsWith("_helmet")) {
                    mobNameForFileAndMap.setMapIdAndAddFallbackModel("helmet");
                    skipSwitch = true;
                    wasArmor = true;
                } else if (((String)originalLayerName).endsWith("_chestplate")) {
                    mobNameForFileAndMap.setMapIdAndAddFallbackModel("chestplate");
                    skipSwitch = true;
                    wasArmor = true;
                } else if (((String)originalLayerName).endsWith("_leggings")) {
                    mobNameForFileAndMap.setMapIdAndAddFallbackModel("leggings");
                    skipSwitch = true;
                    wasArmor = true;
                } else if (((String)originalLayerName).endsWith("_boots")) {
                    mobNameForFileAndMap.setMapIdAndAddFallbackModel("boots");
                    skipSwitch = true;
                    wasArmor = true;
                }
                String filename = mobNameForFileAndMap.getfileName();
                if (filename.startsWith("zombie_horse") || filename.startsWith("skeleton_horse")) {
                    this.lastUndeadHorse = filename;
                }
                if (!skipSwitch) {
                    block68 : switch (originalLayerName) {
                        case "parrot_shoulder": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("parrot");
                            break;
                        }
                        case "villager_no_hat": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("villager");
                            break;
                        }
                        case "villager_no_hat_baby": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("villager_baby").addFallbackModel("villager");
                            break;
                        }
                        case "zombie_villager_no_hat": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("zombie_villager");
                            break;
                        }
                        case "zombie_villager_no_hat_baby": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("zombie_villager_baby").addFallbackModel("zombie_villager");
                            break;
                        }
                        case "cow": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_cow");
                            break;
                        }
                        case "chicken": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_chicken");
                            break;
                        }
                        case "pig": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_pig");
                            break;
                        }
                        case "cow_baby": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_cow_baby");
                            break;
                        }
                        case "chicken_baby": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_chicken_baby");
                            break;
                        }
                        case "pig_baby": {
                            mobNameForFileAndMap.pushNewMainModelAddingOldAsFallback("temperate_pig_baby");
                            break;
                        }
                        case "evoker": {
                            mobNameForFileAndMap.addFallbackModel("evocation_illager");
                            break;
                        }
                        case "evoker_fangs": {
                            mobNameForFileAndMap.addFallbackModel("evocation_fangs");
                            break;
                        }
                        case "vindicator": {
                            mobNameForFileAndMap.addFallbackModel("vindication_illager");
                            break;
                        }
                        case "bed_foot": {
                            mobNameForFileAndMap.setBoth("bed_foot").addFallbackModel("bed");
                            break;
                        }
                        case "bed_head": {
                            mobNameForFileAndMap.setBoth("bed_head").addFallbackModel("bed");
                            break;
                        }
                        case "book": {
                            if (this.currentSpecifiedModelLoading.equals("enchanting_book")) {
                                mobNameForFileAndMap.setBoth("enchanting_book", "book").addFallbackModel("book");
                                break;
                            }
                            mobNameForFileAndMap.setBoth("lectern_book", "book").addFallbackModel("book");
                            break;
                        }
                        case "salmon_small": 
                        case "salmon_large": {
                            mobNameForFileAndMap.addFallbackModel("salmon");
                            break;
                        }
                        case "breeze_wind_charge": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("wind_charge");
                            break;
                        }
                        case "creaking_transient": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("creaking");
                            break;
                        }
                        case "chest": {
                            mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading != null && !this.currentSpecifiedModelLoading.isBlank() ? this.currentSpecifiedModelLoading : "chest", "chest");
                            break;
                        }
                        case "conduit_cage": {
                            mobNameForFileAndMap.setBoth("conduit_cage").addFallbackModel("conduit");
                            break;
                        }
                        case "conduit_eye": {
                            mobNameForFileAndMap.setBoth("conduit_eye").addFallbackModel("conduit");
                            break;
                        }
                        case "conduit_shell": {
                            mobNameForFileAndMap.setBoth("conduit_shell").addFallbackModel("conduit");
                            break;
                        }
                        case "conduit_wind": {
                            mobNameForFileAndMap.setBoth("conduit_wind").addFallbackModel("conduit");
                            break;
                        }
                        case "creeper_armor": {
                            mobNameForFileAndMap.setBoth("creeper_charge");
                            break;
                        }
                        case "creeper_head": {
                            mobNameForFileAndMap.setBoth("head_creeper");
                            break;
                        }
                        case "decorated_pot_base": {
                            mobNameForFileAndMap.setBoth("decorated_pot_base").addFallbackModel("decorated_pot");
                            break;
                        }
                        case "decorated_pot_sides": {
                            mobNameForFileAndMap.setBoth("decorated_pot_sides").addFallbackModel("decorated_pot");
                            break;
                        }
                        case "double_chest_left": {
                            this.getDoubleChest(root, mobNameForFileAndMap, false, printing);
                            break;
                        }
                        case "double_chest_right": {
                            this.getDoubleChest(root, mobNameForFileAndMap, true, printing);
                            break;
                        }
                        case "dragon_skull": {
                            mobNameForFileAndMap.setBoth("head_dragon");
                            break;
                        }
                        case "ender_dragon": {
                            mobNameForFileAndMap.setBoth("dragon");
                            break;
                        }
                        case "leash_knot": {
                            mobNameForFileAndMap.setBoth("lead_knot");
                            break;
                        }
                        case "llama": 
                        case "llama_baby": {
                            this.traderLlamaHappened = false;
                            break;
                        }
                        case "llama_decor": {
                            mobNameForFileAndMap.setBoth(this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor");
                            break;
                        }
                        case "llama_baby_decor": {
                            mobNameForFileAndMap.setBoth(this.traderLlamaHappened ? "trader_llama_baby_decor" : "llama_baby_decor");
                            break;
                        }
                        case "chest_minecart": 
                        case "command_block_minecart": 
                        case "spawner_minecart": 
                        case "tnt_minecart": 
                        case "furnace_minecart": 
                        case "hopper_minecart": {
                            mobNameForFileAndMap.setMapIdAndAddFallbackModel("minecart");
                            break;
                        }
                        case "piglin_head": {
                            mobNameForFileAndMap.setBoth("head_piglin");
                            break;
                        }
                        case "player_head": {
                            mobNameForFileAndMap.setBoth("head_player");
                            break;
                        }
                        case "player_slim": {
                            mobNameForFileAndMap.addFallbackModel("player");
                            break;
                        }
                        case "arrow": {
                            if (!this.currentSpecifiedModelLoading.equals("spectral_arrow")) break;
                            mobNameForFileAndMap.setBoth("spectral_arrow");
                            mobNameForFileAndMap.addFallbackModel("arrow");
                            break;
                        }
                        case "boat_water_patch": {
                            if (this.currentSpecifiedModelLoading.startsWith("emf$boat$")) {
                                String type = this.currentSpecifiedModelLoading.substring(9);
                                mobNameForFileAndMap.setBoth(type + "_boat_patch", "boat_patch").addFallbackModel("boat_patch");
                                this.currentSpecifiedModelLoading = "";
                                break;
                            }
                            mobNameForFileAndMap.setBoth("boat_patch");
                            break;
                        }
                        case "pufferfish_big": {
                            mobNameForFileAndMap.setBoth("puffer_fish_big");
                            break;
                        }
                        case "pufferfish_medium": {
                            mobNameForFileAndMap.setBoth("puffer_fish_medium");
                            break;
                        }
                        case "pufferfish_small": {
                            mobNameForFileAndMap.setBoth("puffer_fish_small");
                            break;
                        }
                        case "shulker": {
                            if (!this.currentSpecifiedModelLoading.equals("shulker_box")) break;
                            mobNameForFileAndMap.setBoth("shulker_box");
                            break;
                        }
                        case "skeleton_skull": {
                            mobNameForFileAndMap.setBoth("head_skeleton");
                            break;
                        }
                        case "sheep_fur": {
                            mobNameForFileAndMap.setBoth("sheep_wool");
                            break;
                        }
                        case "trader_llama": 
                        case "trader_llama_baby": {
                            this.traderLlamaHappened = true;
                            break;
                        }
                        case "tropical_fish_large": {
                            mobNameForFileAndMap.setBoth("tropical_fish_b");
                            break;
                        }
                        case "tropical_fish_large_pattern": {
                            mobNameForFileAndMap.setBoth("tropical_fish_pattern_b");
                            break;
                        }
                        case "tropical_fish_small": {
                            mobNameForFileAndMap.setBoth("tropical_fish_a");
                            break;
                        }
                        case "tropical_fish_small_pattern": {
                            mobNameForFileAndMap.setBoth("tropical_fish_pattern_a");
                            break;
                        }
                        case "wither_skeleton_skull": {
                            mobNameForFileAndMap.setBoth("head_wither_skeleton");
                            break;
                        }
                        case "zombie_head": {
                            mobNameForFileAndMap.setBoth("head_zombie");
                            break;
                        }
                        case "undead_horse_armor": {
                            if (this.lastUndeadHorse == null) break;
                            mobNameForFileAndMap.pushNewMainModelAndMapIdAddingOldAsFallback(this.lastUndeadHorse + "_armor");
                            break;
                        }
                        default: {
                            if (!this.currentSpecifiedModelLoading.isBlank()) {
                                switch (this.currentSpecifiedModelLoading) {
                                    case "sign": 
                                    case "hanging_sign": {
                                        Object sign = ((String)originalLayerName).replace("sign/standing/", "").replace("sign/wall/", "").replace("hanging_sign/", "");
                                        if (((String)originalLayerName).startsWith("sign/standing/")) {
                                            sign = (String)sign + "_sign";
                                            mobNameForFileAndMap.setFileName((String)sign).setMapIdAndAddFallbackModel("sign");
                                            break block68;
                                        }
                                        if (((String)originalLayerName).startsWith("sign/wall/")) {
                                            sign = (String)sign + "_wall_sign";
                                            mobNameForFileAndMap.setFileName((String)sign).setMapIdAndAddFallbackModel("wall_sign").setMapIdAndAddFallbackModel("sign");
                                            break block68;
                                        }
                                        sign = (String)sign + "_hanging_sign";
                                        mobNameForFileAndMap.setFileName((String)sign).setMapIdAndAddFallbackModel("hanging_sign");
                                        break block68;
                                    }
                                }
                                if (((EMFConfig)EMF.config().getConfig()).modelExportMode != EMFConfig.ModelPrintMode.NONE) {
                                    EMFUtils.log("EMF unknown modifiable block entity model identified during loading: " + this.currentSpecifiedModelLoading + ".jem");
                                }
                                mobNameForFileAndMap.setFileName(this.currentSpecifiedModelLoading).setMapIdAndAddFallbackModel(this.currentSpecifiedModelLoading, (String)originalLayerName);
                                break;
                            }
                            if (!((String)originalLayerName).contains("/") || !layer.comp_2996().equals("main")) break;
                            EMFManager.handleBoats((String)originalLayerName, mobNameForFileAndMap);
                        }
                    }
                }
            }
            if (((EMFConfig)EMF.config().getConfig()).modelExportMode != EMFConfig.ModelPrintMode.NONE && !this.currentSpecifiedModelLoading.isBlank() && this.currentSpecifiedModelLoading.contains(":")) {
                EMFUtils.log("EMF modifiable modded block entity model identified during loading: " + mobNameForFileAndMap.getfileName() + ".jem");
            }
            if (!class_2960.method_20208((String)(mobNameForFileAndMap.getfileName() + ".jem"))) {
                String newValidPath = mobNameForFileAndMap.getfileName().replaceAll("[^a-z0-9/_.-]", "_");
                mobNameForFileAndMap.setBoth(newValidPath, mobNameForFileAndMap.getMapId());
            }
            mobNameForFileAndMap.finishAndPrepAutomatedFallbacks();
            if (mobNameForFileAndMap.getfileName().isBlank()) {
                if (mobNameForFileAndMap.hasFallbackModels()) {
                    mobNameForFileAndMap = mobNameForFileAndMap.getNextFallbackModel();
                } else if (!((String)originalLayerName).isBlank()) {
                    mobNameForFileAndMap.setFileName((String)originalLayerName);
                } else {
                    throw new EMFException("Model name is blank, for input layer: " + String.valueOf(layer));
                }
            }
            this.cache_LayersByModelName.put((Object)mobNameForFileAndMap, (Object)layer);
            mobNameForFileAndMap.forEachFallback(fallBack -> this.cache_LayersByModelName.put(fallBack, (Object)layer));
            if (printing) {
                EMFUtils.log(" > checking if: [" + String.valueOf(mobNameForFileAndMap) + "], is allowed as a model name.");
            }
            if (((EMFConfig)EMF.config().getConfig()).isModelDisabled(mobNameForFileAndMap.getMapId())) {
                if (printing) {
                    EMFUtils.logWarn(" > Vanilla model used for: [" + String.valueOf(mobNameForFileAndMap) + "], because it is disabled in EMF's settings or via the API.");
                }
                ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
                return root;
            }
            Map<String, String> optifinePartNameMap = EMFModelMappings.getMapOf(mobNameForFileAndMap, root);
            if (printing) {
                EMFUtils.log(" >> EMF trying to find model: " + mobNameForFileAndMap.getNamespace() + ":optifine/cem/" + String.valueOf(mobNameForFileAndMap) + ".jem");
            }
            MutableTriple<EMFJemData, ImmutablePair<EMFDirectoryHandler, EMFDirectoryHandler>, EMFModel_ID> modelDataAndContext = this.getJemAndContext(printing, mobNameForFileAndMap, originalLayerBase);
            mobNameForFileAndMap.forEachFallback(fallbackModelId -> {
                boolean isFirstModelInValid;
                if (printing) {
                    EMFUtils.log(" >> EMF trying to find fallback model: " + fallbackModelId.getNamespace() + ":optifine/cem/" + String.valueOf(fallbackModelId) + ".jem");
                }
                MutableTriple<EMFJemData, ImmutablePair<EMFDirectoryHandler, EMFDirectoryHandler>, EMFModel_ID> fallbackModelDataAndContext = this.getJemAndContext(printing, (EMFModel_ID)fallbackModelId, originalLayerBase);
                EMFJemData currentBestOrFirstModel = (EMFJemData)modelDataAndContext.getLeft();
                EMFJemData fallBackModel = (EMFJemData)fallbackModelDataAndContext.getLeft();
                boolean bl = isFirstModelInValid = currentBestOrFirstModel == null && ((ImmutablePair)modelDataAndContext.getMiddle()).getRight() == null;
                if (isFirstModelInValid || currentBestOrFirstModel != null && fallBackModel != null && fallBackModel.directoryContext.packIndex() > currentBestOrFirstModel.directoryContext.packIndex()) {
                    modelDataAndContext.setLeft((Object)fallBackModel);
                    modelDataAndContext.setMiddle((Object)((ImmutablePair)fallbackModelDataAndContext.getMiddle()));
                    modelDataAndContext.setRight(fallbackModelId);
                }
            });
            EMFJemData jemData = (EMFJemData)modelDataAndContext.getLeft();
            ImmutablePair directoryContextBaseAndVariant = (ImmutablePair)modelDataAndContext.getMiddle();
            EMFModel_ID finalMapData = (EMFModel_ID)modelDataAndContext.getRight();
            boolean bl = hasVariants = directoryContextBaseAndVariant.getRight() != null;
            if (jemData != null || hasVariants) {
                if (jemData == null && ((EMFConfig)EMF.config().getConfig()).enforceOptifineVariationRequiresDefaultModel_v2) {
                    EMFUtils.logWarn("The model [" + finalMapData.getfileName() + "] has variation but does not have a default 'base' model, this is not allowed in the OptiFine format.\nYou may disable this requirement in EMF in the 'model > options' settings. Though it is usually best to preserve OptiFine compatibility.\nYou can get a default model by exporting it in the EMF settings via 'models > allmodels > *model* > export'");
                } else {
                    HashSet<String> optifinePartNames = new HashSet<String>();
                    optifinePartNameMap.forEach((optifine, vanilla) -> {
                        if (!optifine.equals("EMPTY")) {
                            optifinePartNames.add((String)vanilla);
                        }
                    });
                    EMFModelPartRoot emfRoot = new EMFModelPartRoot(finalMapData, Objects.requireNonNullElseGet((EMFDirectoryHandler)directoryContextBaseAndVariant.getLeft(), () -> ((ImmutablePair)directoryContextBaseAndVariant).getRight()), root, optifinePartNames, new HashMap<String, EMFModelPartVanilla>());
                    if (jemData != null) {
                        emfRoot.addVariantOfJem(jemData, 1);
                        emfRoot.setVariantStateTo(1);
                        this.setupAnimationsFromJemToModel(jemData, emfRoot, 1);
                        emfRoot.containsCustomModel = true;
                        if (hasVariants) {
                            emfRoot.discoverAndInitVariants(originalLayerBase);
                        } else if (!modded && jemData.directoryContext.isSubFolder && ((EMFConfig)EMF.config().getConfig()).enforceOptifineSubFoldersVariantOnly) {
                            EMFUtils.logError("Error loading [" + jemData.directoryContext.getFinalFileLocation() + "] as it is in a subfolder but does not have any variants. This is not allowed in the OptiFine format. You may disable this requirement in EMF's settings at 'model > OptiFine settings'. Though it is usually best to preserve OptiFine compatibility.");
                            throw new Exception("Subfolder without variants, OptiFine compat enabled");
                        }
                    } else {
                        emfRoot.setVariant1ToVanilla0();
                        emfRoot.discoverAndInitVariants(originalLayerBase);
                    }
                    emfRoot.setVariantStateTo(1);
                    if (emfRoot.containsCustomModel) {
                        lastCreatedRootModelPart = emfRoot;
                        if (this.IS_EBE_INSTALLED && this.currentBlockEntityTypeLoading != null && EBETypes.containsKey(this.currentBlockEntityTypeLoading)) {
                            this.EBE_JEMS_FOUND.add(EBETypes.get(this.currentBlockEntityTypeLoading));
                        }
                        if (wasArmor && !emfRoot.containsCustomAnims && ((EMFConfig)EMF.config().getConfig()).armorCopiesAnimationsHack) {
                            EMFJemData possibleBase;
                            String baseName = mobNameForFileAndMap.getfileName().replaceFirst("(_helmet|_chestplate|_leggings|_boots)", "");
                            if (printing) {
                                EMFUtils.logWarn("attempting to find base model for: " + mobNameForFileAndMap.getfileName() + ", trying: " + baseName);
                            }
                            if ((possibleBase = (EMFJemData)this.cache_JemDataByFileName.get((Object)baseName)) == null) {
                                possibleBase = (EMFJemData)this.getJemAndContext(printing, new EMFModel_ID(baseName), originalLayerBase).getLeft();
                            }
                            if (possibleBase != null && !possibleBase.getAllTopLevelAnimationsByVanillaPartName().isEmpty()) {
                                for (Integer i : emfRoot.allKnownStateVariants.keySet()) {
                                    this.setupAnimationsFromJemToModel(possibleBase, emfRoot, i);
                                }
                                if (printing) {
                                    EMFUtils.logWarn(" > injected armor model animation copy 1.21.9+ hack into: " + String.valueOf(mobNameForFileAndMap));
                                }
                            }
                        }
                        if (printing) {
                            EMFUtils.logWarn(" > EMF model used for: " + String.valueOf(mobNameForFileAndMap));
                        }
                        return emfRoot;
                    }
                }
            }
            if (wasArmor && ((EMFConfig)EMF.config().getConfig()).armorCopiesAnimationsHack) {
                EMFJemData possibleBase;
                String baseName = mobNameForFileAndMap.getfileName().replaceFirst("(_helmet|_chestplate|_leggings|_boots)", "");
                if (printing) {
                    EMFUtils.logWarn("attempting to find base model for: " + mobNameForFileAndMap.getfileName() + ", trying: " + baseName);
                }
                if ((possibleBase = (EMFJemData)this.cache_JemDataByFileName.get((Object)baseName)) == null) {
                    possibleBase = (EMFJemData)this.getJemAndContext(printing, new EMFModel_ID(baseName), originalLayerBase).getLeft();
                }
                if (possibleBase != null && !possibleBase.getAllTopLevelAnimationsByVanillaPartName().isEmpty()) {
                    EMFModelPartRoot emptyArmorEmfModel = new EMFModelPartRoot(mobNameForFileAndMap, EMFDirectoryHandler.basic(mobNameForFileAndMap.getfileName()), root, optifinePartNameMap.values(), new HashMap<String, EMFModelPartVanilla>());
                    emptyArmorEmfModel.copyVariantTo(0, 1);
                    emptyArmorEmfModel.setVariantStateTo(1);
                    this.setupAnimationsFromJemToModel(possibleBase, emptyArmorEmfModel, 1);
                    emptyArmorEmfModel.containsCustomModel = true;
                    if (printing) {
                        EMFUtils.logWarn(" > EMF armor model animation copy 1.21.9+ hack model used for: " + String.valueOf(mobNameForFileAndMap));
                    }
                    return emptyArmorEmfModel;
                }
                if (printing) {
                    EMFUtils.logWarn("no base model found for: " + baseName);
                }
            }
            if (printing) {
                EMFUtils.logWarn(" > Vanilla model used for: " + String.valueOf(mobNameForFileAndMap));
            }
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            return root;
        }
        catch (Exception e) {
            EMFUtils.logWarn("default model returned for " + String.valueOf(layer) + " due to exception: " + String.valueOf(e));
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            EMFException.recordException(e);
            return root;
        }
    }

    public void reloadEnd() {
        if (((EMFConfig)EMF.config().getConfig()).showReloadErrorToast && !this.loadingExceptions.isEmpty()) {
            try {
                class_374 toastManager = class_310.method_1551().method_1566();
                class_370.method_27024((class_374)toastManager, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"entity_model_features.config.load_warn.1"), (class_2561)class_2561.method_43471((String)"entity_model_features.config.load_warn.3"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    public EMFPartialArmor getArmorParts() {
        if (this.armorParts == null) {
            this.armorParts = new EMFPartialArmor();
        }
        return this.armorParts;
    }

    private MutableTriple<EMFJemData, ImmutablePair<EMFDirectoryHandler, EMFDirectoryHandler>, EMFModel_ID> getJemAndContext(boolean printing, EMFModel_ID mobNameForFileAndMap, String possibleBasePropertiesName) {
        EMFDirectoryHandler baseModelDir = EMFDirectoryHandler.getDirectoryManagerOrNull(printing, mobNameForFileAndMap.getNamespace(), mobNameForFileAndMap.getfileName(), ".jem");
        EMFDirectoryHandler propertiesOrSecondDir = EMFDirectoryHandler.getDirectoryManagerOrNull(printing, mobNameForFileAndMap.getNamespace(), mobNameForFileAndMap.getfileName(), ".properties");
        if (propertiesOrSecondDir == null) {
            propertiesOrSecondDir = EMFDirectoryHandler.getDirectoryManagerOrNull(printing, mobNameForFileAndMap.getNamespace(), mobNameForFileAndMap.getfileName(), "2.jem");
        }
        if (baseModelDir != null && !baseModelDir.validForThisBase(propertiesOrSecondDir)) {
            propertiesOrSecondDir = null;
        }
        EMFJemData jemDataFirst = baseModelDir == null ? null : EMFManager.getJemDataWithDirectory(baseModelDir, mobNameForFileAndMap);
        return MutableTriple.of((Object)jemDataFirst, (Object)ImmutablePair.of((Object)baseModelDir, (Object)propertiesOrSecondDir), (Object)mobNameForFileAndMap);
    }

    private void getDoubleChest(class_630 root, EMFModel_ID mobNameForFileAndMap, boolean isRight, boolean printing) throws EMFException {
        String thisSide = isRight ? "right" : "left";
        String otherSide = isRight ? "left" : "right";
        mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading + "_large", "double_chest_" + thisSide);
        if (((EMFConfig)EMF.config().getConfig()).doubleChestAnimFix) {
            if (printing) {
                EMFUtils.log("injecting empty " + otherSide + " side parts into 'double chest' for animation purposes");
            }
            HashMap<CallSite, class_630> newChildren = new HashMap<CallSite, class_630>(root.field_3661);
            newChildren.putIfAbsent((CallSite)((Object)("lid_" + otherSide)), new class_630(List.of(), Map.of()));
            newChildren.putIfAbsent((CallSite)((Object)("base_" + otherSide)), new class_630(List.of(), Map.of()));
            newChildren.putIfAbsent((CallSite)((Object)("knob_" + otherSide)), new class_630(List.of(), Map.of()));
            root.field_3661 = newChildren;
        }
        mobNameForFileAndMap.addFallbackModel(mobNameForFileAndMap.namespace, mobNameForFileAndMap.getfileName());
        mobNameForFileAndMap.setFileName(this.currentSpecifiedModelLoading + "_" + thisSide);
    }

    public void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartRoot emfRootPart, int variantNum) {
        boolean printing = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
        Object2ObjectOpenHashMap allPartsBySingleAndFullHeirachicalId = new Object2ObjectOpenHashMap();
        allPartsBySingleAndFullHeirachicalId.put((Object)"root", (Object)emfRootPart);
        allPartsBySingleAndFullHeirachicalId.putAll(emfRootPart.getAllChildPartsAsAnimationMap("", variantNum, EMFModelMappings.getMapOf(emfRootPart.modelName, null)));
        Object2ObjectLinkedOpenHashMap emfAnimations = new Object2ObjectLinkedOpenHashMap();
        if (printing) {
            EMFUtils.log(" > finalAnimationsForModel =");
            for (List<LinkedHashMap<String, String>> animList : jemData.getAllTopLevelAnimationsByVanillaPartName().values()) {
                for (LinkedHashMap<String, String> animMap : animList) {
                    for (Map.Entry<String, String> entry : animMap.entrySet()) {
                        EMFUtils.log(" >> " + entry.getKey() + " = " + entry.getValue());
                    }
                }
            }
        }
        for (List<LinkedHashMap<String, String>> animList : jemData.getAllTopLevelAnimationsByVanillaPartName().values()) {
            for (LinkedHashMap<String, String> animMap : animList) {
                for (Map.Entry<String, String> animationLine : animMap.entrySet()) {
                    String animKey = animationLine.getKey();
                    if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                        EMFUtils.log("parsing animation value: [" + animKey + "]");
                    }
                    String[] animKeyParts = animKey.split("\\.");
                    String modelId = animKeyParts[0];
                    String modelVariable = animKeyParts[1];
                    EMFModelOrRenderVariable thisVariable = EMFModelOrRenderVariable.get(modelVariable);
                    if (thisVariable == null) {
                        thisVariable = EMFModelOrRenderVariable.getRenderVariable(animKey);
                    }
                    EMFModelPart thisPart = "render".equals(modelId) ? null : EMFManager.getModelFromHierarchicalId(modelId, (Map<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                    EMFAnimation newAnimation = new EMFAnimation(thisPart, thisVariable, animKey, animationLine.getValue(), jemData.directoryContext.getFileNameWithType());
                    if (emfAnimations.containsKey((Object)animKey)) {
                        String key = animKey + "#";
                        while (emfAnimations.containsKey((Object)key)) {
                            key = key + "#";
                        }
                        emfAnimations.put((Object)key, (Object)newAnimation);
                        continue;
                    }
                    emfAnimations.put((Object)animKey, (Object)newAnimation);
                }
            }
        }
        this.isAnimationValidationPhase = true;
        ObjectIterator animMapIterate = emfAnimations.values().iterator();
        while (animMapIterate.hasNext()) {
            EMFAnimation anim = (EMFAnimation)animMapIterate.next();
            if (anim != null) {
                anim.initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)emfAnimations, (Object2ObjectOpenHashMap<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                if (anim.isValid()) continue;
                EMFUtils.logError("animation was invalid: [" + anim.animKey + "] = [" + anim.expressionString + "] in model [" + String.valueOf(emfRootPart.modelName) + "]");
                this.isAnimationValidationPhase = false;
                return;
            }
            animMapIterate.remove();
        }
        this.isAnimationValidationPhase = false;
        emfRootPart.receiveAnimations(variantNum, (Collection<EMFAnimation>)emfAnimations.values());
    }
}

