/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.sailing;

import com.cursee.monolib.Constants;
import com.cursee.monolib.MonoLib;
import com.cursee.monolib.impl.common.sailing.SailingEntry;
import com.cursee.monolib.impl.common.sailing.SailingImpl;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class SailingServerHelper {
    public static void onServerStarted(MinecraftServer server) {
        if (!MonoLib.shouldVerifyMods || SailingImpl.verified) {
            return;
        }
        SailingImpl.verified = SailingServerHelper.verifyModFiles();
    }

    private static boolean verifyModFiles() {
        List<String> MOD_NAMES_MISSING_JAR_FILE = SailingImpl.getModNamesMissingJarFile();
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty() && SailingImpl.preVerificationProcess()) {
            Constants.LOG.info("Mod(s) from incorrect sources:");
            for (String modName : MOD_NAMES_MISSING_JAR_FILE) {
                SailingEntry entry = SailingImpl.MOD_NAME_TO_ENTRY.get(modName);
                Constants.LOG.info("{} by {} {}", new Object[]{modName, entry.modPublisher(), entry.modURL()});
            }
            Constants.LOG.info("You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.");
            Constants.LOG.info("Click on the name of the mod above to find it's original posting.");
            Constants.LOG.info("You won't see this message again in this instance. Thank you for reading.");
            SailingImpl.postVerificationProcess();
        }
        return true;
    }
}

