/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib;

import com.cursee.moandjiezana.toml.Toml;
import com.cursee.monolib.Constants;
import com.cursee.monolib.api.common.sailing.SailingApi;
import com.cursee.monolib.impl.common.sailing.warden.SailingWarden;
import com.cursee.monolib.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_2960;

public class MonoLib {
    public static boolean debugModeEnabled = false;
    public static boolean shouldVerifyMods = true;

    public static void init() {
        SailingWarden.process(Services.PLATFORM.getGameDirectoryString() + File.separator + "mods");
        SailingApi.register("monolib", "MonoLib", "3.1.1", "Lupin", "https://www.curseforge.com/minecraft/mc-mods/monolib");
        MonoLib.createOrLoadConfiguration();
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)"monolib", (String)path);
    }

    private static void createOrLoadConfiguration() {
        String configFileString;
        File configFile;
        String configDirString = String.valueOf(Services.PLATFORM.getGameDirectory()) + File.separator + "config";
        File configDir = new File(configDirString);
        if (!configDir.isDirectory() && !configDir.mkdirs()) {
            Constants.LOG.info("Unable to create {}, config retaining default values.", (Object)configDirString);
        }
        if ((configFile = new File(configFileString = configDirString + File.separator + "monolib-common.toml")).exists()) {
            Toml toml = new Toml().read(configFile);
            debugModeEnabled = toml.getBoolean("debugging", debugModeEnabled);
            shouldVerifyMods = toml.getBoolean("verify_mod_files", shouldVerifyMods);
        } else {
            InputStream ioStream = MonoLib.class.getClassLoader().getResourceAsStream("assets/monolib-common.toml");
            if (ioStream == null) {
                Constants.LOG.info("Could not load internal file... config will retain default values.");
                return;
            }
            try (InputStream inputStream = ioStream;
                 BufferedInputStream bis = new BufferedInputStream(inputStream);
                 BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                Constants.LOG.info("Failed to copy default config file, error: " + e.getMessage());
                Constants.LOG.info("Configuration will retain default values.");
            }
        }
    }
}

