/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.moandjiezana.toml;

import com.cursee.moandjiezana.toml.BooleanValueReaderWriter;
import com.cursee.moandjiezana.toml.DateValueReaderWriter;
import com.cursee.moandjiezana.toml.MapValueWriter;
import com.cursee.moandjiezana.toml.NumberValueReaderWriter;
import com.cursee.moandjiezana.toml.ObjectValueWriter;
import com.cursee.moandjiezana.toml.PrimitiveArrayValueWriter;
import com.cursee.moandjiezana.toml.StringValueReaderWriter;
import com.cursee.moandjiezana.toml.TableArrayValueWriter;
import com.cursee.moandjiezana.toml.ValueWriter;

class ValueWriters {
    static final ValueWriters WRITERS = new ValueWriters();
    private static final ValueWriter[] VALUE_WRITERS = new ValueWriter[]{StringValueReaderWriter.STRING_VALUE_READER_WRITER, NumberValueReaderWriter.NUMBER_VALUE_READER_WRITER, BooleanValueReaderWriter.BOOLEAN_VALUE_READER_WRITER, ValueWriters.getPlatformSpecificDateConverter(), MapValueWriter.MAP_VALUE_WRITER, PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER, TableArrayValueWriter.TABLE_ARRAY_VALUE_WRITER};

    private ValueWriters() {
    }

    private static DateValueReaderWriter getPlatformSpecificDateConverter() {
        String specificationVersion = Runtime.class.getPackage().getSpecificationVersion();
        return specificationVersion != null && specificationVersion.startsWith("1.6") ? DateValueReaderWriter.DATE_PARSER_JDK_6 : DateValueReaderWriter.DATE_VALUE_READER_WRITER;
    }

    ValueWriter findWriterFor(Object value) {
        for (ValueWriter valueWriter : VALUE_WRITERS) {
            if (!valueWriter.canWrite(value)) continue;
            return valueWriter;
        }
        return ObjectValueWriter.OBJECT_VALUE_WRITER;
    }
}

