/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.client.tooltip.ExpandedTooltipPositioner;
import com.bawnorton.bettertrims.client.tooltip.TrimTooltipPage;
import com.bawnorton.bettertrims.client.tooltip.component.GapComponent;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.version.VGuiGraphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_768;

public class TrimPropertiesTooltip {
    private final Map<Matcher, List<TrimProperty>> properties;
    private final List<TrimTooltipPage> pages;
    private int index;

    public TrimPropertiesTooltip(Map<Matcher, List<TrimProperty>> properties) {
        this.properties = properties;
        this.pages = new ArrayList<TrimTooltipPage>();
    }

    public void generatePages(class_638 level, class_327 font) {
        this.pages.clear();
        for (Map.Entry<Matcher, List<TrimProperty>> entry : this.properties.entrySet()) {
            Matcher matcher = entry.getKey();
            List<TrimProperty> properties = entry.getValue();
            for (TrimProperty property : properties) {
                TrimTooltipPage page = new TrimTooltipPage(property, matcher);
                this.pages.add(page);
            }
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).generateComponent(level, font, i, this.pages.size());
        }
    }

    public void render(class_332 graphics, class_638 level, class_327 font, class_768 parentTooltipBounds, boolean horizontallyFlipped, class_2960 background) {
        if (this.index >= this.pages.size()) {
            return;
        }
        TrimTooltipPage page = this.pages.get(this.index);
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        components.add(page.getComponent());
        components.add(new GapComponent(page.getRenderedWidth(font), 0));
        int offsetX = parentTooltipBounds.method_3321() + parentTooltipBounds.method_3319() + (horizontallyFlipped ? 14 : 0);
        int offsetY = parentTooltipBounds.method_3322();
        VGuiGraphics.renderTooltip(graphics, font, components, offsetX, offsetY, new ExpandedTooltipPositioner(parentTooltipBounds.method_3319()), background);
    }

    public boolean mouseScrolled(double scrollY) {
        if (this.pages.size() <= 1) {
            return false;
        }
        if (scrollY > 0.0) {
            --this.index;
            if (this.index < 0) {
                this.index = this.pages.size() - 1;
            }
        } else if (scrollY < 0.0) {
            ++this.index;
            if (this.index >= this.pages.size()) {
                this.index = 0;
            }
        } else {
            return false;
        }
        return true;
    }
}

