/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.config.ConfigHandler;
import dev.worldgen.lithostitched.duck.StructurePoolAccess;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingConfig;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import dev.worldgen.lithostitched.worldgen.structure.BoxOctree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_8917;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, AlternateJigsawConfig config, boolean vanilla, int size, class_2338 pos, class_8891 aliasLookup) {
        class_2338 startPos;
        class_5455 registries = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_2919 random = context.comp_566();
        class_2378 registry = registries.method_30530(class_7924.field_41249);
        class_2470 rotation = config.fixedRotation() ? class_2470.field_11467 : class_2470.method_16548((class_5819)random);
        class_3784 startingElement = config.startPool().method_40230().flatMap(resourceKey -> registry.method_31189(aliasLookup.lookup(resourceKey))).orElse((class_3785)config.startPool().comp_349()).method_16631((class_5819)random);
        if (startingElement == class_3777.field_16663) {
            return Optional.empty();
        }
        Optional<class_2960> startJigsawName = config.startJigsawName();
        if (startJigsawName.isPresent()) {
            class_2960 identifier = startJigsawName.get();
            Optional<class_2338> optional = AlternateJigsawGenerator.findNamedJigsaw(startingElement, identifier, pos, rotation, structureTemplateManager, random);
            if (optional.isEmpty()) {
                Lithostitched.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)config.startPool().method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            startPos = optional.get();
        } else {
            startPos = pos;
        }
        class_2338 vec3i = startPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 piece = new class_3790(structureTemplateManager, startingElement, blockPos2, startingElement.method_19308(), rotation, startingElement.method_16628(structureTemplateManager, blockPos2, rotation), config.liquidSettings());
        class_3341 blockBox = piece.method_14935();
        int originX = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int originZ = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        Optional y = config.startProjection().map(either -> (Optional)either.map(snap -> snap.findY(new class_2338(originX, blockPos2.method_10264(), originZ), context, heightLimitView, context.comp_564()), type -> Optional.of(pos.method_10264() + chunkGenerator.method_20402(originX, originZ, type, heightLimitView, context.comp_564())))).orElseGet(() -> Optional.of(blockPos2.method_10264()));
        if (y.isEmpty()) {
            return Optional.empty();
        }
        int l = blockBox.method_35416() + piece.method_16646();
        piece.method_14922(0, (Integer)y.get() - l, 0);
        if (AlternateJigsawGenerator.pieceWithinPaddingBounds(heightLimitView, config.dimensionPadding(), piece.method_14935())) {
            return Optional.empty();
        }
        int originY = (Integer)y.get() + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(originX, originY, originZ), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(piece);
            if (size > 0) {
                AlternateJigsawConfig.MaxDistance maxDistance = config.maxDistanceFromCenter();
                class_238 box = new class_238((double)(originX - maxDistance.horizontal()), (double)Math.max(originY - maxDistance.vertical(), heightLimitView.method_31607() + config.dimensionPadding().comp_2818()), (double)(originZ - maxDistance.horizontal()), (double)(originX + maxDistance.horizontal() + 1), (double)Math.min(originY + maxDistance.vertical() + 1, heightLimitView.method_31600() - config.dimensionPadding().comp_2819()), (double)(originZ + maxDistance.horizontal() + 1));
                BoxOctree boxOctree = new BoxOctree(box);
                if (!AlternateJigsawGenerator.getConfig(startingElement).otherPiecesCanIntersect()) {
                    boxOctree.addBox(class_238.method_19316((class_3341)blockBox));
                }
                AlternateJigsawGenerator.generatePieces(context, vanilla, size, config.useExpansionHack(), chunkGenerator, structureTemplateManager, heightLimitView, (class_5819)random, (class_2378<class_3785>)registry, piece, list, boxOctree, aliasLookup, config.liquidSettings());
            }
            Objects.requireNonNull(collector);
            list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
        }));
    }

    private static boolean pieceWithinPaddingBounds(class_5539 levelHeightAccessor, class_9778 dimensionPadding, class_3341 boundingBox) {
        if (dimensionPadding == class_9778.field_51953) {
            return false;
        }
        int minY = levelHeightAccessor.method_31607() + dimensionPadding.comp_2818();
        int maxY = levelHeightAccessor.method_31600() - dimensionPadding.comp_2819();
        return boundingBox.method_35416() < minY || boundingBox.method_35419() > maxY;
    }

    private static Optional<class_2338> findNamedJigsaw(class_3784 pool, class_2960 name, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_2919 random) {
        List list = pool.method_16627(structureManager, pos, rotation, (class_5819)random);
        for (class_3499.class_10326 jigsawBlock : list) {
            if (!name.equals((Object)jigsawBlock.comp_3280())) continue;
            return Optional.of(jigsawBlock.comp_3278().comp_1341());
        }
        return Optional.empty();
    }

    private static void generatePieces(class_3195.class_7149 context, boolean vanilla, int maxSize, boolean useExpansionHack, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, BoxOctree boxOctree, class_8891 aliasLookup, class_9822 liquidSettings) {
        StructurePoolGenerator generator = new StructurePoolGenerator(context, vanilla, structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        generator.generatePiece(firstPiece, boxOctree, 0, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        while (generator.pieces.hasNext()) {
            PieceState pieceState = (PieceState)generator.pieces.next();
            generator.generatePiece(pieceState.piece, pieceState.octree, pieceState.currentSize, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        }
    }

    private static DelegatingConfig getConfig(class_3784 element) {
        DelegatingConfig delegatingConfig;
        if (element instanceof DelegatingPoolElement) {
            DelegatingPoolElement delegating = (DelegatingPoolElement)element;
            delegatingConfig = delegating.config();
        } else {
            delegatingConfig = new DelegatingConfig(element);
        }
        return delegatingConfig;
    }

    static final class StructurePoolGenerator {
        private final class_3195.class_7149 context;
        private final boolean vanilla;
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> piecesToPlace;
        private final class_5819 random;
        private final Map<class_2960, Integer> groupCounts = new HashMap<class_2960, Integer>();
        final class_8917<PieceState> pieces = new class_8917();

        private StructurePoolGenerator(class_3195.class_7149 context, boolean vanilla, class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.context = context;
            this.vanilla = vanilla;
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
        }

        private void generatePiece(class_3790 parentPiece, BoxOctree parentOctree, int depth, boolean useExpansionHack, class_5539 world, class_8891 aliasLookup, class_9822 liquidSettings) {
            class_3784 anchorElement = parentPiece.method_16644();
            class_3341 parentBoundingBox = parentPiece.method_14935();
            BoxOctree directParentOctree = null;
            for (class_3499.class_10326 anchorJigsaw : anchorElement.method_16627(this.structureTemplateManager, parentPiece.method_16648(), parentPiece.method_16888(), this.random)) {
                BoxOctree octree;
                class_3499.class_3501 anchorInfo = anchorJigsaw.comp_3278();
                class_2338 candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
                class_6880<class_3785> poolEntry = this.getTemplatePoolHolder((class_5321<class_3785>)aliasLookup.lookup(anchorJigsaw.comp_3281()));
                if (poolEntry == null) continue;
                boolean connectorInParentBoundingBox = parentBoundingBox.method_14662((class_2382)candidateConnectorPos);
                if (connectorInParentBoundingBox && !AlternateJigsawGenerator.getConfig(anchorElement).otherPiecesCanIntersect()) {
                    if (directParentOctree == null) {
                        directParentOctree = new BoxOctree(class_238.method_19316((class_3341)parentBoundingBox));
                    }
                    octree = directParentOctree;
                } else {
                    octree = parentOctree;
                }
                MutableObject checkedPools = new MutableObject(new ArrayList());
                this.findAndTestChildCandidates(poolEntry, (MutableObject<List<class_5321<class_3785>>>)checkedPools, parentPiece, anchorJigsaw, octree, -1, depth, useExpansionHack, world, true, aliasLookup, liquidSettings);
            }
        }

        private void findAndTestChildCandidates(class_6880<class_3785> entry, MutableObject<List<class_5321<class_3785>>> checkedPools, class_3790 parentPiece, class_3499.class_10326 anchorJigsawInfo, BoxOctree octree, int k, int depth, boolean useExpansionHack, class_5539 world, boolean firstIteration, class_8891 aliasLookup, class_9822 liquidSettings) {
            List<class_3784> childCandidates = this.getPoolElements((class_5321<class_3785>)entry.method_40230().orElse(class_5468.field_26254), checkedPools, depth, firstIteration);
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, octree, k, depth, useExpansionHack, world, aliasLookup, liquidSettings);
            if (!foundChild) {
                this.findAndTestChildCandidates((class_6880<class_3785>)((class_3785)entry.comp_349()).method_46736(), checkedPools, parentPiece, anchorJigsawInfo, octree, k, depth, useExpansionHack, world, false, aliasLookup, liquidSettings);
            }
        }

        private List<class_3784> getPoolElements(class_5321<class_3785> poolKey, MutableObject<List<class_5321<class_3785>>> checkedPools, int depth, boolean firstIteration) {
            if (poolKey == class_5468.field_26254) {
                return List.of();
            }
            if (ConfigHandler.getConfig().breaksSeedParity() || !this.vanilla) {
                if (((List)checkedPools.getValue()).contains(poolKey)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (class_5321 checkedPoolKey : (List)checkedPools.getValue()) {
                        stringBuilder.append(checkedPoolKey.method_29177()).append(" -> ");
                    }
                    stringBuilder.append(poolKey.method_29177());
                    Lithostitched.debug("Template pool fallback chain found: {}", stringBuilder);
                    return List.of();
                }
                ((List)checkedPools.getValue()).add(poolKey);
                class_6880 pool = (class_6880)this.registry.method_46746(poolKey).orElseThrow();
                if (depth == this.maxSize && firstIteration) {
                    pool = ((class_3785)pool.comp_349()).method_46736();
                }
                return ((StructurePoolAccess)pool.comp_349()).getLithostitchedTemplates().shuffle(this.random);
            }
            if (!firstIteration) {
                return List.of();
            }
            class_6880 pool = (class_6880)this.registry.method_46746(poolKey).orElseThrow();
            class_6880 fallback = ((class_3785)pool.comp_349()).method_46736();
            ArrayList<class_3784> elements = new ArrayList<class_3784>();
            if (depth != this.maxSize) {
                elements.addAll(((class_3785)pool.comp_349()).method_16633(this.random));
            }
            elements.addAll(((class_3785)fallback.comp_349()).method_16633(this.random));
            return elements;
        }

        private boolean findValidChildPiece(List<class_3784> elements, class_3790 parentPiece, class_3499.class_10326 anchorJigsaw, BoxOctree octree, int k, int depth, boolean useExpansionHack, class_5539 world, class_8891 aliasLookup, class_9822 liquidSettings) {
            class_3499.class_3501 anchorInfo = anchorJigsaw.comp_3278();
            class_2338 anchorPos = anchorInfo.comp_1341();
            class_2338 candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
            int parentMinY = parentPiece.method_14935().method_35416();
            int anchorDistanceToFloor = anchorPos.method_10264() - parentMinY;
            class_3785.class_3786 parentProjection = parentPiece.method_16644().method_16624();
            boolean parentRigid = parentProjection == class_3785.class_3786.field_16687;
            for (class_3784 element : elements) {
                if (element == class_3777.field_16663) {
                    return true;
                }
                DelegatingConfig config = new DelegatingConfig(element);
                boolean isDelegating = false;
                if (element instanceof DelegatingPoolElement) {
                    DelegatingPoolElement delegating = (DelegatingPoolElement)element;
                    config = delegating.config();
                    isDelegating = true;
                    if (config.shouldCancelPlacement(this.context, candidateConnectorPos, depth, this.groupCounts.getOrDefault(config.getName(), 0))) continue;
                }
                for (class_2470 rotation : class_2470.method_16547((class_5819)this.random)) {
                    List connectorJigsaws = element.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation, this.random);
                    class_3341 connectorBoundingBox = element.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation);
                    int l = useExpansionHack && connectorBoundingBox.method_14660() <= 16 ? connectorJigsaws.stream().mapToInt(jigsawInfo -> {
                        class_3499.class_3501 blockInfo = jigsawInfo.comp_3278();
                        if (!connectorBoundingBox.method_14662((class_2382)StructurePoolGenerator.adjustJigsawPos(blockInfo))) {
                            return 0;
                        }
                        class_5321 registryKey2 = aliasLookup.lookup(jigsawInfo.comp_3281());
                        Optional optional1 = this.registry.method_46746(registryKey2);
                        Optional<class_6880> optional2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_46736());
                        int i2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_10326 connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!class_3748.method_16546((class_3499.class_10326)anchorJigsaw, (class_3499.class_10326)connectorJigsawInfo)) continue;
                        class_2338 connectorPos = connectorJigsawInfo.comp_3278().comp_1341();
                        class_2338 blockPos5 = candidateConnectorPos.method_10059((class_2382)connectorPos);
                        class_3341 blockBox3 = element.method_16628(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.method_35416();
                        class_3785.class_3786 connectorProjection = element.method_16624();
                        boolean connectorProjectionRigid = connectorProjection == class_3785.class_3786.field_16687;
                        int connectorY = connectorPos.method_10264();
                        int o = anchorDistanceToFloor - connectorY + class_3748.method_26378((class_2680)anchorInfo.comp_1342()).method_10164();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, this.context.comp_564());
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                        class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.method_35419() - blockBox4.method_35416());
                            blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + r, blockBox4.method_35417()));
                        }
                        if (!config.allowBoundingBoxCollisions() && !octree.withinBoundsButNotIntersectingChildren(class_238.method_19316((class_3341)blockBox4).method_1011(0.25))) continue;
                        if (isDelegating) {
                            this.groupCounts.put(config.getName(), this.groupCounts.getOrDefault(config.getName(), 0) + 1);
                        }
                        if (!config.otherPiecesCanIntersect()) {
                            octree.addBox(class_238.method_19316((class_3341)blockBox4));
                        }
                        r = parentPiece.method_16646();
                        int s = connectorProjectionRigid ? r - o : element.method_19308();
                        class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, element, blockPos6, s, rotation, blockBox4, liquidSettings);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, this.context.comp_564());
                            }
                            t = k + o / 2;
                        }
                        parentPiece.method_16647(new class_3780(candidateConnectorPos.method_10263(), t - anchorDistanceToFloor + r, candidateConnectorPos.method_10260(), o, connectorProjection));
                        poolStructurePiece.method_16647(new class_3780(anchorPos.method_10263(), t - connectorY + s, anchorPos.method_10260(), -o, parentProjection));
                        this.piecesToPlace.add((class_3790)poolStructurePiece);
                        if (depth + 1 <= this.maxSize) {
                            PieceState pieceState = new PieceState(poolStructurePiece, octree, depth + 1);
                            this.pieces.method_54726((Object)pieceState, anchorJigsaw.comp_3283());
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private class_6880<class_3785> getTemplatePoolHolder(class_5321<class_3785> key) {
            Optional optional = this.registry.method_46746(key);
            if (optional.isEmpty()) {
                Lithostitched.LOGGER.warn("Couldn't find template pool reference: {}", (Object)key.method_29177());
            } else {
                class_6880 regularPool = (class_6880)optional.get();
                if (((class_3785)regularPool.comp_349()).method_16632() == 0) {
                    if (!regularPool.method_40225(class_5468.field_26254)) {
                        Lithostitched.LOGGER.warn("Referenced template pool is empty: {}", (Object)key.method_29177());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static class_2338 adjustJigsawPos(class_3499.class_3501 jigsawInfo) {
            return jigsawInfo.comp_1341().method_10093(class_3748.method_26378((class_2680)jigsawInfo.comp_1342()));
        }
    }

    private record PieceState(class_3790 piece, BoxOctree octree, int currentSize) {
    }
}

