/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public class ExperiencePointsRequirement
implements WarpRequirement {
    private int points;

    public ExperiencePointsRequirement(int points) {
        this.points = Math.max(0, points);
    }

    @Override
    public boolean canAfford(class_1657 player) {
        double xpForProgress;
        int xpForLevel = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(player.field_7520);
        double totalXp = (double)xpForLevel + (xpForProgress = Math.floor(player.field_7510 * (float)ExperiencePointsRequirement.getXpNeededForNextLevel(player.field_7520)));
        return totalXp >= (double)this.points;
    }

    @Override
    public void consume(class_1657 player) {
        player.method_7255(-this.points);
    }

    @Override
    public void rollback(class_1657 player) {
        player.method_7255(this.points);
    }

    @Override
    public void appendHoverText(class_1657 player, List<class_2561> tooltip) {
        if (this.points > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.waystones.waystone_selection.xp_requirement", (Object[])new Object[]{this.points}).method_27692(class_124.field_1060));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.points <= 0;
    }

    public static int calculateLevelCostFromExperiencePoints(int currentLevel, int xpLoss) {
        return currentLevel - ExperiencePointsRequirement.calculateLevelMinusExperiencePoints(currentLevel, xpLoss);
    }

    private static int calculateLevelMinusExperiencePoints(int currentLevel, int xpLoss) {
        int currentCumulativeXp = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(currentLevel);
        int remainingXp = currentCumulativeXp - xpLoss;
        int newLevel = 0;
        int newCumulativeXp = 0;
        for (int level = 0; level <= currentLevel; ++level) {
            if (remainingXp >= (newCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level))) continue;
            newLevel = level;
            break;
        }
        return newLevel;
    }

    private static int getXpNeededForNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int getCumulativeXpNeededForLevel(int targetLevel) {
        int currentCumulativeXp = 0;
        for (int level = 0; level < targetLevel; ++level) {
            currentCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level);
        }
        return currentCumulativeXp;
    }

    public void setPoints(int value) {
        this.points = value;
    }

    public int getPoints() {
        return this.points;
    }
}

