/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record ServerboundEditWaystonePacket(UUID waystoneUid, String name, WaystoneVisibility visibility) implements class_8710
{
    public static final class_8710.class_9154<ServerboundEditWaystonePacket> TYPE = new class_8710.class_9154(Waystones.id("edit_waystone"));
    public static final class_9139<class_9129, ServerboundEditWaystonePacket> STREAM_CODEC = class_9139.method_56436((class_9139)class_4844.field_48453, ServerboundEditWaystonePacket::waystoneUid, (class_9139)class_9135.field_48554, ServerboundEditWaystonePacket::name, (class_9139)class_9135.method_56375(it -> WaystoneVisibility.values()[it], Enum::ordinal), ServerboundEditWaystonePacket::visibility, ServerboundEditWaystonePacket::new);

    public static void handle(class_3222 player, ServerboundEditWaystonePacket message) {
        MinecraftServer server = player.method_51469().method_8503();
        WaystoneProxy waystone = new WaystoneProxy(server, message.waystoneUid);
        if (!waystone.isValid()) {
            Waystones.logger.warn("{} tried to edit an invalid waystone with id {}", (Object)player.method_5477().getString(), (Object)message.waystoneUid);
            return;
        }
        Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, waystone);
        if (error.isPresent()) {
            return;
        }
        WaystoneVisibility visibility = message.visibility;
        List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions(player, waystone);
        if (!visibilityOptions.contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.method_5477().getString(), (Object)message.visibility);
            visibility = visibilityOptions.getFirst();
        }
        if (!WaystonePermissionManager.isAllowedVisibility(visibility) && !WaystonePermissionManager.skipsPermissions(player)) {
            Waystones.logger.warn("{} tried to edit a restricted waystone without permission", (Object)player.method_5477().getString());
            return;
        }
        class_2338 pos = waystone.getPos();
        if (player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) > 64.0) {
            return;
        }
        WaystoneImpl backingWaystone = (WaystoneImpl)waystone.getBackingWaystone();
        class_2561 legalName = ServerboundEditWaystonePacket.makeNameLegal(server, message.name);
        backingWaystone.setName(legalName);
        if (visibility == WaystoneVisibility.GLOBAL && (WaystonePermissionManager.isAllowedVisibility(visibility) || WaystonePermissionManager.skipsPermissions(player)) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(server, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        SavedDataWaystonesStore.get(server).method_80();
        WaystoneSyncManager.sendWaystoneUpdateToAll(server, backingWaystone);
        player.method_7346();
    }

    private static class_2561 makeNameLegal(MinecraftServer server, String input) {
        if (input.trim().isEmpty()) {
            return class_2561.method_43471((String)"waystones.untitled_waystone");
        }
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(input) && SavedDataWaystonesStore.get(server).findWaystoneByName(input).isPresent()) {
            return class_2561.method_43470((String)(input + "*"));
        }
        return class_2561.method_43470((String)input);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

