/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.permission.ModPermissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class WaystonePermissionManager {
    private static final Set<WaystoneVisibility> DEFAULT_VISIBILITIES = Set.of(WaystoneVisibility.SHARD_ONLY, WaystoneVisibility.ACTIVATION, WaystoneVisibility.ORANGE_SHARESTONE, WaystoneVisibility.MAGENTA_SHARESTONE, WaystoneVisibility.LIGHT_BLUE_SHARESTONE, WaystoneVisibility.YELLOW_SHARESTONE, WaystoneVisibility.LIME_SHARESTONE, WaystoneVisibility.PINK_SHARESTONE, WaystoneVisibility.GRAY_SHARESTONE, WaystoneVisibility.LIGHT_GRAY_SHARESTONE, WaystoneVisibility.CYAN_SHARESTONE, WaystoneVisibility.PURPLE_SHARESTONE, WaystoneVisibility.BLUE_SHARESTONE, WaystoneVisibility.BROWN_SHARESTONE, WaystoneVisibility.GREEN_SHARESTONE, WaystoneVisibility.RED_SHARESTONE, WaystoneVisibility.BLACK_SHARESTONE);

    public static Optional<WaystoneEditError> mayEditWaystone(class_3222 player, Waystone waystone) {
        if (WaystonePermissionManager.skipsPermissions(player)) {
            return Optional.empty();
        }
        WaystonesConfig config = WaystonesConfig.getActive();
        if (waystone.hasOwner() && config.general.restrictedWaystones.contains((Object)WaystoneOrigin.PLAYER) && !waystone.isOwner((class_1657)player)) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (waystone.getOrigin() != WaystoneOrigin.PLAYER && config.general.restrictedWaystones.contains((Object)waystone.getOrigin())) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (!WaystonePermissionManager.isAllowedVisibility(waystone.getVisibility())) {
            return Optional.of(new WaystoneEditError.RequiresCreative());
        }
        return Optional.empty();
    }

    public static boolean isAllowedVisibility(WaystoneVisibility visibility) {
        WaystonesConfig config = WaystonesConfig.getActive();
        return DEFAULT_VISIBILITIES.contains((Object)visibility) || config.general.allowedVisibilities.contains((Object)visibility) || config.general.defaultVisibility == visibility;
    }

    public static boolean skipsPermissions(class_3222 player) {
        return Balm.permissions().hasPermission(player, ModPermissions.EDIT_ALL);
    }

    public static boolean isEntityDeniedTeleports(class_1297 entity) {
        Set<class_2960> deniedEntities = WaystonesConfig.getActive().teleports.entityDenyList;
        return deniedEntities.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()));
    }
}

