/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.noise_path;

import com.mojang.serialization.Codec;
import java.util.List;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config.NoiseBandBlockPlacement;
import net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config.NoiseBandPlacement;
import net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config.NoisePathFeatureConfig;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3756;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class NoisePathFeature
extends class_3031<NoisePathFeatureConfig> {
    public NoisePathFeature(Codec<NoisePathFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<NoisePathFeatureConfig> context) {
        boolean generated = false;
        NoisePathFeatureConfig config = (NoisePathFeatureConfig)context.method_33656();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        class_5819 random = level.method_8409();
        int radius = config.placementRadius();
        NoiseBandPlacement noiseBandPlacement = config.noiseBandPlacement();
        class_3756 sampler = noiseBandPlacement.getNoiseType().createNoise(level.method_8412());
        double noiseScale = noiseBandPlacement.getNoiseScale();
        boolean calculateNoiseWithY = noiseBandPlacement.calculateNoiseWithY();
        boolean scaleYNoise = noiseBandPlacement.scaleYNoise();
        List<NoiseBandBlockPlacement> blockPlacements = noiseBandPlacement.getBlockPlacements();
        class_2902.class_2903 heightmapType = noiseBandPlacement.getHeightmapType().orElse(null);
        boolean missingHeightmap = heightmapType == null;
        class_2338.class_2339 mutable = blockPos.method_25503();
        int startX = blockPos.method_10263();
        int startY = blockPos.method_10264();
        int startZ = blockPos.method_10260();
        for (int x = startX - radius; x <= startX + radius; ++x) {
            for (int z = startZ - radius; z <= startZ + radius; ++z) {
                if (!missingHeightmap) {
                    mutable.method_10103(x, level.method_8624(heightmapType, x, z) - 1, z);
                    if (!(AdvancedMath.distanceBetween(blockPos, (class_2338)mutable, false) < (double)radius)) continue;
                    generated = this.attemptPlaceForAllBlockPlacements(level, mutable, random, blockPlacements, sampler, noiseScale, calculateNoiseWithY, scaleYNoise) || generated;
                    continue;
                }
                for (int y = startY - radius; y <= startY + radius; ++y) {
                    mutable.method_10103(x, y, z);
                    if (!(AdvancedMath.distanceBetween(blockPos, (class_2338)mutable, true) < (double)radius)) continue;
                    generated = this.attemptPlaceForAllBlockPlacements(level, mutable, random, blockPlacements, sampler, noiseScale, calculateNoiseWithY, scaleYNoise) || generated;
                }
            }
        }
        return generated;
    }

    public boolean attemptPlaceForAllBlockPlacements(class_5281 level, class_2338.class_2339 pos, class_5819 random, @NotNull List<NoiseBandBlockPlacement> blockPlacements, class_3756 sampler, double noiseScale, boolean calculateNoiseWithY, boolean scaleYNoise) {
        double sampleOutput = EasyNoiseSampler.sample(sampler, (class_2382)pos, noiseScale, scaleYNoise, calculateNoiseWithY);
        for (NoiseBandBlockPlacement blockPlacement : blockPlacements) {
            if (!blockPlacement.generate(level, pos, random, sampleOutput)) continue;
            return true;
        }
        return false;
    }
}

