/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.block_predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.worldgen.feature.api.FrozenLibFeatureUtils;
import net.frozenblock.lib.worldgen.feature.api.block_predicate.FrozenLibBlockPredicateTypes;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_5281;
import net.minecraft.class_6646;
import net.minecraft.class_6647;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SearchInAreaBlockPredicate
implements class_6646 {
    public static final MapCodec<SearchInAreaBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6646.field_35054.fieldOf("block_predicate").forGetter(config -> config.blockPredicate), (App)Codec.INT.fieldOf("search_area").forGetter(config -> config.searchArea)).apply((Applicative)instance, SearchInAreaBlockPredicate::new));
    private final class_6646 blockPredicate;
    private final int searchArea;

    public SearchInAreaBlockPredicate(@NotNull class_6646 blockPredicate, int searchArea) {
        this.blockPredicate = blockPredicate;
        this.searchArea = searchArea;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasAirWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.field_35696, searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasAirOrWaterWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.field_35697, searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasAirOrLavaWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10124, class_2246.field_10164}), searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasAirOrWaterOrLavaWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10124, class_2246.field_10382, class_2246.field_10164}), searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasWaterWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10382}), searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasLavaWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10164}), searchArea);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SearchInAreaBlockPredicate hasWaterOrLavaWithin(int searchArea) {
        return new SearchInAreaBlockPredicate(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10382, class_2246.field_10164}), searchArea);
    }

    @NotNull
    public class_6647<?> method_38873() {
        return FrozenLibBlockPredicateTypes.SEARCH_IN_AREA;
    }

    public boolean test(class_5281 level, @NotNull class_2338 pos) {
        return FrozenLibFeatureUtils.matchesConditionNearby(level, pos, this.searchArea, this.blockPredicate);
    }
}

