/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.api.parameters;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import net.frozenblock.lib.worldgen.biome.impl.BiomeParameters;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class OverworldBiomeBuilderParameters {
    public static final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    public static final Map<class_2960, BiomeParameters> BIOMES = new LinkedHashMap<class_2960, BiomeParameters>();
    private static boolean hasRun = false;
    private static final List<class_6544.class_4762> OFF_COAST_POINTS = new ArrayList<class_6544.class_4762>();

    public static BiomeParameters getParameters(class_2960 location) {
        OverworldBiomeBuilderParameters.runBiomes();
        return OverworldBiomeBuilderParameters.getOrCreateParameters(location);
    }

    private static void runBiomes() {
        if (!hasRun) {
            hasRun = true;
            OverworldBiomeBuilderParameters.addBiomes(pair -> OverworldBiomeBuilderParameters.addParameters((class_2960)pair.getFirst(), (class_6544.class_4762)pair.getSecond()));
        }
    }

    public static BiomeParameters getParameters(@NotNull class_5321<class_1959> key) {
        return OverworldBiomeBuilderParameters.getParameters(key.method_29177());
    }

    private static void addParameters(class_2960 location, class_6544.class_4762 parameters) {
        BiomeParameters biomeParameters = OverworldBiomeBuilderParameters.getOrCreateParameters(location);
        biomeParameters.add(parameters);
    }

    private static BiomeParameters getOrCreateParameters(class_2960 location) {
        if (BIOMES.containsKey(location)) {
            return BIOMES.get(location);
        }
        BiomeParameters parameters = new BiomeParameters();
        BIOMES.put(location, parameters);
        return parameters;
    }

    @Contract(pure=true)
    public static List<class_6544.class_4762> points(@NotNull BiomeParameters parameters) {
        return parameters.points;
    }

    public static List<class_6544.class_4762> points(@NotNull class_5321<class_1959> key) {
        return OverworldBiomeBuilderParameters.points(key.method_29177());
    }

    public static List<class_6544.class_4762> points(class_2960 location) {
        return OverworldBiomeBuilderParameters.points(OverworldBiomeBuilderParameters.getParameters(location));
    }

    private static void addBiomes(Consumer<Pair<class_2960, class_6544.class_4762>> key) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new class_6554().method_38185(parameterPointResourceKeyPair -> builder.add(parameterPointResourceKeyPair));
        builder.build().forEach(parameterPointResourceKeyPair -> key.accept(new Pair((Object)((class_5321)parameterPointResourceKeyPair.getSecond()).method_29177(), (Object)((class_6544.class_4762)parameterPointResourceKeyPair.getFirst()))));
    }

    public static List<class_6544.class_4762> getOffCoastPoints() {
        OverworldBiomeBuilderParameters.runBiomes();
        return OFF_COAST_POINTS;
    }

    @Generated
    private OverworldBiomeBuilderParameters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

