/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.client.impl;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.core.client.api.FrustumUtil;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.client.api.ClientWindManagerExtension;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3756;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Environment(value=EnvType.CLIENT)
public final class ClientWindManager {
    public static final List<ClientWindManagerExtension> EXTENSIONS = new ObjectArrayList();
    private static final List<WindDisturbance<?>> WIND_DISTURBANCES_A = new ArrayList();
    private static final List<WindDisturbance<?>> WIND_DISTURBANCES_B = new ArrayList();
    private static boolean isSwitched;
    public static long time;
    public static boolean overrideWind;
    public static class_243 commandWind;
    public static double prevWindX;
    public static double prevWindY;
    public static double prevWindZ;
    public static double windX;
    public static double windY;
    public static double windZ;
    public static double prevLaggedWindX;
    public static double prevLaggedWindY;
    public static double prevLaggedWindZ;
    public static double laggedWindX;
    public static double laggedWindY;
    public static double laggedWindZ;
    public static boolean hasInitialized;
    public static class_3756 noise;

    public static List<WindDisturbance<?>> getWindDisturbances() {
        return !isSwitched ? WIND_DISTURBANCES_A : WIND_DISTURBANCES_B;
    }

    public static List<WindDisturbance<?>> getWindDisturbanceStash() {
        return isSwitched ? WIND_DISTURBANCES_A : WIND_DISTURBANCES_B;
    }

    public static void clearWindDisturbances() {
        ClientWindManager.getWindDisturbances().clear();
    }

    public static void clearAllWindDisturbances() {
        ClientWindManager.getWindDisturbances().clear();
        ClientWindManager.getWindDisturbanceStash().clear();
    }

    public static void clearAndSwitchWindDisturbances() {
        ClientWindManager.clearWindDisturbances();
        isSwitched = !isSwitched;
    }

    public static synchronized void addWindDisturbance(@NotNull WindDisturbance<?> windDisturbance) {
        ClientWindManager.getWindDisturbanceStash().add(windDisturbance);
    }

    public static void addExtension(@Nullable Supplier<ClientWindManagerExtension> extension) {
        if (extension != null) {
            ClientWindManager.addExtension(extension.get());
        }
    }

    public static void addExtension(@Nullable ClientWindManagerExtension extension) {
        if (extension != null) {
            EXTENSIONS.add(extension);
        }
    }

    public static void setSeed(long seed) {
        noise = EasyNoiseSampler.createXoroNoise(seed);
    }

    public static double getWindX(float partialTick) {
        return class_3532.method_16436((double)partialTick, (double)prevWindX, (double)windX);
    }

    public static double getWindY(float partialTick) {
        return class_3532.method_16436((double)partialTick, (double)prevWindY, (double)windY);
    }

    public static double getWindZ(float partialTick) {
        return class_3532.method_16436((double)partialTick, (double)prevWindZ, (double)windZ);
    }

    public static boolean shouldUseWind() {
        return hasInitialized || FrozenLibConfig.USE_WIND_ON_NON_FROZEN_SERVERS;
    }

    @ApiStatus.Internal
    public static void tick(@NotNull class_638 level) {
        Debug.tick(level);
        if (!level.method_54719().method_54751()) {
            return;
        }
        float thunderLevel = level.method_8478(1.0f) * 0.03f;
        prevWindX = windX;
        prevWindY = windY;
        prevWindZ = windZ;
        double calcTime = (double)(++time) * 5.0E-4;
        double calcTimeY = (double)time * 3.5E-4;
        class_243 vec3 = ClientWindManager.sampleVec3(noise, calcTime, calcTimeY, calcTime);
        windX = vec3.field_1352 + vec3.field_1352 * (double)thunderLevel;
        windY = vec3.field_1351 + vec3.field_1351 * (double)thunderLevel;
        windZ = vec3.field_1350 + vec3.field_1350 * (double)thunderLevel;
        prevLaggedWindX = laggedWindX;
        prevLaggedWindY = laggedWindY;
        prevLaggedWindZ = laggedWindZ;
        double calcLaggedTime = ((double)time - 40.0) * 5.0E-4;
        double calcLaggedTimeY = ((double)time - 60.0) * 3.5E-4;
        class_243 laggedVec = ClientWindManager.sampleVec3(noise, calcLaggedTime, calcLaggedTimeY, calcLaggedTime);
        laggedWindX = laggedVec.field_1352 + laggedVec.field_1352 * (double)thunderLevel;
        laggedWindY = laggedVec.field_1351 + laggedVec.field_1351 * (double)thunderLevel;
        laggedWindZ = laggedVec.field_1350 + laggedVec.field_1350 * (double)thunderLevel;
        for (ClientWindManagerExtension extension : EXTENSIONS) {
            extension.baseTick();
            extension.clientTick();
        }
        if (!hasInitialized && FrozenLibConfig.USE_WIND_ON_NON_FROZEN_SERVERS) {
            hasInitialized = true;
            class_5819 randomSource = AdvancedMath.random();
            noise = EasyNoiseSampler.createXoroNoise(randomSource.method_43055());
            time = randomSource.method_43055();
        }
    }

    @ApiStatus.Internal
    public static void reset() {
        hasInitialized = false;
        overrideWind = false;
        commandWind = class_243.field_1353;
        time = 0L;
        prevWindX = 0.0;
        prevWindY = 0.0;
        prevWindZ = 0.0;
        windX = 0.0;
        windY = 0.0;
        windZ = 0.0;
        prevLaggedWindX = 0.0;
        prevLaggedWindY = 0.0;
        prevLaggedWindZ = 0.0;
        laggedWindX = 0.0;
        laggedWindY = 0.0;
        laggedWindZ = 0.0;
        isSwitched = false;
        ClientWindManager.clearAllWindDisturbances();
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_2338 pos) {
        return ClientWindManager.getWindMovement(level, class_243.method_24955((class_2382)pos));
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_2338 pos, double scale) {
        return ClientWindManager.getWindMovement(level, class_243.method_24955((class_2382)pos), scale);
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_2338 pos, double scale, double clamp) {
        return ClientWindManager.getWindMovement(level, class_243.method_24955((class_2382)pos), scale, clamp);
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_243 pos) {
        return ClientWindManager.getWindMovement(level, pos, 1.0);
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_243 pos, double scale) {
        return ClientWindManager.getWindMovement(level, pos, scale, Double.MAX_VALUE);
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_243 pos, double scale, double clamp) {
        return ClientWindManager.getWindMovement(level, pos, scale, clamp, 1.0);
    }

    @NotNull
    public static class_243 getWindMovement(@NotNull class_1937 level, @NotNull class_243 pos, double scale, double clamp, double windDisturbanceScale) {
        if (!ClientWindManager.shouldUseWind()) {
            return class_243.field_1353;
        }
        double brightness = level.method_8314(class_1944.field_9284, class_2338.method_49638((class_2374)pos));
        double windScale = Math.max(brightness - Math.max(15.0 - brightness, 0.0), 0.0) * 0.0667;
        Pair<Double, class_243> disturbance = WindManager.calculateWindDisturbance(ClientWindManager.getWindDisturbances(), level, pos);
        double disturbanceAmount = (Double)disturbance.getFirst();
        class_243 windDisturbance = (class_243)disturbance.getSecond();
        double newWindX = class_3532.method_16436((double)disturbanceAmount, (double)(windX * windScale), (double)(windDisturbance.field_1352 * windDisturbanceScale)) * scale;
        double newWindY = class_3532.method_16436((double)disturbanceAmount, (double)(windY * windScale), (double)(windDisturbance.field_1351 * windDisturbanceScale)) * scale;
        double newWindZ = class_3532.method_16436((double)disturbanceAmount, (double)(windZ * windScale), (double)(windDisturbance.field_1350 * windDisturbanceScale)) * scale;
        if (FrozenLibConstants.DEBUG_WIND) {
            Debug.addAccessedPosition(pos);
        }
        return new class_243(class_3532.method_15350((double)newWindX, (double)(-clamp), (double)clamp), class_3532.method_15350((double)newWindY, (double)(-clamp), (double)clamp), class_3532.method_15350((double)newWindZ, (double)(-clamp), (double)clamp));
    }

    @NotNull
    public static class_243 getRawDisturbanceMovement(@NotNull class_1937 level, @NotNull class_243 pos) {
        Pair<Double, class_243> disturbance = WindManager.calculateWindDisturbance(ClientWindManager.getWindDisturbances(), level, pos);
        double disturbanceAmount = (Double)disturbance.getFirst();
        class_243 windDisturbance = (class_243)disturbance.getSecond();
        double newWindX = class_3532.method_16436((double)disturbanceAmount, (double)0.0, (double)windDisturbance.field_1352);
        double newWindY = class_3532.method_16436((double)disturbanceAmount, (double)0.0, (double)windDisturbance.field_1351);
        double newWindZ = class_3532.method_16436((double)disturbanceAmount, (double)0.0, (double)windDisturbance.field_1350);
        return new class_243(newWindX, newWindY, newWindZ);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_2338 pos, double stretch) {
        return ClientWindManager.getWindMovement3D(class_243.method_24955((class_2382)pos), stretch);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_2338 pos, double scale, double stretch) {
        return ClientWindManager.getWindMovement3D(class_243.method_24955((class_2382)pos), scale, stretch);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_2338 pos, double scale, double clamp, double stretch) {
        return ClientWindManager.getWindMovement3D(class_243.method_24955((class_2382)pos), scale, clamp, stretch);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_243 pos, double stretch) {
        return ClientWindManager.getWindMovement3D(pos, 1.0, stretch);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_243 pos, double scale, double stretch) {
        return ClientWindManager.getWindMovement3D(pos, scale, Double.MAX_VALUE, stretch);
    }

    @Deprecated
    @NotNull
    public static class_243 getWindMovement3D(@NotNull class_243 pos, double scale, double clamp, double stretch) {
        class_243 wind = ClientWindManager.sample3D(pos, stretch);
        return new class_243(class_3532.method_15350((double)(wind.method_10216() * scale), (double)(-clamp), (double)clamp), class_3532.method_15350((double)(wind.method_10214() * scale), (double)(-clamp), (double)clamp), class_3532.method_15350((double)(wind.method_10215() * scale), (double)(-clamp), (double)clamp));
    }

    @NotNull
    public static class_243 sampleVec3(@NotNull class_3756 sampler, double x, double y, double z) {
        if (ClientWindManager.shouldUseWind()) {
            if (!overrideWind) {
                double windX = sampler.method_33658(x, 0.0, 0.0);
                double windY = sampler.method_33658(0.0, y, 0.0);
                double windZ = sampler.method_33658(0.0, 0.0, z);
                return new class_243(windX, windY, windZ);
            }
            return commandWind;
        }
        return class_243.field_1353;
    }

    @Deprecated
    @NotNull
    public static class_243 sample3D(@NotNull class_243 pos, double stretch) {
        if (!ClientWindManager.shouldUseWind()) {
            return class_243.field_1353;
        }
        double sampledTime = (double)time * 0.1;
        double xyz = pos.method_10216() + pos.method_10214() + pos.method_10215();
        double windX = noise.method_33658((xyz + sampledTime) * stretch, 0.0, 0.0);
        double windY = noise.method_33658(0.0, (xyz + sampledTime) * stretch, 0.0);
        double windZ = noise.method_33658(0.0, 0.0, (xyz + sampledTime) * stretch);
        return new class_243(windX, windY, windZ);
    }

    static {
        commandWind = class_243.field_1353;
        noise = EasyNoiseSampler.createXoroNoise(0L);
    }

    @class_5996
    public static class Debug {
        private static final List<class_243> ACCESSED_POSITIONS = new ArrayList<class_243>();
        private static final List<WindDisturbance<?>> WIND_DISTURBANCES = new ArrayList();
        private static final List<List<Pair<class_243, Integer>>> DEBUG_NODES = new ArrayList<List<Pair<class_243, Integer>>>();
        private static final List<List<Pair<class_243, Integer>>> DEBUG_DISTURBANCE_NODES = new ArrayList<List<Pair<class_243, Integer>>>();

        public static void tick(class_638 level) {
            WIND_DISTURBANCES.clear();
            DEBUG_NODES.clear();
            DEBUG_DISTURBANCE_NODES.clear();
            if (FrozenLibConstants.DEBUG_WIND) {
                DEBUG_NODES.addAll(Debug.createWindNodes(level));
            }
            if (FrozenLibConstants.DEBUG_WIND_DISTURBANCES) {
                WIND_DISTURBANCES.addAll(Debug.getWindDisturbances());
                DEBUG_DISTURBANCE_NODES.addAll(Debug.createWindDisturbanceNodes(level));
            }
            ACCESSED_POSITIONS.clear();
        }

        @class_5996
        public static void addAccessedPosition(class_243 vec3) {
            ACCESSED_POSITIONS.add(vec3);
        }

        @class_5996
        public static void clear() {
            ACCESSED_POSITIONS.clear();
            WIND_DISTURBANCES.clear();
            DEBUG_NODES.clear();
            DEBUG_DISTURBANCE_NODES.clear();
        }

        @class_5996
        @NotNull
        public static List<List<Pair<class_243, Integer>>> getDebugNodes() {
            return DEBUG_NODES;
        }

        @NotNull
        private static List<List<Pair<class_243, Integer>>> createWindNodes(class_638 level) {
            ArrayList<List<Pair<class_243, Integer>>> windNodes = new ArrayList<List<Pair<class_243, Integer>>>();
            ACCESSED_POSITIONS.forEach(vec3 -> {
                if (!FrustumUtil.isVisible(vec3, 0.5)) {
                    return;
                }
                windNodes.add(Debug.createWindNodes((class_1937)level, vec3, 1.5, false));
            });
            return windNodes;
        }

        @class_5996
        @NotNull
        public static @Unmodifiable List<WindDisturbance<?>> getWindDisturbances() {
            return ImmutableList.copyOf(WIND_DISTURBANCES);
        }

        @class_5996
        @NotNull
        public static List<List<Pair<class_243, Integer>>> getDebugDisturbanceNodes() {
            return DEBUG_DISTURBANCE_NODES;
        }

        @NotNull
        private static List<List<Pair<class_243, Integer>>> createWindDisturbanceNodes(class_638 level) {
            ArrayList<List<Pair<class_243, Integer>>> windNodes = new ArrayList<List<Pair<class_243, Integer>>>();
            WIND_DISTURBANCES.forEach(windDisturbance -> {
                if (FrustumUtil.isVisible(windDisturbance.affectedArea)) {
                    class_2338.method_10097((class_2338)class_2338.method_49638((class_2374)windDisturbance.affectedArea.method_61125()), (class_2338)class_2338.method_49638((class_2374)windDisturbance.affectedArea.method_61126())).forEach(blockPos -> {
                        class_243 blockPosCenter = class_243.method_24953((class_2382)blockPos);
                        windNodes.add(Debug.createWindNodes((class_1937)level, blockPosCenter, 1.0, true));
                    });
                }
            });
            return windNodes;
        }

        @NotNull
        private static List<Pair<class_243, Integer>> createWindNodes(class_1937 level, class_243 origin, double stretch, boolean disturbanceOnly) {
            ArrayList<Pair<class_243, Integer>> windNodes = new ArrayList<Pair<class_243, Integer>>();
            class_243 wind = disturbanceOnly ? ClientWindManager.getRawDisturbanceMovement(level, origin) : ClientWindManager.getWindMovement(level, origin);
            double windlength = wind.method_1033();
            if (windlength != 0.0) {
                int increments = 3;
                class_243 lineStart = origin;
                double windLineScale = 1.0 / (double)increments * stretch;
                windNodes.add((Pair<class_243, Integer>)Pair.of((Object)lineStart, (Object)Debug.calculateNodeColor(Math.min(1.0, windlength), disturbanceOnly)));
                for (int i = 0; i < increments; ++i) {
                    class_243 lineEnd = lineStart.method_1019(wind.method_1021(windLineScale));
                    windNodes.add((Pair<class_243, Integer>)Pair.of((Object)lineEnd, (Object)Debug.calculateNodeColor(Math.min(1.0, windlength), disturbanceOnly)));
                    lineStart = lineEnd;
                    wind = disturbanceOnly ? ClientWindManager.getRawDisturbanceMovement(level, lineStart) : ClientWindManager.getWindMovement(level, lineStart);
                }
            }
            return windNodes;
        }

        private static int calculateNodeColor(double strength, boolean disturbanceOnly) {
            return class_9848.method_61324((int)255, (int)((int)class_3532.method_16436((double)strength, (double)255.0, (double)0.0)), (int)((int)class_3532.method_16436((double)strength, (double)90.0, (double)255.0)), (int)(disturbanceOnly ? 0 : 255));
        }
    }
}

