/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.ValueWriter;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface WritingFunction {
    default public void write(Writer tw, JsonValue value) throws IOException {
        this.write(tw, value, JsonContext.getDefaultFormatting());
    }

    public void write(Writer var1, JsonValue var2, @Nullable JsonWriterOptions var3) throws IOException;

    default public void write(Path file, JsonValue value) throws IOException {
        this.write(file, value, JsonContext.getDefaultFormatting());
    }

    default public void write(Path file, JsonValue value, @Nullable JsonWriterOptions options) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.write(writer, value, options);
        }
    }

    default public void write(OutputStream os, JsonValue value) throws IOException {
        this.write(os, value, JsonContext.getDefaultFormatting());
    }

    default public void write(OutputStream os, JsonValue value, @Nullable JsonWriterOptions options) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os);){
            this.write(writer, value, options);
        }
    }

    default public String stringify(JsonValue value) {
        return this.stringify(value, JsonContext.getDefaultFormatting());
    }

    default public String stringify(JsonValue value, @Nullable JsonWriterOptions options) {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw, value, options);
        }
        catch (IOException e) {
            throw new IllegalStateException("Writer threw unexpected error", e);
        }
        return sw.toString();
    }

    public static WritingFunction fromWriter(ValueWriter.WriterConstructor c) {
        return (tw, value, options) -> c.construct(tw, options).write(value);
    }
}

