/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.CommentToken;

public abstract class PositionTrackingReader
implements Closeable {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected static final int MIN_BUFFER_SIZE = 8;
    public int index = -1;
    public int line = 0;
    public int column = -1;
    public int linesSkipped;
    public int current;
    protected StringBuilder capture;
    protected int captureStart = -1;

    protected PositionTrackingReader() {
    }

    public static PositionTrackingReader fromString(String s) {
        return new DirectStringReader(s);
    }

    public static PositionTrackingReader fromIs(InputStream is) throws IOException {
        return PositionTrackingReader.fromIs(is, false);
    }

    public static PositionTrackingReader fromIs(InputStream is, boolean captureFullText) throws IOException {
        return PositionTrackingReader.fromIs(is, 1024, captureFullText);
    }

    public static PositionTrackingReader fromIs(InputStream is, int size, boolean captureFullText) throws IOException {
        return PositionTrackingReader.fromReader(new InputStreamReader(is, StandardCharsets.UTF_8), size, captureFullText);
    }

    public static PositionTrackingReader fromReader(Reader reader) throws IOException {
        return PositionTrackingReader.fromReader(reader, false);
    }

    public static PositionTrackingReader fromReader(Reader reader, boolean captureFullText) throws IOException {
        return PositionTrackingReader.fromReader(reader, 1024, captureFullText);
    }

    public static PositionTrackingReader fromReader(Reader reader, int size, boolean captureFullText) throws IOException {
        if (size < 8) {
            throw new IllegalArgumentException("buffer size < 8");
        }
        return new ReaderReader(reader, size, captureFullText);
    }

    public abstract CharSequence getFullText();

    public abstract boolean isCapturingFullText();

    protected abstract void appendToCapture();

    public abstract PositionTrackingReader capturingFullText();

    public abstract void read() throws IOException;

    public abstract int peek() throws IOException;

    public boolean readIf(char c) throws IOException {
        if (this.current != c) {
            return false;
        }
        this.read();
        return true;
    }

    public void expect(char c) throws IOException {
        if (!this.readIf(c)) {
            throw this.expected(c);
        }
    }

    public String readToEnd() throws IOException {
        do {
            this.read();
        } while (!this.isEndOfText());
        return this.getFullText().toString();
    }

    public void startCapture() {
        if (this.capture == null) {
            this.capture = new StringBuilder();
        }
        this.captureStart = this.index;
    }

    public void pauseCapture() {
        this.appendToCapture();
        this.captureStart = -1;
    }

    public String endCapture() {
        return this.endCapture(this.index);
    }

    public String endCapture(int e) {
        this.appendToCapture();
        if (e < this.index) {
            this.capture.setLength(this.capture.length() - (this.index - e));
        }
        String captured = this.capture.toString();
        this.capture.setLength(0);
        this.captureStart = -1;
        return captured;
    }

    public void invalidateCapture() {
        if (this.capture != null) {
            this.capture.setLength(0);
        }
        this.captureStart = -1;
    }

    public void skipWhitespace() throws IOException {
        this.skipWhitespace(true);
    }

    public void skipWhitespace(boolean reset) throws IOException {
        if (reset) {
            this.linesSkipped = 0;
        }
        while (this.isWhitespace()) {
            this.read();
        }
    }

    public void skipLineWhitespace() throws IOException {
        while (this.isLineWhitespace()) {
            this.read();
        }
    }

    public int skipToOffset(int offset) throws IOException {
        for (int i = 0; i < offset; ++i) {
            if (!this.isLineWhitespace()) {
                return i + 1;
            }
            this.read();
        }
        return offset;
    }

    public int skipToNL() throws IOException {
        int last = this.index;
        while (this.current != 10 && this.current != -1) {
            if (!this.isLineWhitespace()) {
                last = this.index + 1;
            }
            this.read();
        }
        return last;
    }

    public boolean readDigit() throws IOException {
        if (!this.isDigit()) {
            return false;
        }
        this.read();
        return true;
    }

    public boolean readInfinity() throws IOException {
        if (this.current == 73) {
            return this.readCharacters(new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'});
        }
        return this.readCharacters(new char[]{'i', 'n', 'f', 'i', 'n', 'i', 't', 'y'});
    }

    public boolean readCharacters(char[] chars) throws IOException {
        for (char c : chars) {
            if (this.readIf(c)) continue;
            return false;
        }
        if (this.current != -1 && !this.isWhitespace()) {
            throw this.unexpected('y');
        }
        return true;
    }

    public void readAllDigits() throws IOException {
        while (this.isDigit()) {
            this.read();
        }
    }

    public double readNumber() throws IOException {
        this.startCapture();
        this.readIf('-');
        int firstDigit = this.current;
        if (!this.readDigit()) {
            throw this.expected("digit");
        }
        if (firstDigit != 48) {
            this.readAllDigits();
        }
        this.readDecimal();
        this.readExponent();
        return Double.parseDouble(this.endCapture());
    }

    public boolean readDecimal() throws IOException {
        if (!this.readIf('.')) {
            return false;
        }
        if (!this.readDigit()) {
            throw this.expected("digit");
        }
        this.readAllDigits();
        return true;
    }

    public boolean readExponent() throws IOException {
        if (!this.readIf('e') && !this.readIf('E')) {
            return false;
        }
        if (!this.readIf('+')) {
            this.readIf('-');
        }
        if (!this.readDigit()) {
            throw this.expected("digit");
        }
        this.readAllDigits();
        return true;
    }

    public String readQuoted(char quote) throws IOException {
        this.read();
        this.startCapture();
        while (this.current != quote) {
            if (this.current == 92) {
                this.pauseCapture();
                this.readEscape(quote);
                this.startCapture();
                continue;
            }
            if (this.current < 32) {
                throw this.expected("valid string character");
            }
            this.read();
        }
        String string = this.endCapture();
        this.read();
        return string;
    }

    protected void readEscape(char quote) throws IOException {
        this.read();
        if (this.current == quote) {
            this.capture.append(quote);
            this.read();
            return;
        }
        switch (this.current) {
            case 34: 
            case 47: 
            case 92: {
                this.capture.append((char)this.current);
                break;
            }
            case 98: {
                this.capture.append('\b');
                break;
            }
            case 102: {
                this.capture.append('\f');
                break;
            }
            case 110: {
                this.capture.append('\n');
                break;
            }
            case 114: {
                this.capture.append('\r');
                break;
            }
            case 116: {
                this.capture.append('\t');
                break;
            }
            case 117: {
                char[] hexChars = new char[4];
                for (int i = 0; i < 4; ++i) {
                    this.read();
                    if (!this.isHexDigit()) {
                        throw this.expected("hexadecimal digit");
                    }
                    hexChars[i] = (char)this.current;
                }
                this.capture.append((char)Integer.parseInt(new String(hexChars), 16));
                break;
            }
            default: {
                throw this.expected("valid escape sequence");
            }
        }
        this.read();
    }

    public String readMulti(boolean readQuotes) throws IOException {
        if (readQuotes) {
            this.expect('\'');
            this.expect('\'');
            this.expect('\'');
        }
        StringBuilder sb = new StringBuilder();
        int offset = this.column - 3;
        this.skipLineWhitespace();
        if (this.current == 10) {
            this.read();
            this.skipToOffset(offset);
        }
        int triple = 0;
        while (true) {
            if (this.current < 0) {
                throw this.expected("end of multiline string (''')");
            }
            if (this.current == 39) {
                this.read();
                if (++triple != 3) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                return sb.toString();
            }
            while (triple > 0) {
                sb.append('\'');
                --triple;
            }
            if (this.current == 10) {
                sb.append('\n');
                this.read();
                this.skipToOffset(offset);
                continue;
            }
            if (this.current != 13) {
                sb.append((char)this.current);
            }
            this.read();
        }
    }

    public CommentToken readLineComment() throws IOException {
        int s = this.index - 1;
        int o = this.column - 1;
        this.expect('/');
        if (this.readIf('/')) {
            return this.readSingleComment(CommentStyle.LINE_DOC, s, o);
        }
        return this.readSingleComment(CommentStyle.LINE, s, o);
    }

    public CommentToken readHashComment() throws IOException {
        this.expect('#');
        return this.readSingleComment(CommentStyle.HASH, this.index - 1, this.column - 1);
    }

    private CommentToken readSingleComment(CommentStyle type, int s, int o) throws IOException {
        if (this.isLineWhitespace()) {
            this.read();
        }
        this.startCapture();
        int e = this.skipToNL();
        return new CommentToken(s, e, this.line, o, type, this.endCapture(e));
    }

    public CommentToken readBlockComment() throws IOException {
        int s = this.index - 1;
        int o = this.column - 1;
        this.expect('*');
        if (this.readIf('*')) {
            return this.readMultiComment(CommentStyle.MULTILINE_DOC, s, o);
        }
        return this.readMultiComment(CommentStyle.BLOCK, s, o);
    }

    private CommentToken readMultiComment(CommentStyle type, int s, int o) throws IOException {
        int line = this.line;
        this.skipLineWhitespace();
        this.readIf('\n');
        StringBuilder output = new StringBuilder();
        while (true) {
            if (this.current == -1) {
                throw this.expected("end of comment (*/)");
            }
            int lineStart = this.skipToBlockLineStart();
            if (lineStart == -1) {
                this.expect('/');
                break;
            }
            this.appendLine(output, lineStart);
            if (this.readIf('/')) break;
            if (this.current == -1) continue;
            this.read();
        }
        int len = output.length();
        if (len > 0 && output.charAt(len - 1) == '\n') {
            output.setLength(len - 1);
        }
        return new CommentToken(s, this.index, line, this.line, o, type, output.toString());
    }

    protected int skipToBlockLineStart() throws IOException {
        this.skipLineWhitespace();
        if (this.current == 42) {
            this.read();
            if (this.current == 47) {
                return -1;
            }
            if (this.isLineWhitespace()) {
                this.read();
            }
        }
        return this.index;
    }

    protected void appendLine(StringBuilder output, int lineStart) throws IOException {
        int lastChar = output.length();
        while (this.current != -1) {
            if (this.current == 10) {
                output.setLength(lastChar);
                output.append('\n');
                return;
            }
            if (this.current == 42) {
                output.append((char)this.current);
                this.read();
                if (this.current == 47) {
                    output.setLength(lastChar);
                    return;
                }
                lastChar = output.length() + 1;
            } else if (!this.isWhitespace()) {
                lastChar = output.length() + 1;
            }
            output.append((char)this.current);
            this.read();
        }
    }

    public boolean isLineWhitespace() {
        return this.current == 32 || this.current == 9 || this.current == 13;
    }

    public boolean isWhitespace() {
        return this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13;
    }

    public boolean isDigit() {
        return this.current >= 48 && this.current <= 57;
    }

    public boolean isHexDigit() {
        return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
    }

    public boolean isEndOfText() {
        return this.current == -1;
    }

    public SyntaxException expected(char expected) {
        return SyntaxException.expected(expected, this.line, this.column);
    }

    public SyntaxException expected(String expected) {
        return SyntaxException.expected(expected, this.line, this.column);
    }

    public SyntaxException unexpected() {
        return this.unexpected((char)this.current);
    }

    public SyntaxException unexpected(char unexpected) {
        return SyntaxException.unexpected(unexpected, this.line, this.column);
    }

    public SyntaxException unexpected(String unexpected) {
        return SyntaxException.unexpected(unexpected, this.line, this.column);
    }

    private static class DirectStringReader
    extends PositionTrackingReader {
        final String s;

        DirectStringReader(String s) {
            this.s = s;
            this.read();
        }

        @Override
        public String getFullText() {
            return this.s;
        }

        @Override
        public boolean isCapturingFullText() {
            return true;
        }

        @Override
        public PositionTrackingReader capturingFullText() {
            return this;
        }

        @Override
        protected void appendToCapture() {
            this.capture.append(this.s, this.captureStart, this.index);
        }

        @Override
        public int peek() {
            int i = this.index;
            String s = this.s;
            return i < s.length() - 1 ? (int)s.charAt(i + 1) : -1;
        }

        @Override
        public void read() {
            if (this.index == this.s.length() - 1) {
                this.index = this.s.length();
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                ++this.linesSkipped;
                this.column = -1;
            }
            ++this.column;
            this.current = this.s.charAt(++this.index);
        }

        @Override
        public void close() {
        }
    }

    private static class ReaderReader
    extends PositionTrackingReader {
        final Reader reader;
        final char[] buffer;
        StringBuilder out;
        int bufferIndex;
        int fill;

        ReaderReader(Reader reader, int size, boolean captureFullText) throws IOException {
            this.reader = reader;
            this.buffer = new char[size];
            this.bufferIndex = 0;
            this.fill = 0;
            if (captureFullText) {
                this.out = new StringBuilder();
            }
            this.read();
        }

        @Override
        public CharSequence getFullText() {
            if (this.out == null) {
                throw new UnsupportedOperationException("output not configured");
            }
            return this.out;
        }

        @Override
        public boolean isCapturingFullText() {
            return this.out != null;
        }

        @Override
        public PositionTrackingReader capturingFullText() {
            if (this.out == null) {
                this.out = new StringBuilder();
                if (this.fill != -1) {
                    this.out.append(this.buffer, 0, this.fill);
                }
            }
            return this;
        }

        @Override
        public void startCapture() {
            if (this.capture == null) {
                this.capture = new StringBuilder();
            }
            this.captureStart = this.bufferIndex - 1;
        }

        @Override
        protected void appendToCapture() {
            int end = this.current == -1 ? this.bufferIndex : this.bufferIndex - 1;
            this.capture.append(this.buffer, this.captureStart, end - this.captureStart);
        }

        @Override
        public int peek() throws IOException {
            if (this.current == -1) {
                return -1;
            }
            if (this.bufferIndex < this.fill) {
                return this.buffer[this.bufferIndex];
            }
            if (this.captureStart != -1) {
                this.appendToCapture();
                this.captureStart = 0;
            }
            this.fill = 1 + this.reader.read(this.buffer, 1, this.buffer.length - 1);
            this.buffer[0] = (char)this.current;
            this.bufferIndex = 1;
            if (this.fill == 0) {
                return -1;
            }
            if (this.out != null) {
                this.out.append(this.buffer, 1, this.fill - 1);
            }
            return this.buffer[this.bufferIndex];
        }

        @Override
        public void read() throws IOException {
            if (this.bufferIndex == this.fill) {
                if (this.captureStart != -1) {
                    ++this.bufferIndex;
                    this.appendToCapture();
                    this.captureStart = 0;
                }
                this.fill = this.reader.read(this.buffer, 0, this.buffer.length);
                this.bufferIndex = 0;
                if (this.fill == -1) {
                    ++this.index;
                    this.current = -1;
                    return;
                }
                if (this.out != null) {
                    this.out.append(this.buffer, 0, this.fill);
                }
            }
            if (this.current == 10) {
                ++this.line;
                ++this.linesSkipped;
                this.column = -1;
            }
            ++this.index;
            ++this.column;
            this.current = this.buffer[this.bufferIndex++];
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

